/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.classloader;

import gov.va.med.lom.javaUtils.classloader.ClassLoaderStrategy;
import gov.va.med.lom.javaUtils.classloader.FileSystemClassLoader;
import gov.va.med.lom.javaUtils.classloader.HashtableClassLoader;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class CompositeClassLoader
extends ClassLoader
implements ClassLoaderStrategy {
    private Vector loaders = new Vector();

    public CompositeClassLoader() {
        this(CompositeClassLoader.class.getClassLoader(), null);
    }

    public CompositeClassLoader(ClassLoaderStrategy[] loaders) {
        this(CompositeClassLoader.class.getClassLoader(), loaders);
    }

    public CompositeClassLoader(ClassLoader parent) {
        this(parent, null);
    }

    public CompositeClassLoader(ClassLoader parent, ClassLoaderStrategy[] strategies) {
        super(CompositeClassLoader.class.getClassLoader());
        if (this.loaders != null && strategies.length > 0) {
            for (int i = 0; i < strategies.length; ++i) {
                this.loaders.addElement(strategies[i]);
            }
        }
    }

    public void addLoader(ClassLoaderStrategy cls) {
        this.loaders.addElement(cls);
    }

    public Enumeration enumLoaders() {
        return this.loaders.elements();
    }

    public void removeLoader(ClassLoaderStrategy cls) {
        this.loaders.remove(cls);
    }

    public byte[] findClassBytes(String className) {
        byte[] bytecode = null;
        Enumeration en = this.enumLoaders();
        while (en.hasMoreElements()) {
            ClassLoaderStrategy strat = (ClassLoaderStrategy)en.nextElement();
            bytecode = strat.findClassBytes(className);
            if (bytecode == null) continue;
            return bytecode;
        }
        return bytecode;
    }

    public URL findResourceURL(String resourceName) {
        URL resource = null;
        Enumeration en = this.enumLoaders();
        while (en.hasMoreElements()) {
            ClassLoaderStrategy strat = (ClassLoaderStrategy)en.nextElement();
            resource = strat.findResourceURL(resourceName);
            if (resource == null) continue;
            return resource;
        }
        return resource;
    }

    public Enumeration findResourcesEnum(String resourceName) {
        Enumeration resourceEnum = null;
        Enumeration en = this.enumLoaders();
        while (en.hasMoreElements()) {
            ClassLoaderStrategy strat = (ClassLoaderStrategy)en.nextElement();
            resourceEnum = strat.findResourcesEnum(resourceName);
            if (resourceEnum == null) continue;
            return resourceEnum;
        }
        return resourceEnum;
    }

    public String findLibraryPath(String libraryName) {
        String libPath = null;
        Enumeration en = this.enumLoaders();
        while (en.hasMoreElements()) {
            ClassLoaderStrategy strat = (ClassLoaderStrategy)en.nextElement();
            libPath = strat.findLibraryPath(libraryName);
            if (libPath == null) continue;
            return libPath;
        }
        return libPath;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = this.findClassBytes(name);
        if (classBytes == null) {
            throw new ClassNotFoundException();
        }
        return this.defineClass(name, classBytes, 0, classBytes.length);
    }

    public String[] getClassNames() {
        return null;
    }

    public Class[] getClasses(String classPath) throws ClassNotFoundException {
        return null;
    }

    public Class[] getClasses(String sourcePath, String classPath) throws ClassNotFoundException {
        return null;
    }

    public static void main(String[] args) throws Exception {
        ClassLoaderStrategy[] classLoaderArray = new ClassLoaderStrategy[]{new FileSystemClassLoader(System.getProperties().getProperty("testing.dir")), new HashtableClassLoader()};
        FileInputStream fis = new FileInputStream("/Hello.class");
        int ct = fis.available();
        byte[] Hello_bytes = new byte[ct];
        fis.read(Hello_bytes);
        ((HashtableClassLoader)classLoaderArray[1]).putClass("Hello", Hello_bytes);
        CompositeClassLoader ccl = new CompositeClassLoader(classLoaderArray);
        Object o1 = ccl.loadClass("Hello").newInstance();
        if (args.length > 0) {
            Object o2 = ccl.loadClass(args[0]).newInstance();
        }
    }
}

