/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.javaUtils.classloader;

import gov.va.med.lom.javaUtils.classloader.ClassLoaderStrategy;
import gov.va.med.lom.javaUtils.classloader.FileSystemClassLoader;
import gov.va.med.lom.javaUtils.classloader.HashtableClassLoader;
import gov.va.med.lom.javaUtils.classloader.JDBCClassLoader;
import gov.va.med.lom.javaUtils.classloader.JarClassLoader;
import gov.va.med.lom.javaUtils.classloader.SocketClassLoader;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class ClassLoaderUtil {
    public static String FILE_SYSTEM_CLASS_LOADER = "FILE_SYSTEM_CLASS_LOADER";
    public static String HASH_TABLE_CLASS_LOADER = "HASH_TABLE_CLASS_LOADER";
    public static String JDBC_CLASS_LOADER = "JDBC_CLASS_LOADER";
    public static String SOCKET_CLASS_LOADER = "SOCKET_CLASS_LOADER";
    public static String JAR_CLASS_LOADER = "JAR_CLASS_LOADER";

    public static ClassLoaderStrategy getClassLoader(String strategy, String arg) throws Exception {
        String[] args = new String[]{arg};
        return ClassLoaderUtil.getClassLoader(strategy, args);
    }

    public static ClassLoaderStrategy getClassLoader(String strategy, String[] args) throws Exception {
        ClassLoader cl;
        block20: {
            cl = null;
            if (strategy.equals(FILE_SYSTEM_CLASS_LOADER)) {
                try {
                    if (args.length == 0) {
                        cl = new FileSystemClassLoader();
                        break block20;
                    }
                    cl = new FileSystemClassLoader(args[0]);
                }
                catch (Exception e) {
                    System.err.println("Unable to find directory " + args[0]);
                }
            } else if (strategy.equals(HASH_TABLE_CLASS_LOADER)) {
                cl = new HashtableClassLoader();
                for (int i = 0; i < args.length; ++i) {
                    try {
                        FileInputStream fis = new FileInputStream(args[i]);
                        int ct = fis.available();
                        byte[] bytes = new byte[ct];
                        fis.read(bytes);
                        ((HashtableClassLoader)cl).putClass(args[i], bytes);
                        continue;
                    }
                    catch (Exception e) {
                        System.err.println("Unable to find file " + args[i]);
                        throw e;
                    }
                }
            } else {
                if (strategy.equals(JDBC_CLASS_LOADER)) {
                    try {
                        Class.forName(args[0]).newInstance();
                    }
                    catch (Exception e) {
                        System.err.println("Unable to load DB driver.");
                        e.printStackTrace();
                        throw e;
                    }
                    try {
                        Properties p = new Properties();
                        Connection conn = DriverManager.getConnection(args[1], p);
                        cl = new JDBCClassLoader(conn, args[2]);
                    }
                    catch (SQLException e) {
                        System.err.println("SQLException: " + e.getMessage());
                        System.err.println("SQLState:     " + e.getSQLState());
                        System.err.println("VendorError:  " + e.getErrorCode());
                        throw e;
                    }
                }
                if (strategy.equals(SOCKET_CLASS_LOADER)) {
                    cl = new SocketClassLoader(args[0], Integer.valueOf(args[1]));
                } else if (strategy.equals(JAR_CLASS_LOADER)) {
                    try {
                        cl = new JarClassLoader(args[0]);
                    }
                    catch (Exception e) {
                        System.err.println("Unable to find directory " + args[0]);
                        throw e;
                    }
                }
            }
        }
        return cl;
    }

    public static void main(String[] args) {
        try {
            ClassLoaderStrategy cl = ClassLoaderUtil.getClassLoader(JAR_CLASS_LOADER, args);
            Class<?> c = ((ClassLoader)((Object)cl)).loadClass("gov.va.med.lom.javaUtils.FileSystemClassLoader");
            System.out.println(c.toString());
        }
        catch (Exception e) {
            e.getMessage();
        }
    }
}

