/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.jpa.foundation.dao.impl;

import gov.va.med.lom.jpa.foundation.dao.BaseEntityDao;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseEntityDaoJpa<T, ID extends Serializable>
implements BaseEntityDao<T, ID> {
    protected Class<T> entityClass;
    @PersistenceContext
    protected EntityManager entityManager;

    public BaseEntityDaoJpa() {
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.entityClass = (Class)genericSuperclass.getActualTypeArguments()[0];
    }

    @Override
    public T save(T entity) {
        this.entityManager.persist(entity);
        return entity;
    }

    @Override
    public T update(T entity) {
        this.entityManager.merge(entity);
        return entity;
    }

    @Override
    public T refresh(T entity) {
        this.entityManager.refresh(entity);
        return entity;
    }

    @Override
    public void remove(T entity) {
        this.entityManager.remove(entity);
    }

    @Override
    public void remove(ID id) {
        T obj = this.findById(id);
        this.entityManager.remove(obj);
    }

    @Override
    public void removeAll() {
        Query q = this.entityManager.createQuery("delete from " + this.entityClass.getName());
        q.executeUpdate();
    }

    @Override
    public T findById(ID id) {
        return (T)this.entityManager.find(this.entityClass, id);
    }

    @Override
    public List<T> findAll() {
        Query q = this.entityManager.createQuery("select e from " + this.entityClass.getName() + " as e");
        return q.getResultList();
    }

    @Override
    public List<T> findActive() {
        Query q = this.entityManager.createQuery("select e from " + this.entityClass.getName() + " as e where active = 1");
        return q.getResultList();
    }

    public Query findByNamedQueryAndNamedParam(String named, String[] params, Object[] paramValues) {
        Query q = this.entityManager.createNamedQuery(named);
        for (int i = 0; i < params.length; ++i) {
            q.setParameter(params[i], paramValues[i]);
        }
        return q;
    }

    public Query findByNamedQuery(String named) {
        return this.entityManager.createNamedQuery(named);
    }
}

