/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.util;

import gov.va.med.lom.vistabroker.service.AdminVBService;
import gov.va.med.lom.vistabroker.service.AuthVBService;
import gov.va.med.lom.vistabroker.service.DdrVBService;
import gov.va.med.lom.vistabroker.service.ListsVBService;
import gov.va.med.lom.vistabroker.service.MiscVBService;
import gov.va.med.lom.vistabroker.service.PatientVBService;
import gov.va.med.lom.vistabroker.service.Service;
import gov.va.med.lom.vistabroker.service.UserVBService;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import javax.naming.CommunicationException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class VistaBrokerServiceFactory {
    private static final String VISTABROKER = "ll-vistabroker";
    private static final String JNP_URL = "java.naming.provider.url";
    private static Context ctx;
    private static Map<SERVICE, Service> serviceMap;
    private static Map<SERVICE, String> serviceJndiMap;

    private static Service fetchService(SERVICE s, boolean refresh) {
        Service service = serviceMap.get((Object)s);
        if (!refresh && service != null && VistaBrokerServiceFactory.isAlive(service)) {
            return service;
        }
        try {
            service = (Service)ctx.lookup(serviceJndiMap.get((Object)s));
        }
        catch (CommunicationException e) {
            e.printStackTrace();
            throw new RuntimeException("unable to connect with application server");
        }
        catch (NamingException e) {
            e.printStackTrace();
            service = null;
        }
        serviceMap.put(s, service);
        return service;
    }

    private static boolean isAlive(Service s) {
        try {
            return s.isAlive();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static AdminVBService getAdminVBService() {
        return (AdminVBService)VistaBrokerServiceFactory.fetchService(SERVICE.ADMIN, false);
    }

    public static AuthVBService getAuthVBService() {
        return (AuthVBService)VistaBrokerServiceFactory.fetchService(SERVICE.AUTH, false);
    }

    public static DdrVBService getDdrVBService() {
        return (DdrVBService)VistaBrokerServiceFactory.fetchService(SERVICE.DDR, false);
    }

    public static ListsVBService getListsVBService() {
        return (ListsVBService)VistaBrokerServiceFactory.fetchService(SERVICE.LISTS, false);
    }

    public static MiscVBService getMiscVBService() {
        return (MiscVBService)VistaBrokerServiceFactory.fetchService(SERVICE.MISC, false);
    }

    public static PatientVBService getPatientVBService() {
        return (PatientVBService)VistaBrokerServiceFactory.fetchService(SERVICE.PATIENT, false);
    }

    public static UserVBService getUserVBService() {
        return (UserVBService)VistaBrokerServiceFactory.fetchService(SERVICE.USER, false);
    }

    static {
        serviceMap = new HashMap<SERVICE, Service>();
        serviceJndiMap = new HashMap<SERVICE, String>();
        ResourceBundle res = ResourceBundle.getBundle("vistabroker");
        String jndiPrefix = "ll-vistabroker-" + res.getString("version") + "/";
        for (SERVICE s : SERVICE.values()) {
            serviceMap.put(s, null);
            serviceJndiMap.put(s, jndiPrefix + res.getString(s.getName()));
        }
        try {
            ctx = new InitialContext();
            Hashtable<?, ?> env = ctx.getEnvironment();
            if (!env.containsKey(JNP_URL)) {
                ctx.addToEnvironment(JNP_URL, "localhost:1099");
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SERVICE {
        ADMIN("admin.jndi"),
        AUTH("auth.jndi"),
        DDR("ddr.jndi"),
        LISTS("lists.jndi"),
        MISC("misc.jndi"),
        PATIENT("patient.jndi"),
        USER("user.jndi");

        private String name;

        private SERVICE(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

