/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.service.impl;

import gov.va.med.lom.foundation.service.response.CollectionServiceResponse;
import gov.va.med.lom.foundation.service.response.ServiceResponse;
import gov.va.med.lom.vistabroker.patient.dao.AddressDao;
import gov.va.med.lom.vistabroker.patient.dao.AdmissionsDao;
import gov.va.med.lom.vistabroker.patient.dao.AllergiesReactantsDao;
import gov.va.med.lom.vistabroker.patient.dao.AppointmentsDao;
import gov.va.med.lom.vistabroker.patient.dao.ClinicalProceduresDao;
import gov.va.med.lom.vistabroker.patient.dao.ClinicalRemindersDao;
import gov.va.med.lom.vistabroker.patient.dao.CombatVetDao;
import gov.va.med.lom.vistabroker.patient.dao.ConsultsDao;
import gov.va.med.lom.vistabroker.patient.dao.DemographicsDao;
import gov.va.med.lom.vistabroker.patient.dao.DiscreteResultsDao;
import gov.va.med.lom.vistabroker.patient.dao.InsuranceDao;
import gov.va.med.lom.vistabroker.patient.dao.LabsDao;
import gov.va.med.lom.vistabroker.patient.dao.MedicationsDao;
import gov.va.med.lom.vistabroker.patient.dao.NewTiuNoteDao;
import gov.va.med.lom.vistabroker.patient.dao.OrdersDao;
import gov.va.med.lom.vistabroker.patient.dao.PatientEncounterDao;
import gov.va.med.lom.vistabroker.patient.dao.PatientInfoDao;
import gov.va.med.lom.vistabroker.patient.dao.PatientInquiryDao;
import gov.va.med.lom.vistabroker.patient.dao.PatientSelectionDao;
import gov.va.med.lom.vistabroker.patient.dao.PatientVestingDao;
import gov.va.med.lom.vistabroker.patient.dao.PostingsDao;
import gov.va.med.lom.vistabroker.patient.dao.ProblemsDao;
import gov.va.med.lom.vistabroker.patient.dao.RemoteSitesDao;
import gov.va.med.lom.vistabroker.patient.dao.ReportsDao;
import gov.va.med.lom.vistabroker.patient.dao.SensitiveRecordAccessDao;
import gov.va.med.lom.vistabroker.patient.dao.TemplateDao;
import gov.va.med.lom.vistabroker.patient.dao.TiuNoteDao;
import gov.va.med.lom.vistabroker.patient.dao.TiuNoteHeadersDao;
import gov.va.med.lom.vistabroker.patient.dao.VistaImagingDao;
import gov.va.med.lom.vistabroker.patient.dao.VitalSignsDao;
import gov.va.med.lom.vistabroker.patient.data.Address;
import gov.va.med.lom.vistabroker.patient.data.Admission;
import gov.va.med.lom.vistabroker.patient.data.AllergiesReactants;
import gov.va.med.lom.vistabroker.patient.data.Appointment;
import gov.va.med.lom.vistabroker.patient.data.CancelledAppointment;
import gov.va.med.lom.vistabroker.patient.data.ClinicalProcedure;
import gov.va.med.lom.vistabroker.patient.data.ClinicalReminder;
import gov.va.med.lom.vistabroker.patient.data.ConstructOrder;
import gov.va.med.lom.vistabroker.patient.data.Consult;
import gov.va.med.lom.vistabroker.patient.data.ConsultRec;
import gov.va.med.lom.vistabroker.patient.data.ConsultRequest;
import gov.va.med.lom.vistabroker.patient.data.ConsultRequestsSelection;
import gov.va.med.lom.vistabroker.patient.data.CumulativeLabResults;
import gov.va.med.lom.vistabroker.patient.data.DGroup;
import gov.va.med.lom.vistabroker.patient.data.DcReason;
import gov.va.med.lom.vistabroker.patient.data.Demographics;
import gov.va.med.lom.vistabroker.patient.data.DiscreteItemData;
import gov.va.med.lom.vistabroker.patient.data.EditResubmit;
import gov.va.med.lom.vistabroker.patient.data.EditedTiuNote;
import gov.va.med.lom.vistabroker.patient.data.Encounter;
import gov.va.med.lom.vistabroker.patient.data.EncounterAppointment;
import gov.va.med.lom.vistabroker.patient.data.LabTestResult;
import gov.va.med.lom.vistabroker.patient.data.LockDocumentResult;
import gov.va.med.lom.vistabroker.patient.data.MeansTestStatus;
import gov.va.med.lom.vistabroker.patient.data.Medication;
import gov.va.med.lom.vistabroker.patient.data.NewOrder;
import gov.va.med.lom.vistabroker.patient.data.NewTiuNote;
import gov.va.med.lom.vistabroker.patient.data.Order;
import gov.va.med.lom.vistabroker.patient.data.OrderDetails;
import gov.va.med.lom.vistabroker.patient.data.OrderDialogPrompt;
import gov.va.med.lom.vistabroker.patient.data.OrderDialogResolved;
import gov.va.med.lom.vistabroker.patient.data.OrderInfo;
import gov.va.med.lom.vistabroker.patient.data.OrderResponse;
import gov.va.med.lom.vistabroker.patient.data.OrderSheet;
import gov.va.med.lom.vistabroker.patient.data.OrderStatus;
import gov.va.med.lom.vistabroker.patient.data.OrderView;
import gov.va.med.lom.vistabroker.patient.data.OrdersInfoList;
import gov.va.med.lom.vistabroker.patient.data.Patient;
import gov.va.med.lom.vistabroker.patient.data.PatientInfo;
import gov.va.med.lom.vistabroker.patient.data.PatientLocation;
import gov.va.med.lom.vistabroker.patient.data.Posting;
import gov.va.med.lom.vistabroker.patient.data.Problem;
import gov.va.med.lom.vistabroker.patient.data.QueueHandle;
import gov.va.med.lom.vistabroker.patient.data.RemoteStation;
import gov.va.med.lom.vistabroker.patient.data.SensitiveRecordAccessStatus;
import gov.va.med.lom.vistabroker.patient.data.SimilarRecordsStatus;
import gov.va.med.lom.vistabroker.patient.data.TemplateType;
import gov.va.med.lom.vistabroker.patient.data.TiuNote;
import gov.va.med.lom.vistabroker.patient.data.TiuNoteHeader;
import gov.va.med.lom.vistabroker.patient.data.TiuNoteHeadersSelection;
import gov.va.med.lom.vistabroker.patient.data.UnsignedNoteHeaders;
import gov.va.med.lom.vistabroker.patient.data.VistaImageInfo;
import gov.va.med.lom.vistabroker.patient.data.VitalSignMeasurement;
import gov.va.med.lom.vistabroker.patient.data.VitalSigns;
import gov.va.med.lom.vistabroker.security.ISecurityContext;
import gov.va.med.lom.vistabroker.service.PatientVBService;
import gov.va.med.lom.vistabroker.service.impl.BaseService;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.ejb.Remote;
import javax.ejb.Stateless;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless(name="gov.va.med.lom.vistabroker.PatientVBService")
@Remote(value={PatientVBService.class})
public class PatientVBServiceImpl
extends BaseService
implements PatientVBService,
Serializable {
    @Override
    public ServiceResponse<Address> getAddress(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(Address.class, AddressDao.class, "getAddress", dfn);
    }

    @Override
    public CollectionServiceResponse<Admission> getAdmissions(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(Admission.class, AdmissionsDao.class, "getAdmissions", dfn);
    }

    @Override
    public ServiceResponse<AllergiesReactants> getAllergiesReactants(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(AllergiesReactants.class, AllergiesReactantsDao.class, "getAllergiesReactants", dfn);
    }

    @Override
    public ServiceResponse<String> getAllergyDetail(ISecurityContext securityContext, String dfn, String ien) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, ien};
        return this.singleResult(String.class, AllergiesReactantsDao.class, "getAllergyDetail", params);
    }

    @Override
    public CollectionServiceResponse<Appointment> getAppointments(ISecurityContext securityContext, String dfn, Date fromDate, Date throughDate) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, fromDate, throughDate};
        return this.collectionResult(Appointment.class, AppointmentsDao.class, "getAppointments", params);
    }

    @Override
    public CollectionServiceResponse<String> getVisitDetail(ISecurityContext securityContext, String dfn, String id) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, id};
        return this.collectionResult(String.class, AppointmentsDao.class, "getVisitDetail", params);
    }

    @Override
    public ServiceResponse<CancelledAppointment> cancelAppointment(ISecurityContext securityContext, String dfn, double apptDatetime, String clinic) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, apptDatetime, clinic};
        return this.singleResult(CancelledAppointment.class, AppointmentsDao.class, "cancelAppointment", params);
    }

    @Override
    public ServiceResponse<ClinicalProcedure> getClinicalProcedure(ISecurityContext securityContext, String orderEntryNumber) {
        this.setSecurityContext(securityContext);
        return this.singleResult(ClinicalProcedure.class, ClinicalProceduresDao.class, "getClinicalProcedure", orderEntryNumber);
    }

    @Override
    public ServiceResponse<String> closeCpNote(ISecurityContext securityContext, String tiuNoteIen) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, ClinicalProceduresDao.class, "closeCpNote", tiuNoteIen);
    }

    @Override
    public CollectionServiceResponse<ClinicalReminder> getClinicalReminders(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(ClinicalReminder.class, ClinicalRemindersDao.class, "getClinicalReminders", dfn);
    }

    @Override
    public ServiceResponse<String> getClinicalReminderDetails(ISecurityContext securityContext, String dfn, String ien) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, ien};
        return this.singleResult(String.class, ClinicalRemindersDao.class, "getClinicalReminderDetails", params);
    }

    @Override
    public CollectionServiceResponse<String> getCombatVetInfo(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(String.class, CombatVetDao.class, "getCombatVetInfo", dfn);
    }

    @Override
    public CollectionServiceResponse<ConsultRequest> getDefaultConsultRequests(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(ConsultRequest.class, ConsultsDao.class, "getDefaultConsultRequests", dfn);
    }

    @Override
    public CollectionServiceResponse<ConsultRequest> getConsultRequests(ISecurityContext securityContext, String dfn, ConsultRequestsSelection consultRequestsSelection) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, consultRequestsSelection};
        return this.collectionResult(ConsultRequest.class, ConsultsDao.class, "getConsultRequests", params);
    }

    @Override
    public ServiceResponse<String> getConsultDetail(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, ConsultsDao.class, "getConsultDetail", ien);
    }

    @Override
    public ServiceResponse<String> getMedResults(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, ConsultsDao.class, "getMedResults", ien);
    }

    @Override
    public ServiceResponse<ConsultRec> getConsultRec(ISecurityContext securityContext, String ien, boolean showAddenda) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{ien, showAddenda};
        return this.singleResult(ConsultRec.class, ConsultsDao.class, "getConsultRec", params);
    }

    @Override
    public ServiceResponse<Consult> findConsult(ISecurityContext securityContext, String consultIen) {
        this.setSecurityContext(securityContext);
        return this.singleResult(Consult.class, ConsultsDao.class, "findConsult", consultIen);
    }

    @Override
    public ServiceResponse<String> getConsultOrderIen(ISecurityContext securityContext, String consultIen) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, ConsultsDao.class, "getConsultOrderIen", consultIen);
    }

    @Override
    public ServiceResponse<String> denyConsult(ISecurityContext securityContext, String orderIen, String userDuz, Date dcDate, String comments) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{orderIen, userDuz, dcDate, comments};
        return this.singleResult(String.class, ConsultsDao.class, "denyConsult", params);
    }

    @Override
    public ServiceResponse<String> discontinueConsult(ISecurityContext securityContext, String orderIen, String userDuz, Date dcDate, String comments) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{orderIen, userDuz, dcDate, comments};
        return this.singleResult(String.class, ConsultsDao.class, "discontinueConsult", params);
    }

    @Override
    public ServiceResponse<String> getProcedureIen(ISecurityContext securityContext, String orderIen) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, ConsultsDao.class, "getProcedureIen", orderIen);
    }

    @Override
    public ServiceResponse<String> getCPRequests(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, ConsultsDao.class, "getCPRequests", dfn);
    }

    @Override
    public ServiceResponse<String> addConsultComment(ISecurityContext securityContext, String consultId, List<String> comments, boolean alert, String alertTo, double actionDate) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{consultId, comments, alert, alertTo, actionDate};
        return this.singleResult(String.class, ConsultsDao.class, "addConsultComment", params);
    }

    @Override
    public ServiceResponse<EditResubmit> loadConsultForEdit(String consultIen) {
        this.setSecurityContext(this.securityContext);
        return this.singleResult(EditResubmit.class, ConsultsDao.class, "loadConsultForEdit", consultIen);
    }

    @Override
    public ServiceResponse<LockDocumentResult> lockConsultRequest(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.singleResult(LockDocumentResult.class, ConsultsDao.class, "lockConsultRequest", ien);
    }

    @Override
    public ServiceResponse<String> unlockConsult(ISecurityContext securityContext, String noteIen) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, ConsultsDao.class, "unlockConsult", noteIen);
    }

    @Override
    public ServiceResponse<Demographics> getDemographics(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(Demographics.class, DemographicsDao.class, "getDemographics", dfn);
    }

    @Override
    public ServiceResponse<Demographics> getAlsiDemographics(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(Demographics.class, DemographicsDao.class, "getAlsiDemographics", dfn);
    }

    @Override
    public ServiceResponse<String> getAlsiDfnLookup(ISecurityContext securityContext, String ssn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, PatientSelectionDao.class, "getAlsiDfnLookup", ssn);
    }

    @Override
    public ServiceResponse<String> lookupDiscreteItemNum(ISecurityContext securityContext, String dfn, String fileNum, String itemName) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, fileNum, itemName};
        return this.singleResult(String.class, DiscreteResultsDao.class, "lookupItemNum", params);
    }

    @Override
    public CollectionServiceResponse<DiscreteItemData> getDiscreteItemDataSet(ISecurityContext securityContext, String dfn, String typeNum, String itemNum, double fmStartDate) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, typeNum, itemNum, fmStartDate};
        return this.collectionResult(DiscreteItemData.class, DiscreteResultsDao.class, "getItemDataSet", params);
    }

    @Override
    public ServiceResponse<DiscreteItemData> getLatestDiscreteItemDataPoint(ISecurityContext securityContext, String dfn, String typeNum, String itemNum) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, typeNum, itemNum};
        return this.singleResult(DiscreteItemData.class, DiscreteResultsDao.class, "getLatestItemDataPoint", params);
    }

    @Override
    public ServiceResponse<String> getInsuranceInfo(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, InsuranceDao.class, "getInsuranceInfo", dfn);
    }

    @Override
    public ServiceResponse<Boolean> isPatientVested(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(Boolean.class, PatientVestingDao.class, "isPatientVested", dfn);
    }

    @Override
    public ServiceResponse<Boolean> patientNeedsVestingCanVest(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(Boolean.class, PatientVestingDao.class, "patientNeedsVestingCanVest", dfn);
    }

    @Override
    public CollectionServiceResponse<LabTestResult> getRecentLabs(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(LabTestResult.class, LabsDao.class, "getRecentLabs", dfn);
    }

    @Override
    public CollectionServiceResponse<String> getLabTestData(ISecurityContext securityContext, String labTestIen) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(String.class, LabsDao.class, "getLabTestData", labTestIen);
    }

    @Override
    public ServiceResponse<CumulativeLabResults> getCumulativeLabResults(ISecurityContext securityContext, String patientDfn, int daysBack, Date date1, Date date2) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{patientDfn, daysBack, date1, date2};
        return this.singleResult(CumulativeLabResults.class, LabsDao.class, "getCumulativeLabResults", params);
    }

    @Override
    public ServiceResponse<String> getTestsByDate(ISecurityContext securityContext, String patientDfn, int daysBack, Date date1, Date date2) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{patientDfn, daysBack, date1, date2};
        return this.singleResult(String.class, LabsDao.class, "getTestsByDate", params);
    }

    @Override
    public CollectionServiceResponse<Medication> getMedications(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(Medication.class, MedicationsDao.class, "getMedications", dfn);
    }

    @Override
    public CollectionServiceResponse<Medication> getCoverSheetMeds(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(Medication.class, MedicationsDao.class, "getCoverSheetMeds", dfn);
    }

    @Override
    public ServiceResponse<String> getMedDetails(ISecurityContext securityContext, String dfn, String id) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, id};
        return this.singleResult(String.class, MedicationsDao.class, "getMedDetails", params);
    }

    @Override
    public ServiceResponse<String> getMedAdminHistory(ISecurityContext securityContext, String dfn, String id) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, id};
        return this.singleResult(String.class, MedicationsDao.class, "getMedAdminHistory", params);
    }

    @Override
    public ServiceResponse<TiuNote> createTiuNote(ISecurityContext securityContext, NewTiuNote newTiuNote) {
        this.setSecurityContext(securityContext);
        return this.singleResult(TiuNote.class, NewTiuNoteDao.class, "createTiuNote", newTiuNote);
    }

    @Override
    public ServiceResponse<TiuNote> updateTiuNote(ISecurityContext securityContext, EditedTiuNote editedTiuNote) {
        this.setSecurityContext(securityContext);
        return this.singleResult(TiuNote.class, NewTiuNoteDao.class, "updateTiuNote", editedTiuNote);
    }

    @Override
    public ServiceResponse<TiuNote> createAddendum(ISecurityContext securityContext, NewTiuNote newTiuNote, String addendumTo) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{newTiuNote, addendumTo};
        return this.singleResult(TiuNote.class, NewTiuNoteDao.class, "createAddendum", params);
    }

    @Override
    public CollectionServiceResponse<String> saveOrder(ISecurityContext securityContext, String dfn, NewOrder newOrder) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, newOrder};
        return this.collectionResult(String.class, OrdersDao.class, "saveOrder", params);
    }

    @Override
    public ServiceResponse<String> getLabOrderDetails(ISecurityContext securityContext, String dfn, String orderId) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, orderId};
        return this.singleResult(String.class, OrdersDao.class, "getLabOrderDetails", params);
    }

    @Override
    public ServiceResponse<OrderView> getOrderViewDefault(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.singleResult(OrderView.class, OrdersDao.class, "getOrderViewDefault");
    }

    @Override
    public ServiceResponse<String> getOrderDetails(ISecurityContext securityContext, String orderId, String dfn) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{orderId, dfn};
        return this.singleResult(String.class, OrdersDao.class, "getOrderDetails", params);
    }

    @Override
    public ServiceResponse<String> getOrderDetails(ISecurityContext securityContext, String orderId) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, OrdersDao.class, "getOrderDetails", orderId);
    }

    @Override
    public ServiceResponse<String> getAlsiOrderDetails(ISecurityContext securityContext, String orderId) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, OrdersDao.class, "getAlsiOrderDetails", orderId);
    }

    @Override
    public ServiceResponse<String> getOrderResult(ISecurityContext securityContext, String dfn, String orderId) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, orderId};
        return this.singleResult(String.class, OrdersDao.class, "getOrderResult", params);
    }

    @Override
    public CollectionServiceResponse<String> getDGroupMap(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(String.class, OrdersDao.class, "getDGroupMap");
    }

    @Override
    public ServiceResponse<DGroup> getSeqOfDGroup(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.singleResult(DGroup.class, OrdersDao.class, "getSeqOfDGroup", ien);
    }

    @Override
    public CollectionServiceResponse<OrderSheet> getOrderSheets(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(OrderSheet.class, OrdersDao.class, "getOrderSheets", dfn);
    }

    @Override
    public CollectionServiceResponse<DcReason> getDiscontinueReasons(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(DcReason.class, OrdersDao.class, "getDiscontinueReasons");
    }

    @Override
    public ServiceResponse<Integer> discontinueOrder(ISecurityContext securityContext, String orderId, String providerDuz, String locationIen, String reasonIen, boolean dcOrigOrder, boolean newOrder) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{orderId, providerDuz, locationIen, reasonIen, dcOrigOrder, newOrder};
        return this.singleResult(Integer.class, OrdersDao.class, "discontinueOrder", params);
    }

    @Override
    public ServiceResponse<OrderInfo> holdOrder(ISecurityContext securityContext, String orderId, String providerDuz) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{orderId, providerDuz};
        return this.singleResult(Order.class, OrdersDao.class, "holdOrder", params);
    }

    @Override
    public ServiceResponse<OrderInfo> releaseOrderHold(ISecurityContext securityContext, String orderId, String providerDuz) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{orderId, providerDuz};
        return this.singleResult(Order.class, OrdersDao.class, "releaseOrderHold", params);
    }

    @Override
    public ServiceResponse<OrderInfo> verifyOrder(ISecurityContext securityContext, String orderId, String esCode) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{orderId, esCode};
        return this.singleResult(Order.class, OrdersDao.class, "verifyOrder", params);
    }

    @Override
    public ServiceResponse<OrderInfo> completeOrder(ISecurityContext securityContext, String orderId, String esCode) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{orderId, esCode};
        return this.singleResult(Order.class, OrdersDao.class, "completeOrder", params);
    }

    @Override
    public ServiceResponse<OrdersInfoList> getOrdersListForDefaultView(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(OrdersInfoList.class, OrdersDao.class, "getOrdersListForDefaultView", dfn);
    }

    @Override
    public ServiceResponse<OrdersInfoList> getOrdersList(ISecurityContext securityContext, String dfn, OrderView orderView) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, orderView};
        return this.singleResult(OrdersInfoList.class, OrdersDao.class, "getOrdersList", params);
    }

    @Override
    public ServiceResponse<OrdersInfoList> getOrdersList2(ISecurityContext securityContext, String dfn, OrderView orderView, Calendar startDate) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, orderView, startDate};
        return this.singleResult(OrdersInfoList.class, OrdersDao.class, "getOrdersList", params);
    }

    @Override
    public ServiceResponse<OrdersInfoList> getOrdersList3(ISecurityContext securityContext, String dfn, OrderView orderView, Calendar startDate, boolean checkUrgency) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, orderView, startDate, checkUrgency};
        return this.singleResult(OrdersInfoList.class, OrdersDao.class, "getOrdersList", params);
    }

    @Override
    public ServiceResponse<OrdersInfoList> getOrdersList4(ISecurityContext securityContext, String dfn, Calendar startDate, boolean checkUrgency, OrdersInfoList ordersInfoList) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, startDate, checkUrgency, ordersInfoList};
        return this.singleResult(OrdersInfoList.class, OrdersDao.class, "getOrdersList", params);
    }

    @Override
    public ServiceResponse<OrdersInfoList> getOrdersAbbrForDefaultView(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(OrdersInfoList.class, OrdersDao.class, "getOrdersAbbrForDefaultView", dfn);
    }

    @Override
    public ServiceResponse<OrdersInfoList> getOrdersAbbr(ISecurityContext securityContext, String dfn, OrderView orderView) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, orderView};
        return this.singleResult(OrdersInfoList.class, OrdersDao.class, "getOrdersAbbr", params);
    }

    @Override
    public CollectionServiceResponse<String> getUnsignedOrders(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(String.class, OrdersDao.class, "getUnsignedOrders", dfn);
    }

    @Override
    public ServiceResponse<String> getDisplayGroupIen(ISecurityContext securityContext, String group) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, OrdersDao.class, "getDisplayGroupIen", group);
    }

    @Override
    public ServiceResponse<OrderStatus> parseOrderDetail(ISecurityContext securityContext, String orderId, String dfn) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{orderId, dfn};
        return this.singleResult(OrderStatus.class, OrdersDao.class, "parseOrderDetail", params);
    }

    @Override
    public ServiceResponse<String> getOrderUrgency(ISecurityContext securityContext, String orderId, String dfn) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{orderId, dfn};
        return this.singleResult(String.class, OrdersDao.class, "getOrderUrgency", params);
    }

    @Override
    public ServiceResponse<String> doGetOrderUrgency(ISecurityContext securityContext, String orderId, String context) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{orderId, context};
        return this.singleResult(String.class, OrdersDao.class, "doGetOrderUrgency", params);
    }

    @Override
    public ServiceResponse<String> parseOrderUrgency(ISecurityContext securityContext, String orderId, String dfn) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{orderId, dfn};
        return this.singleResult(String.class, OrdersDao.class, "parseOrderUrgency", params);
    }

    @Override
    public ServiceResponse<OrderDetails> parseOrderDetails(ISecurityContext securityContext, String orderId, String dfn) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{orderId, dfn};
        return this.singleResult(OrderDetails.class, OrdersDao.class, "parseOrderDetails", params);
    }

    @Override
    public ServiceResponse<OrderDetails> parseOrderDetails(ISecurityContext securityContext, String orderId) {
        this.setSecurityContext(securityContext);
        return this.singleResult(OrderDetails.class, OrdersDao.class, "parseOrderDetails", orderId);
    }

    @Override
    public ServiceResponse<Integer> getOrderStatus(ISecurityContext securityContext, String orderId) {
        this.setSecurityContext(securityContext);
        return this.singleResult(Integer.class, OrdersDao.class, "getOrderStatus", orderId);
    }

    @Override
    public ServiceResponse<String> getLabTestOrderData(ISecurityContext securityContext, String orderId) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, OrdersDao.class, "getLabTestOrderData", orderId);
    }

    @Override
    public ServiceResponse<String> alertOrder(ISecurityContext securityContext, String orderIen) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, OrdersDao.class, "alertOrder", orderIen);
    }

    @Override
    public ServiceResponse<String> alertOrderForRecipient(ISecurityContext securityContext, String orderIen, String recipientDuz) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{orderIen, recipientDuz};
        return this.singleResult(String.class, OrdersDao.class, "alertOrderForRecipient", params);
    }

    @Override
    public ServiceResponse<String> validateOrderAction(ISecurityContext securityContext, String id, String action, String providerDuz) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{id, action, providerDuz};
        return this.singleResult(String.class, OrdersDao.class, "validateOrderAction", params);
    }

    @Override
    public ServiceResponse<String> validateComplexOrderAction(ISecurityContext securityContext, String id) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, OrdersDao.class, "validateComplexOrderAction", id);
    }

    @Override
    public ServiceResponse<LockDocumentResult> lockPatient(ISecurityContext securityContext, String patientDfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(Integer.class, OrdersDao.class, "lockPatient", patientDfn);
    }

    @Override
    public ServiceResponse<String> unlockPatient(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, OrdersDao.class, "unlockPatient", ien);
    }

    @Override
    public ServiceResponse<LockDocumentResult> lockOrder(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.singleResult(LockDocumentResult.class, OrdersDao.class, "lockOrder", ien);
    }

    @Override
    public ServiceResponse<String> unlockOrder(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, OrdersDao.class, "unlockOrder", ien);
    }

    @Override
    public ServiceResponse<OrderInfo> getOrderByIfn(ISecurityContext securityContext, String id) {
        this.setSecurityContext(securityContext);
        return this.singleResult(Order.class, OrdersDao.class, "getOrderByIfn", id);
    }

    @Override
    public ServiceResponse<OrderDialogResolved> buildReponses(ISecurityContext securityContext, String patientDfn, String encLocation, String encProvider, boolean inpatient, String patientSex, int patientAge, int scPercent, String keyVars, String inputId, boolean forImo) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{patientDfn, encLocation, encProvider, inpatient, patientSex, patientAge, scPercent, keyVars, inputId, forImo};
        return this.singleResult(OrderDialogResolved.class, OrdersDao.class, "buildReponses", params);
    }

    @Override
    public CollectionServiceResponse<OrderResponse> loadResponses(ISecurityContext securityContext, String orderId, boolean xferOutToInOnMeds, boolean xferInToOutNow) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{orderId, xferOutToInOnMeds, xferInToOutNow};
        return this.collectionResult(OrderResponse.class, OrdersDao.class, "loadResponses", params);
    }

    @Override
    public CollectionServiceResponse<String> buildOcItems(ISecurityContext securityContext, String startDtTm, String fillerId, List<OrderResponse> orderResponses) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startDtTm, fillerId, orderResponses};
        return this.collectionResult(String.class, OrdersDao.class, "buildOcItems", params);
    }

    @Override
    public CollectionServiceResponse<OrderDialogPrompt> loadDialogDefinition(ISecurityContext securityContext, String dialogName) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(OrderDialogPrompt.class, OrdersDao.class, "loadDialogDefinition", dialogName);
    }

    @Override
    public CollectionServiceResponse<String> orderChecksOnAccept(ISecurityContext securityContext, String patientDfn, String encLocation, String fillerId, String startDtTm, List<String> oiList, String dupORIFN, String renewal) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{patientDfn, encLocation, fillerId, startDtTm, oiList, dupORIFN, renewal};
        return this.collectionResult(String.class, OrdersDao.class, "orderChecksOnAccept", params);
    }

    @Override
    public ServiceResponse<OrderInfo> putNewOrder(ISecurityContext securityContext, NewOrder newOrder) {
        this.setSecurityContext(securityContext);
        return this.singleResult(OrderInfo.class, OrdersDao.class, "putNewOrder", newOrder);
    }

    @Override
    public CollectionServiceResponse<String> sendOrders(ISecurityContext securityContext, String patientDfn, String providerDuz, String encLocation, String esCode, List<String> orderList) throws Exception {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{patientDfn, providerDuz, encLocation, esCode, orderList};
        return this.collectionResult(String.class, OrdersDao.class, "sendOrders", params);
    }

    @Override
    public ServiceResponse<OrderInfo> putNewOrder(ISecurityContext securityContext, String patientDfn, String encProvider, String encLocation, String patientSpecialty, double encDatetime, ConstructOrder constructOrder, String orderSource, String editOf) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{patientDfn, encProvider, encLocation, patientSpecialty, encDatetime, constructOrder, orderSource, editOf};
        return this.singleResult(OrderInfo.class, OrdersDao.class, "putNewOrder", params);
    }

    @Override
    public CollectionServiceResponse<EncounterAppointment> getTodaysEncounterAppointments(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(EncounterAppointment.class, PatientEncounterDao.class, "getTodaysEncounterAppointments", dfn);
    }

    @Override
    public CollectionServiceResponse<EncounterAppointment> getOutpatientEncounters(ISecurityContext securityContext, String dfn, Calendar fromDate, Calendar toDate) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, fromDate, toDate};
        return this.collectionResult(EncounterAppointment.class, PatientEncounterDao.class, "getOutpatientEncounters", params);
    }

    @Override
    public CollectionServiceResponse<EncounterAppointment> getInpatientEncounters(ISecurityContext securityContext, String dfn, Calendar fromDate, Calendar toDate) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, fromDate, toDate};
        return this.collectionResult(EncounterAppointment.class, PatientEncounterDao.class, "getInpatientEncounters", params);
    }

    @Override
    public CollectionServiceResponse<EncounterAppointment> getAllEncounters(ISecurityContext securityContext, String dfn, Calendar fromDate, Calendar toDate) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, fromDate, toDate};
        return this.collectionResult(EncounterAppointment.class, PatientEncounterDao.class, "getAllEncounters", params);
    }

    @Override
    public CollectionServiceResponse<EncounterAppointment> getAllEncounters2(ISecurityContext securityContext, String dfn, Calendar fromDate, Calendar toDate, boolean skipAdmits) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, fromDate, toDate, skipAdmits};
        return this.collectionResult(EncounterAppointment.class, PatientEncounterDao.class, "getAllEncounters", params);
    }

    @Override
    public ServiceResponse<Encounter> getEncounterDetails(ISecurityContext securityContext, Encounter anEncounter, boolean inpatient) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{anEncounter, inpatient};
        return this.singleResult(Encounter.class, PatientEncounterDao.class, "getEncounterDetails", params);
    }

    @Override
    public ServiceResponse<String> getVisitCategory(ISecurityContext securityContext, String initialCat, String locationIen, boolean inpatient) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{initialCat, locationIen, inpatient};
        return this.singleResult(String.class, PatientEncounterDao.class, "getVisitCategory", params);
    }

    @Override
    public ServiceResponse<String> savePceData(ISecurityContext securityContext, List<String> pceList, String noteIen, String locationIen) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{pceList, noteIen, locationIen};
        return this.singleResult(String.class, PatientEncounterDao.class, "savePceData", params);
    }

    @Override
    public ServiceResponse<String> getEncFutureDays(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, PatientEncounterDao.class, "getEncFutureDays");
    }

    @Override
    public ServiceResponse<PatientLocation> getCurrentPatientLocation(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(PatientLocation.class, PatientInfoDao.class, "getCurrentPatientLocation", dfn);
    }

    @Override
    public ServiceResponse<MeansTestStatus> getMeansTestRequired(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(MeansTestStatus.class, PatientInfoDao.class, "getMeansTestRequired", dfn);
    }

    @Override
    public ServiceResponse<PatientInfo> getPatientInfo(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(PatientInfo.class, PatientInfoDao.class, "getPatientInfo", dfn);
    }

    @Override
    public ServiceResponse<String> getPatientInquiry(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, PatientInquiryDao.class, "getPatientInquiry", dfn);
    }

    @Override
    public CollectionServiceResponse<Patient> listAllPatients(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(Patient.class, PatientSelectionDao.class, "listAllPatients");
    }

    @Override
    public CollectionServiceResponse<Patient> getSubSetOfPatients(ISecurityContext securityContext, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{startFrom, direction};
        return this.collectionResult(Patient.class, PatientSelectionDao.class, "getSubSetOfPatients", params);
    }

    @Override
    public CollectionServiceResponse<Patient> listPtByProvider(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(Patient.class, PatientSelectionDao.class, "listPtByProvider", ien);
    }

    @Override
    public CollectionServiceResponse<Patient> listPtBySpecialty(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(Patient.class, PatientSelectionDao.class, "listPtBySpecialty", ien);
    }

    @Override
    public CollectionServiceResponse<Patient> listPtByTeam(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(Patient.class, PatientSelectionDao.class, "listPtByTeam", ien);
    }

    @Override
    public CollectionServiceResponse<Patient> listPtByClinic(ISecurityContext securityContext, String ien, Date firstDate, Date lastDate) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{ien, firstDate, lastDate};
        return this.collectionResult(Patient.class, PatientSelectionDao.class, "listPtByClinic", params);
    }

    @Override
    public CollectionServiceResponse<Patient> listPtByWard(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(Patient.class, PatientSelectionDao.class, "listPtByWard", ien);
    }

    @Override
    public CollectionServiceResponse<Patient> listPtByLast5(ISecurityContext securityContext, String last5) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(Patient.class, PatientSelectionDao.class, "listPtByLast5", last5);
    }

    @Override
    public CollectionServiceResponse<Patient> listPtByRPLLast5(ISecurityContext securityContext, String last5) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(Patient.class, PatientSelectionDao.class, "listPtByRPLLast5", last5);
    }

    @Override
    public CollectionServiceResponse<Patient> listPtByFullSSN(ISecurityContext securityContext, String ssn) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(Patient.class, PatientSelectionDao.class, "listPtByFullSSN", ssn);
    }

    @Override
    public CollectionServiceResponse<Patient> listPtByRPLFullSSN(ISecurityContext securityContext, String ssn) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(Patient.class, PatientSelectionDao.class, "listPtByRPLFullSSN", ssn);
    }

    @Override
    public CollectionServiceResponse<Patient> readRPLPtList(ISecurityContext securityContext, String rplJobNumber, String startFrom, int direction) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{rplJobNumber, startFrom, direction};
        return this.collectionResult(Patient.class, PatientSelectionDao.class, "readRPLPtList", params);
    }

    @Override
    public CollectionServiceResponse<Patient> listPtByDflt(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(Patient.class, PatientSelectionDao.class, "listPtByDflt");
    }

    @Override
    public ServiceResponse<Patient> listPtTop(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.singleResult(Patient.class, PatientSelectionDao.class, "listPtTop");
    }

    @Override
    public ServiceResponse<String> getDfltPtList(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, PatientSelectionDao.class, "getDfltPtList");
    }

    @Override
    public ServiceResponse<Character> getDfltPtListSrc(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.singleResult(Character.class, PatientSelectionDao.class, "getDfltPtListSrc");
    }

    @Override
    public void savePtListDflt(ISecurityContext securityContext, String x) {
        this.setSecurityContext(securityContext);
        try {
            this.invokeCall(PatientSelectionDao.class, "getDfltPtListSrc", x);
        }
        catch (Exception e) {
            log.error((Object)"error unlockDocument", (Throwable)e);
        }
    }

    @Override
    public ServiceResponse<String> getDfltSort(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, PatientSelectionDao.class, "getDfltSort");
    }

    @Override
    public ServiceResponse<String> makeRPLPtList(ISecurityContext securityContext, String rplList) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, PatientSelectionDao.class, "makeRPLPtList", rplList);
    }

    @Override
    public void killRPLPtList(ISecurityContext securityContext, String rplJobNumber) {
        this.setSecurityContext(securityContext);
        try {
            this.invokeCall(PatientSelectionDao.class, "killRPLPtList", rplJobNumber);
        }
        catch (Exception e) {
            log.error((Object)"error unlockDocument", (Throwable)e);
        }
    }

    @Override
    public ServiceResponse<SimilarRecordsStatus> getSimilarRecordsFound(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(SimilarRecordsStatus.class, PatientSelectionDao.class, "getSimilarRecordsFound", dfn);
    }

    @Override
    public CollectionServiceResponse<String> listDateRangeClinic(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(String.class, PatientSelectionDao.class, "listDateRangeClinic");
    }

    @Override
    public ServiceResponse<String> defaultDateRangeClinic(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, PatientSelectionDao.class, "defaultDateRangeClinic");
    }

    @Override
    public CollectionServiceResponse<Posting> getPostings(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(Posting.class, PostingsDao.class, "getPostings", dfn);
    }

    @Override
    public CollectionServiceResponse<Patient> getDetailPosting(ISecurityContext securityContext, String dfn, String id) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, id};
        return this.collectionResult(Patient.class, PostingsDao.class, "getDetailPosting", params);
    }

    @Override
    public CollectionServiceResponse<Problem> getProblems(ISecurityContext securityContext, String dfn, String status) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, status};
        return this.collectionResult(Problem.class, ProblemsDao.class, "getProblems", params);
    }

    @Override
    public ServiceResponse<String> getProblemDetail(ISecurityContext securityContext, String dfn, String ien) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, ien};
        return this.singleResult(String.class, ProblemsDao.class, "getProblemDetail", params);
    }

    @Override
    public ServiceResponse<SensitiveRecordAccessStatus> getSensitiveRecordAccess(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(SensitiveRecordAccessStatus.class, SensitiveRecordAccessDao.class, "getSensitiveRecordAccess", dfn);
    }

    @Override
    public ServiceResponse<Boolean> logSensitiveRecordAccess(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(Boolean.class, SensitiveRecordAccessDao.class, "logSensitiveRecordAccess", dfn);
    }

    @Override
    public ServiceResponse<TiuNote> getTiuNote(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.singleResult(TiuNote.class, TiuNoteDao.class, "getTiuNote", ien);
    }

    @Override
    public ServiceResponse<TiuNote> getTiuNoteForEdit(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.singleResult(TiuNote.class, TiuNoteDao.class, "getTiuNoteForEdit", ien);
    }

    @Override
    public ServiceResponse<String> getTiuListItem(ISecurityContext securityContext, String docIen) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, TiuNoteDao.class, "getTiuListItem", docIen);
    }

    @Override
    public ServiceResponse<Boolean> isSurgeryTitle(ISecurityContext securityContext, String titleIen) {
        this.setSecurityContext(securityContext);
        return this.singleResult(Boolean.class, TiuNoteDao.class, "isSurgeryTitle", titleIen);
    }

    @Override
    public ServiceResponse<Boolean> isConsultTitle(ISecurityContext securityContext, String titleIen) {
        this.setSecurityContext(securityContext);
        return this.singleResult(Boolean.class, TiuNoteDao.class, "isConsultTitle", titleIen);
    }

    @Override
    public ServiceResponse<Boolean> authorHasSigned(ISecurityContext securityContext, String titleIen, String userDuz) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{titleIen, userDuz};
        return this.singleResult(Boolean.class, TiuNoteDao.class, "authorHasSigned", params);
    }

    @Override
    public ServiceResponse<String> getTitleIenForNote(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, TiuNoteDao.class, "getTitleIenForNote", ien);
    }

    @Override
    public ServiceResponse<String> getPackageRefForNote(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, TiuNoteDao.class, "getPackageRefForNote", ien);
    }

    @Override
    public ServiceResponse<String> getConsultIenforNote(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, TiuNoteDao.class, "getConsultIenforNote", ien);
    }

    @Override
    public ServiceResponse<String> getVisitStrForNote(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, TiuNoteDao.class, "getVisitStrForNote", ien);
    }

    @Override
    public CollectionServiceResponse<String> getPCEDataForNote(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{ien, null, null};
        return this.collectionResult(String.class, TiuNoteDao.class, "getPCEDataForNote", params);
    }

    @Override
    public CollectionServiceResponse<String> getPCEDataForNote2(ISecurityContext securityContext, String ien, String patientDfn, String visitStr) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{ien, patientDfn, visitStr};
        return this.collectionResult(String.class, TiuNoteDao.class, "getPCEDataForNote", params);
    }

    @Override
    public ServiceResponse<String> getTiuDetails(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.singleResult(String.class, TiuNoteDao.class, "getTiuDetails", ien);
    }

    @Override
    public ServiceResponse<LockDocumentResult> lockDocument(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.singleResult(LockDocumentResult.class, TiuNoteDao.class, "lockDocument", ien);
    }

    @Override
    public void unlockDocument(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        try {
            this.invokeCall(TiuNoteDao.class, "unlockDocument", ien);
        }
        catch (Exception e) {
            log.error((Object)"error unlockDocument", (Throwable)e);
        }
    }

    @Override
    public ServiceResponse<Boolean> deleteDocument(ISecurityContext securityContext, String ien, String reason) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{ien, reason};
        return this.singleResult(Boolean.class, TiuNoteDao.class, "deleteDocument", params);
    }

    @Override
    public ServiceResponse<Boolean> justifyDocumentDelete(ISecurityContext securityContext, String ien) {
        this.setSecurityContext(securityContext);
        return this.singleResult(Boolean.class, TiuNoteDao.class, "justifyDocumentDelete", ien);
    }

    @Override
    public CollectionServiceResponse<TemplateType> getTemplateRoots(ISecurityContext securityContext, String userDuz) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(TemplateType.class, TemplateDao.class, "getTemplateRoots", userDuz);
    }

    @Override
    public ServiceResponse<Integer> getTemplateAccess(ISecurityContext securityContext, String id, String userDuz, String encounterLocation) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{id, userDuz, encounterLocation};
        return this.singleResult(TemplateType.class, TemplateDao.class, "getTemplateAccess", params);
    }

    @Override
    public CollectionServiceResponse<TiuNoteHeader> getSignedProgressNoteHeaders(ISecurityContext securityContext, String dfn, int limit) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, limit};
        return this.collectionResult(TiuNoteHeader.class, TiuNoteHeadersDao.class, "getSignedProgressNoteHeaders", params);
    }

    @Override
    public CollectionServiceResponse<TiuNoteHeader> getSignedDischargeSummaryHeaders(ISecurityContext securityContext, String dfn, int limit) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, limit};
        return this.collectionResult(TiuNoteHeader.class, TiuNoteHeadersDao.class, "getSignedDischargeSummaryHeaders", params);
    }

    @Override
    public CollectionServiceResponse<TiuNoteHeader> getSignedTiuNoteHeaders(ISecurityContext securityContext, String dfn, String noteClass, int limit) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, noteClass, limit};
        return this.collectionResult(TiuNoteHeader.class, TiuNoteHeadersDao.class, "getSignedTiuNoteHeaders", params);
    }

    @Override
    public CollectionServiceResponse<TiuNoteHeader> getUnsignedTiuNoteHeadersByAuthor(ISecurityContext securityContext, String dfn, String duz, int limit) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, duz, limit};
        return this.collectionResult(TiuNoteHeader.class, TiuNoteHeadersDao.class, "getUnsignedTiuNoteHeadersByAuthor", params);
    }

    @Override
    public CollectionServiceResponse<TiuNoteHeader> getUncosignedTiuNoteHeadersByAuthor(ISecurityContext securityContext, String dfn, String duz, int limit) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, duz, limit};
        return this.collectionResult(TiuNoteHeader.class, TiuNoteHeadersDao.class, "getUncosignedTiuNoteHeadersByAuthor", params);
    }

    @Override
    public CollectionServiceResponse<TiuNoteHeader> getAllUnsignedTiuNoteHeaders(ISecurityContext securityContext, String dfn, String duz, int limit) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, duz, limit};
        return this.collectionResult(TiuNoteHeader.class, TiuNoteHeadersDao.class, "getAllUnsignedTiuNoteHeaders", params);
    }

    @Override
    public CollectionServiceResponse<TiuNoteHeader> getAllTiuNoteHeaders(ISecurityContext securityContext, String dfn, String duz, int limit) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, duz, limit};
        return this.collectionResult(TiuNoteHeader.class, TiuNoteHeadersDao.class, "getAllTiuNoteHeaders", params);
    }

    @Override
    public ServiceResponse<UnsignedNoteHeaders> getUnsignedNoteHeaders(ISecurityContext securityContext, String authorDuz, int limit, boolean unsignedNotes, boolean uncosignedNotes) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{authorDuz, limit, unsignedNotes, uncosignedNotes};
        return this.singleResult(UnsignedNoteHeaders.class, TiuNoteHeadersDao.class, "getUnsignedNoteHeaders", params);
    }

    @Override
    public CollectionServiceResponse<TiuNoteHeader> getTiuNoteHeaders(ISecurityContext securityContext, String dfn, TiuNoteHeadersSelection tiuNoteHeadersSelection) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, tiuNoteHeadersSelection};
        return this.collectionResult(TiuNoteHeader.class, TiuNoteHeadersDao.class, "getTiuNoteHeaders", params);
    }

    @Override
    public ServiceResponse<QueueHandle> getUnsignedByServiceQueueHandle(ISecurityContext securityContext, String service) {
        this.setSecurityContext(securityContext);
        return this.singleResult(QueueHandle.class, TiuNoteHeadersDao.class, "getUnsignedByServiceQueueHandle", service);
    }

    @Override
    public CollectionServiceResponse<TiuNoteHeader> getUnsignedByServiceReport(ISecurityContext securityContext, String handle, boolean delete) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{handle, delete};
        return this.collectionResult(TiuNoteHeader.class, TiuNoteHeadersDao.class, "getUnsignedByServiceReport", params);
    }

    @Override
    public ServiceResponse<Boolean> deleteUnsignedByServiceReport(ISecurityContext securityContext, String handle) {
        this.setSecurityContext(securityContext);
        return this.singleResult(Boolean.class, TiuNoteHeadersDao.class, "deleteUnsignedByServiceReport", handle);
    }

    @Override
    public ServiceResponse<VitalSigns> getVitalSigns(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.singleResult(VitalSigns.class, VitalSignsDao.class, "getVitalSigns", dfn);
    }

    @Override
    public ServiceResponse<VitalSigns> getVitalSigns(ISecurityContext securityContext, String dfn, double fmFromDate, double fmThroughDate) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, fmFromDate, fmThroughDate};
        return this.singleResult(VitalSigns.class, VitalSignsDao.class, "getVitalSigns", params);
    }

    @Override
    public CollectionServiceResponse<VitalSignMeasurement> getVitalSignsList(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        return this.collectionResult(VitalSignMeasurement.class, VitalSignsDao.class, "getVitalSignsList", dfn);
    }

    @Override
    public CollectionServiceResponse<VitalSignMeasurement> getVitalSignsList(ISecurityContext securityContext, String dfn, double fmFromDate, double fmThroughDate) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, fmFromDate, fmThroughDate};
        return this.collectionResult(VitalSignMeasurement.class, VitalSignsDao.class, "getVitalSignsList", params);
    }

    @Override
    public ServiceResponse<String> getReportText(ISecurityContext securityContext, String dfn, Date fromDate, Date toDate, int nrpts, String arg) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, fromDate, toDate, nrpts, arg};
        return this.singleResult(String.class, ReportsDao.class, "getReportText", params);
    }

    @Override
    public ServiceResponse<VistaImageInfo> addVistaImage(ISecurityContext securityContext, String dfn, String duz, String fileExt) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn, duz, fileExt};
        return this.singleResult(VistaImageInfo.class, VistaImagingDao.class, "addVistaImage", params);
    }

    @Override
    public ServiceResponse<String> linkNoteToImage(ISecurityContext securityContext, String imageIen, String tiuNoteIen) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{imageIen, tiuNoteIen};
        return this.singleResult(String.class, VistaImagingDao.class, "linkNoteToImage", params);
    }

    @Override
    public CollectionServiceResponse<String> importVistaImage(ISecurityContext securityContext, List<String> nodeList) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{nodeList};
        return this.collectionResult(String.class, VistaImagingDao.class, "importVistaImage", params);
    }

    @Override
    public CollectionServiceResponse<RemoteStation> getRemoteSites(ISecurityContext securityContext, String dfn) {
        this.setSecurityContext(securityContext);
        Object[] params = new Object[]{dfn};
        return this.collectionResult(RemoteStation.class, RemoteSitesDao.class, "getRemoteSites", params);
    }
}

