/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.service.impl;

import gov.va.med.lom.foundation.service.response.ServiceResponse;
import gov.va.med.lom.vistabroker.auth.dao.VistaSignonDao;
import gov.va.med.lom.vistabroker.auth.dao.VistaSignonSetupDao;
import gov.va.med.lom.vistabroker.auth.data.ChangeVerifyCodeResult;
import gov.va.med.lom.vistabroker.auth.data.VistaServerInfo;
import gov.va.med.lom.vistabroker.auth.data.VistaSignonResult;
import gov.va.med.lom.vistabroker.security.ISecurityContext;
import gov.va.med.lom.vistabroker.security.SecurityContextFactory;
import gov.va.med.lom.vistabroker.service.AuthVBService;
import gov.va.med.lom.vistabroker.service.impl.BaseService;
import java.io.Serializable;
import javax.ejb.Remote;
import javax.ejb.Stateless;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless(name="gov.va.med.lom.vistabroker.AuthVBService")
@Remote(value={AuthVBService.class})
public class AuthVBServiceImpl
extends BaseService
implements AuthVBService,
Serializable {
    private static final String AUTH_APP_PROXY = "ALSIAPPPROXY,VISTA BROKER";

    public AuthVBServiceImpl() {
        this.setLogEvent(false);
        try {
            this.setSecurityContext(SecurityContextFactory.createAppProxySecurityContext(null, AUTH_APP_PROXY));
        }
        catch (Exception e) {
            log.warn((Object)"Exception creating app proxy security context for AuthRpcs.", (Throwable)e);
        }
    }

    @Override
    public ServiceResponse<String> getAVHelp(String division, boolean mustEnterOldVC) {
        this.securityContext.setDivision(division);
        return this.singleResult(String.class, VistaSignonSetupDao.class, "getAVHelp", mustEnterOldVC);
    }

    @Override
    public ServiceResponse<VistaServerInfo> getVistaServerInfo(String division) {
        this.securityContext.setDivision(division);
        return this.singleResult(VistaServerInfo.class, VistaSignonSetupDao.class, "getVistaServerInfo");
    }

    @Override
    public ServiceResponse<String> getIntroMessage(String division) {
        this.securityContext.setDivision(division);
        return this.singleResult(String.class, VistaSignonSetupDao.class, "getIntroMessage");
    }

    @Override
    public ServiceResponse<VistaSignonResult> doAVCodeAuth1(String division, String applicationName, String accessCode, String verifyCode, String clientIp) {
        this.verifyParam("division", division);
        this.verifyParam("applicationName", applicationName);
        this.verifyParam("accessCode", accessCode);
        this.verifyParam("verifyCode", verifyCode);
        this.verifyParam("clientIp", clientIp);
        return this.doAVCodeAuth2(division, applicationName, accessCode + ";" + verifyCode, clientIp);
    }

    @Override
    public ServiceResponse<VistaSignonResult> doAVCodeAuth2(String division, String applicationName, String avCode, String clientIp) {
        ISecurityContext sc;
        this.verifyParam("division", division);
        this.verifyParam("applicationName", applicationName);
        this.verifyParam("avCode", avCode);
        this.verifyParam("clientIp", clientIp);
        this.securityContext.setDivision(division);
        Object[] params = new String[]{division, applicationName, avCode, clientIp};
        ServiceResponse sr = this.singleResult(VistaSignonResult.class, VistaSignonDao.class, "doVistaSignon", params);
        this.logCall("doVistaSignon3");
        VistaSignonResult result = (VistaSignonResult)sr.getPayload();
        this.securityContext = sc = SecurityContextFactory.createDuzSecurityContext(division, result.getDuz());
        return sr;
    }

    private void verifyParam(String name, String value) {
        if (value == null) {
            throw new NullPointerException(name + " cannot be null.");
        }
    }

    @Override
    public ServiceResponse<ChangeVerifyCodeResult> changeVerifyCode(String division, String oldVerifyCode, String newVerifyCode, String confirmVerifyCode) {
        this.securityContext.setDivision(division);
        Object[] params = new String[]{oldVerifyCode, newVerifyCode, confirmVerifyCode};
        ServiceResponse sr = this.singleResult(ChangeVerifyCodeResult.class, VistaSignonDao.class, "changeVerifyCode", params);
        this.logCall("changeVerifyCode");
        return sr;
    }
}

