/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.exception.VistaBrokerException;
import gov.va.med.lom.vistabroker.patient.data.VitalSignMeasurement;
import gov.va.med.lom.vistabroker.patient.data.VitalSigns;
import gov.va.med.lom.vistabroker.util.FMDateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VitalSignsDao
extends BaseDao {
    public VitalSignsDao() {
    }

    public VitalSignsDao(BaseDao baseDao) {
        super(baseDao);
    }

    public VitalSigns getVitalSigns(String dfn) throws VistaBrokerException {
        return this.getVitalSigns(dfn, 1.0, 9999999.0);
    }

    public VitalSigns getVitalSigns(String dfn, double fmFromDate, double fmThroughDate) throws VistaBrokerException {
        List<String> list = this._getRawVitals(dfn, fmFromDate, fmThroughDate);
        VitalSigns vitalSigns = new VitalSigns();
        vitalSigns.setDfn(dfn);
        String ien = null;
        String recordType = null;
        Date date = null;
        String value = null;
        String dateStr = null;
        for (String x : list) {
            ien = StringUtils.piece((String)x, (int)1);
            recordType = StringUtils.piece((String)x, (int)2);
            date = FMDateUtils.fmDateTimeToDate(StringUtils.piece((String)x, (int)4));
            value = StringUtils.piece((String)x, (int)5);
            try {
                dateStr = DateUtils.toEnglishDate((Date)date);
            }
            catch (ParseException pe) {
                dateStr = null;
            }
            if (recordType.equals("T")) {
                vitalSigns.setTemperatureIen(ien);
                vitalSigns.setTemperature(value);
                vitalSigns.setTemperatureDate(date);
                vitalSigns.setTemperatureDateStr(dateStr);
                continue;
            }
            if (recordType.equals("P")) {
                vitalSigns.setPulseIen(ien);
                vitalSigns.setPulse(value);
                vitalSigns.setPulseDate(date);
                vitalSigns.setPulseDateStr(dateStr);
                continue;
            }
            if (recordType.equals("R")) {
                vitalSigns.setRespirationsIen(ien);
                vitalSigns.setRespirations(value);
                vitalSigns.setRespirationsDate(date);
                vitalSigns.setRespirationsDateStr(dateStr);
                continue;
            }
            if (recordType.equals("BP")) {
                vitalSigns.setBpIen(ien);
                vitalSigns.setBpSystolic(StringUtils.piece((String)value, (char)'/', (int)1));
                vitalSigns.setBpDiastolic(StringUtils.piece((String)value, (char)'/', (int)2));
                vitalSigns.setBpDate(date);
                vitalSigns.setBpDateStr(dateStr);
                continue;
            }
            if (recordType.equals("HT")) {
                vitalSigns.setHeightIen(ien);
                vitalSigns.setHeight(value);
                vitalSigns.setHeightDate(date);
                vitalSigns.setHeightDateStr(dateStr);
                continue;
            }
            if (recordType.equals("WT")) {
                vitalSigns.setWeightIen(ien);
                vitalSigns.setWeight(value);
                vitalSigns.setWeightDate(date);
                vitalSigns.setWeightDateStr(dateStr);
                continue;
            }
            if (recordType.equals("PN")) {
                vitalSigns.setPainIndexIen(ien);
                vitalSigns.setPainIndex(value);
                vitalSigns.setPainIndexDate(date);
                vitalSigns.setPainIndexDateStr(dateStr);
                continue;
            }
            if (recordType.equals("POX")) {
                vitalSigns.setPoxIen(ien);
                vitalSigns.setPox(value);
                vitalSigns.setPoxDate(date);
                vitalSigns.setPoxDateStr(dateStr);
                continue;
            }
            if (!recordType.equals("BMI")) continue;
            vitalSigns.setBMIIen(ien);
            vitalSigns.setBMI(value);
            vitalSigns.setBMIDate(date);
            vitalSigns.setBMIDateStr(dateStr);
        }
        return vitalSigns;
    }

    public List<VitalSignMeasurement> getVitalSignsList(String dfn) throws VistaBrokerException {
        return this.getVitalSignsList(dfn, 1.0, 9999999.0);
    }

    public List<VitalSignMeasurement> getVitalSignsList(String dfn, double fmFromDate, double fmThroughDate) throws VistaBrokerException {
        List<String> list = this._getRawVitals(dfn, fmFromDate, fmThroughDate);
        ArrayList<VitalSignMeasurement> measurements = new ArrayList<VitalSignMeasurement>();
        for (String x : list) {
            VitalSignMeasurement measurement = new VitalSignMeasurement();
            measurement.setIen(StringUtils.piece((String)x, (int)1));
            measurement.setTypeAbbr(StringUtils.piece((String)x, (int)2));
            measurement.setRawValue(StringUtils.piece((String)x, (int)3));
            measurement.setDate(FMDateUtils.fmDateTimeToDate(StringUtils.piece((String)x, (int)4)));
            measurement.setEnglishValue(StringUtils.piece((String)x, (int)5));
            measurement.setMetricValue(StringUtils.piece((String)x, (int)6));
            measurement.setQualifiers(StringUtils.piece((String)x, (int)7));
            measurements.add(measurement);
        }
        return measurements;
    }

    private List<String> _getRawVitals(String dfn, double fmFromDate, double fmThroughDate) throws VistaBrokerException {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQVI VITALS");
        Object[] params = new Object[]{dfn, fmFromDate, fmThroughDate};
        return this.lCall(params);
    }
}

