/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.patient.data.Problem;
import gov.va.med.lom.vistabroker.util.FMDateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProblemsDao
extends BaseDao {
    public static final String ACTIVE = "A";
    public static final String INACTIVE = "I";
    public static final String ALL = "B";
    public static final String REMOVED = "R";

    public ProblemsDao() {
    }

    public ProblemsDao(BaseDao baseDao) {
        super(baseDao);
    }

    public List<Problem> getProblems(String dfn, String status) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQPL PROBLEM LIST");
        if (!(status != null && (status.length() != 0 || status.equals(ACTIVE) && status.equals(INACTIVE) && status.equals(ALL) && status.equals(REMOVED)))) {
            status = ACTIVE;
        }
        Object[] params = new String[]{String.valueOf(dfn), status};
        List<String> list = this.lCall(params);
        ArrayList<Problem> problems = new ArrayList<Problem>();
        for (String s : list) {
            if (StringUtils.piece((String)s, (int)2).length() <= 0 || s.trim().length() <= 0 || StringUtils.piece((String)s, (int)1).length() <= 0) continue;
            Problem problem = new Problem();
            problem.setDfn(dfn);
            problem.setIen(StringUtils.piece((String)s, (int)1));
            problem.setDescription(StringUtils.piece((String)s, (int)3));
            problem.setStatus(StringUtils.piece((String)s, (int)2));
            problem.setCode(StringUtils.piece((String)s, (int)4));
            try {
                problem.setOnsetDate(FMDateUtils.fmDateTimeToDate(StringUtils.piece((String)s, (int)5)));
                problem.setOnsetDateStr(DateUtils.toEnglishDate((Date)problem.getOnsetDate()));
            }
            catch (ParseException pe) {
                // empty catch block
            }
            try {
                problem.setLastUpdated(FMDateUtils.fmDateTimeToDate(StringUtils.piece((String)s, (int)6)));
                problem.setLastUpdatedStr(DateUtils.toEnglishDate((Date)problem.getLastUpdated()));
            }
            catch (ParseException pe) {
                // empty catch block
            }
            problem.setScStatus(StringUtils.piece((String)s, (int)7));
            problem.setScConditions(StringUtils.piece((String)s, (int)17));
            problem.setDetailRpc(StringUtils.piece((String)s, (int)8));
            problem.setTranscribed(StringUtils.strToBool((String)StringUtils.piece((String)s, (int)9), (String)"T"));
            problem.setLocationIen(StringUtils.toLong((String)StringUtils.piece((String)StringUtils.piece((String)s, (int)10), (char)';', (int)1), (long)0L));
            problem.setLocation(StringUtils.piece((String)StringUtils.piece((String)s, (int)10), (char)';', (int)2));
            problem.setLocationType(StringUtils.piece((String)s, (int)11));
            problem.setProviderIen(StringUtils.piece((String)StringUtils.piece((String)s, (int)12), (char)';', (int)1));
            problem.setProvider(StringUtils.piece((String)StringUtils.piece((String)s, (int)12), (char)';', (int)2));
            problem.setServiceIen(StringUtils.piece((String)StringUtils.piece((String)s, (int)13), (char)';', (int)1));
            problem.setService(StringUtils.piece((String)StringUtils.piece((String)s, (int)13), (char)';', (int)2));
            String ver = null;
            String prio = null;
            char c = status.charAt(0);
            ver = StringUtils.piece((String)s, (int)18).equals("#") && (c == 'A' || c == 'B' || c == 'R') ? "#" : (problem.getTranscribed() ? "(u)" : "   ");
            prio = StringUtils.piece((String)s, (int)14).equals(ACTIVE) ? " * " : "   ";
            String version = problem.getStatus() + prio + ver;
            problem.setVersion(version);
            boolean hasComments = StringUtils.strToBool((String)StringUtils.piece((String)s, (int)15), (String)"1");
            if (hasComments) {
                this.setDefaultRpcName("ORQQPL PROB COMMENTS");
                List<String> comments = this.lCall(problem.getIen());
                problem.setComments(comments);
            }
            problems.add(problem);
        }
        return problems;
    }

    public String getProblemDetail(String dfn, String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQPL DETAIL");
        Object[] params = new Object[]{dfn, ien, ""};
        List<String> list = this.lCall(params);
        StringBuffer sb = new StringBuffer();
        for (String s : list) {
            sb.append(s + "\n");
        }
        return sb.toString().trim();
    }
}

