/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.patient.dao.TiuNoteDao;
import gov.va.med.lom.vistabroker.patient.data.Posting;
import gov.va.med.lom.vistabroker.patient.data.TiuNote;
import gov.va.med.lom.vistabroker.util.FMDateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostingsDao
extends BaseDao {
    public PostingsDao() {
    }

    public PostingsDao(BaseDao baseDao) {
        super(baseDao);
    }

    public List<Posting> getPostings(String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQPP LIST");
        List<String> list = this.lCall(dfn);
        ArrayList<Posting> postings = new ArrayList<Posting>();
        for (String s : list) {
            if (s.trim().length() <= 0) continue;
            Posting posting = new Posting();
            posting.setDfn(dfn);
            posting.setIen(StringUtils.piece((String)s, (int)1));
            posting.setName(StringUtils.mixedCase((String)StringUtils.piece((String)s, (int)2)));
            posting.setDate(FMDateUtils.fmDateTimeToDate(StringUtils.piece((String)s, (int)3)));
            try {
                posting.setDateStr(DateUtils.toEnglishDate((Date)posting.getDate()));
            }
            catch (ParseException pe) {
                // empty catch block
            }
            postings.add(posting);
        }
        return postings;
    }

    public String getDetailPosting(String dfn, String id) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQAL LIST REPORT");
        if (id.length() == 0 || id.equals("A")) {
            List<String> list = this.lCall(dfn);
            StringBuffer sb = new StringBuffer();
            for (String s : list) {
                sb.append(s + "\n");
            }
            return sb.toString().trim();
        }
        TiuNoteDao tiuNoteRpc = new TiuNoteDao(this);
        TiuNote tiuNote = tiuNoteRpc.getTiuNote(id);
        return tiuNote.getText();
    }
}

