/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.misc.dao.MiscRpcsDao;
import gov.va.med.lom.vistabroker.patient.data.Encounter;
import gov.va.med.lom.vistabroker.patient.data.EncounterAppointment;
import gov.va.med.lom.vistabroker.util.FMDateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatientEncounterDao
extends BaseDao {
    private static final String SKIP_ADMITS = "1";

    public PatientEncounterDao() {
    }

    public PatientEncounterDao(BaseDao baseDao) {
        super(baseDao);
    }

    public List<EncounterAppointment> getTodaysEncounterAppointments(String dfn) throws Exception {
        MiscRpcsDao miscRpcsDao = new MiscRpcsDao(this);
        long fmDate = miscRpcsDao.fmToday();
        Date today = FMDateUtils.fmDateTimeToDate(fmDate);
        GregorianCalendar fromCal = new GregorianCalendar();
        fromCal.setTime(today);
        fromCal.set(11, 0);
        fromCal.set(12, 0);
        fromCal.set(13, 1);
        GregorianCalendar toCal = new GregorianCalendar();
        toCal.setTime(today);
        toCal.set(11, 23);
        toCal.set(12, 59);
        toCal.set(13, 59);
        return this.getOutpatientEncounters(dfn, fromCal, toCal);
    }

    public List<EncounterAppointment> getOutpatientEncounters(String dfn, Calendar fromDate, Calendar toDate) throws Exception {
        List<EncounterAppointment> encounterList = this.getAllEncounters(dfn, fromDate, toDate);
        return this.filterEncounters(encounterList, null, "I");
    }

    public List<EncounterAppointment> getInpatientEncounters(String dfn, Calendar fromDate, Calendar toDate) throws Exception {
        List<EncounterAppointment> encounterList = this.getAllEncounters(dfn, fromDate, toDate);
        return this.filterEncounters(encounterList, "I", null);
    }

    public List<EncounterAppointment> getAllEncounters(String dfn, Calendar fromDate, Calendar toDate) throws Exception {
        return this.getAllEncounters(dfn, fromDate, toDate, false);
    }

    public List<EncounterAppointment> getAllEncounters(String dfn, Calendar fromDate, Calendar toDate, boolean skipAdmits) throws Exception {
        double fmDate2;
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWCV VST");
        MiscRpcsDao miscRpcsDao = new MiscRpcsDao(this);
        long fmDate = miscRpcsDao.fmToday();
        Date today = FMDateUtils.fmDateTimeToDate(fmDate);
        Date date1 = null;
        Date date2 = null;
        date1 = fromDate == null ? DateUtils.subtractDaysFromDate((Date)today, (int)365) : fromDate.getTime();
        date2 = toDate == null ? DateUtils.addDaysToDate((Date)today, (int)30) : toDate.getTime();
        double fmDate1 = FMDateUtils.dateTimeToFMDateTime(date1);
        if (fmDate1 - (double)((int)fmDate1) == 0.0) {
            fmDate1 += 1.0E-6;
        }
        if ((fmDate2 = FMDateUtils.dateTimeToFMDateTime(date2)) - (double)((int)fmDate2) == 0.0) {
            fmDate2 += 1.0E-6;
        }
        String param4 = null;
        param4 = skipAdmits ? SKIP_ADMITS : "0";
        Object[] params = new Object[]{dfn, fmDate1, fmDate2, param4};
        List<String> list = this.lCall(params);
        ArrayList<EncounterAppointment> encounterList = new ArrayList<EncounterAppointment>();
        for (String s : list) {
            EncounterAppointment appointment = new EncounterAppointment();
            appointment.setRpcResult(s);
            String t = StringUtils.piece((String)s, (int)1);
            appointment.setDfn(dfn);
            String type = StringUtils.piece((String)t, (char)';', (int)1);
            appointment.setType(type);
            appointment.setLocationIen(StringUtils.piece((String)t, (char)';', (int)3));
            double fmDt = StringUtils.toDouble((String)StringUtils.piece((String)s, (int)2), (double)0.0);
            appointment.setFmdatetime(fmDt);
            if (fmDt > 0.0) {
                try {
                    appointment.setDatetimeStr(FMDateUtils.fmDateTimeToEnglishDateTime(fmDt));
                    appointment.setDatetime(FMDateUtils.fmDateTimeToDate(fmDt));
                }
                catch (ParseException pe) {
                    // empty catch block
                }
            }
            if (type.length() > 0) {
                appointment.setStandalone(type.charAt(0) == 'V');
                if (type.equals("I")) {
                    appointment.setLocationName(StringUtils.piece((String)s, (int)3) + " (" + StringUtils.piece((String)s, (int)4) + ")");
                    appointment.setStatus(StringUtils.piece((String)s, (int)5));
                } else {
                    appointment.setLocationName(StringUtils.piece((String)s, (int)3));
                    appointment.setStatus(StringUtils.piece((String)s, (int)4));
                }
            } else {
                appointment.setStandalone(true);
                appointment.setLocationName(StringUtils.piece((String)s, (int)3));
                appointment.setStatus(StringUtils.piece((String)s, (int)4));
            }
            String dts = null;
            try {
                dts = fmDt > 0.0 ? FMDateUtils.fmDateToEnglishDate(fmDt) : "";
            }
            catch (ParseException pe) {
                dts = "";
            }
            appointment.setTitle(appointment.getLocationName() + "  " + dts);
            encounterList.add(appointment);
        }
        return encounterList;
    }

    public Encounter getEncounterDetails(Encounter anEncounter, boolean inpatient) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPT ENCTITL");
        Encounter encounter = new Encounter();
        encounter.setDfn(anEncounter.getDfn());
        encounter.setFmdatetime(anEncounter.getFmdatetime());
        encounter.setDatetime(anEncounter.getDatetime());
        encounter.setDatetimeStr(anEncounter.getDatetimeStr());
        encounter.setLocationIen(anEncounter.getLocationIen());
        encounter.setProviderDuz(anEncounter.getProviderDuz());
        encounter.setTypeId(anEncounter.getTypeId());
        encounter.setType(anEncounter.getType());
        encounter.setTiuNoteIen(anEncounter.getTiuNoteIen());
        Object[] params = new Object[]{anEncounter.getDfn(), anEncounter.getLocationIen(), anEncounter.getProviderDuz()};
        String x = this.sCall(params);
        encounter.setLocationName(StringUtils.piece((String)x, (int)1));
        encounter.setLocationAbbr(StringUtils.piece((String)x, (int)2));
        encounter.setRoomBed(StringUtils.piece((String)x, (int)3));
        encounter.setProviderName(StringUtils.piece((String)x, (int)4));
        String c = this.getVisitCategory("A", anEncounter.getLocationIen(), inpatient);
        encounter.setVisitCat(c);
        encounter.setStandalone(c.equals("A") || c.equals("V"));
        encounter.setVisitStr(encounter.getLocationIen() + ";" + anEncounter.getFmdatetime() + ";" + encounter.getVisitCat());
        encounter.setNeedVisit(anEncounter.getFmdatetime() == 0.0 && encounter.getLocationIen().equals("0"));
        String loc = null;
        loc = encounter.getLocationAbbr().length() > 0 ? encounter.getLocationAbbr() : encounter.getLocationName();
        if (encounter.getLocationName().length() > 0) {
            if (encounter.getVisitCat().equals("H")) {
                encounter.setLocationText(loc + " " + encounter.getRoomBed());
            } else {
                String dtTm = null;
                try {
                    dtTm = DateUtils.formatDate((String)DateUtils.toAnsiDateTime((Date)FMDateUtils.fmDateTimeToDate(anEncounter.getFmdatetime())));
                }
                catch (ParseException pe) {
                    dtTm = "";
                }
                encounter.setLocationText(loc + " " + dtTm);
            }
        } else {
            encounter.setLocationText("");
        }
        return encounter;
    }

    public String getVisitCategory(String initialCat, String locationIen, boolean inpatient) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPCE GETSVC");
        Object[] params = new Object[]{initialCat, locationIen, inpatient};
        String y = this.sCall(params);
        if (y.length() > 0) {
            return y;
        }
        return initialCat;
    }

    public String getEncFutureDays() throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWTPD1 GETEAFL");
        return this.sCall();
    }

    public String savePceData(List<String> pceList, String noteIen, String locationIen) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPCE SAVE");
        Object[] params = new Object[]{pceList, noteIen, locationIen};
        return this.sCall(params);
    }

    private List<EncounterAppointment> filterEncounters(List<EncounterAppointment> encounterList, String includeType, String excludeType) {
        ArrayList<EncounterAppointment> encounters = new ArrayList<EncounterAppointment>();
        for (EncounterAppointment e : encounterList) {
            if (includeType != null && !e.getType().equals(includeType) || excludeType != null && e.getType().equals(excludeType)) continue;
            encounters.add(e);
        }
        return encounters;
    }
}

