/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.exception.ExceptionUtils;
import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.exception.VistaBrokerIllegalStateException;
import gov.va.med.lom.vistabroker.patient.data.ConstructOrder;
import gov.va.med.lom.vistabroker.patient.data.DGroup;
import gov.va.med.lom.vistabroker.patient.data.DcReason;
import gov.va.med.lom.vistabroker.patient.data.LockDocumentResult;
import gov.va.med.lom.vistabroker.patient.data.NewOrder;
import gov.va.med.lom.vistabroker.patient.data.OrderDetails;
import gov.va.med.lom.vistabroker.patient.data.OrderDialogPrompt;
import gov.va.med.lom.vistabroker.patient.data.OrderDialogResolved;
import gov.va.med.lom.vistabroker.patient.data.OrderInfo;
import gov.va.med.lom.vistabroker.patient.data.OrderResponse;
import gov.va.med.lom.vistabroker.patient.data.OrderSheet;
import gov.va.med.lom.vistabroker.patient.data.OrderStatus;
import gov.va.med.lom.vistabroker.patient.data.OrderView;
import gov.va.med.lom.vistabroker.patient.data.OrdersInfoList;
import gov.va.med.lom.vistabroker.util.FMDateUtils;
import gov.va.med.vistalink.rpc.RpcRequest;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrdersDao
extends BaseDao {
    private static final Log log = LogFactory.getLog(OrdersDao.class);
    private static HashMap<String, List<String>> dGroupMap = new HashMap();
    public static final int STS_ACTIVE = 2;
    public static final int STS_DISCONTINUED = 3;
    public static final int STS_COMPLETE = 4;
    public static final int STS_EXPIRING = 5;
    public static final int STS_RECENT = 6;
    public static final int STS_UNVERIFIED = 8;
    public static final int STS_UNVER_NURSE = 9;
    public static final int STS_UNVER_CLERK = 10;
    public static final int STS_UNSIGNED = 11;
    public static final int STS_FLAGGED = 12;
    public static final int STS_HELD = 18;
    public static final int STS_NEW = 19;
    public static final int STS_CURRENT = 23;
    public static final String TITLE_ACTIVE = "Active Orders (includes Pending & Recent Activity) - ALL SERVICES";
    public static final String TITLE_CURRENT = "Current Orders (Active & Pending Status Only) - ALL SERVICES";
    public static final String TITLE_EXPIRING = "Expiring Orders - ALL SERVICES";
    public static final String TITLE_UNSIGNED = "Unsigned Orders - ALL SERVICES";
    private static final int ORDER_URGENCY_RPC_EXISTS = 1;
    private static final int ORDER_URGENCY_RPC_NOT_EXISTS = 0;
    private int orderUrgencyRpcContextState = 1;
    private String orderUrgencyRpcContext = null;
    private static Pattern labOrderNumPattern = null;
    private static Pattern orderTextPattern = null;
    private static Pattern natureOfOrderPattern = null;
    private static Pattern enteredByPattern = null;
    private static Pattern releasedByPattern = null;
    private static Pattern signedByPattern = null;
    private static Pattern orderedByPattern = null;
    private static Pattern currentDataPattern = null;
    private static Pattern treatingSpecialtyPattern = null;
    private static Pattern orderingLocationPattern = null;
    private static Pattern startDatetimePattern = null;
    private static Pattern stopDatetimePattern = null;
    private static Pattern currentStatusPattern = null;
    private static Pattern orderNumPattern = null;
    private static Pattern labTestPattern = null;
    private static Pattern collectedByPattern = null;
    private static Pattern collectionSamplePattern = null;
    private static Pattern specimenPattern = null;
    private static Pattern collectionDatetimePattern = null;
    private static Pattern urgencyPattern = null;
    private static Pattern howOftenPattern = null;
    private static final char[] DELAY_EVENTS = new char[]{'A', 'D', 'T', 'M', 'O'};
    public static final String TX_WPTYPE = "^WP^";

    public OrdersDao() {
    }

    public OrdersDao(BaseDao baseDao) {
        super(baseDao);
    }

    public static String getNameOfStatus(String ien) {
        String name = null;
        if (ien.equals("0")) {
            name = "error";
        } else if (ien.equals("1")) {
            name = "discontinued";
        } else if (ien.equals("2")) {
            name = "complete";
        } else if (ien.equals("3")) {
            name = "hold";
        } else if (ien.equals("4")) {
            name = "flagged";
        } else if (ien.equals("5")) {
            name = "pending";
        } else if (ien.equals("6")) {
            name = "active";
        } else if (ien.equals("7")) {
            name = "expired";
        } else if (ien.equals("8")) {
            name = "scheduled";
        } else if (ien.equals("9")) {
            name = "partial results";
        } else if (ien.equals("10")) {
            name = "delayed";
        } else if (ien.equals("11")) {
            name = "unreleased";
        } else if (ien.equals("12")) {
            name = "dc/edit";
        } else if (ien.equals("13")) {
            name = "cancelled";
        } else if (ien.equals("14")) {
            name = "lapsed";
        } else if (ien.equals("15")) {
            name = "renewed";
        } else if (ien.equals("97")) {
            name = "";
        } else if (ien.equals("98")) {
            name = "new";
        } else if (ien.equals("99")) {
            name = "no status";
        }
        return name;
    }

    public String getLabOrderDetails(String dfn, String orderId) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQLR DETAIL");
        Object[] params = new Object[]{String.valueOf(dfn), orderId};
        List<String> list = this.lCall(params);
        StringBuffer results = new StringBuffer();
        for (String s : list) {
            results.append(s + '\n');
        }
        return results.toString().trim();
    }

    public OrderView getOrderViewDefault() throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWOR VWGET");
        String x = this.sCall();
        OrderView orderView = new OrderView();
        orderView.setChanged(false);
        orderView.setDGroup(StringUtils.piece((String)x, (char)';', (int)4));
        orderView.setFilter(StringUtils.toInt((String)StringUtils.piece((String)x, (char)';', (int)3), (int)0));
        orderView.setInvChrono(StringUtils.piece((String)x, (char)';', (int)6).equals("R"));
        orderView.setByService(StringUtils.piece((String)x, (char)';', (int)7).equals("1"));
        orderView.setFmTimeFrom(StringUtils.toDouble((String)StringUtils.piece((String)x, (char)';', (int)1), (double)0.0));
        orderView.setFmTimeFrom(StringUtils.toDouble((String)StringUtils.piece((String)x, (char)';', (int)2), (double)0.0));
        orderView.setContextTime(0);
        orderView.setTextView(0);
        orderView.setViewName(StringUtils.piece((String)x, (char)';', (int)8));
        orderView.setEventDelayType("C");
        orderView.setEventDelaySpecialty(0);
        orderView.setEventDelayEffective(0);
        return orderView;
    }

    public OrderInfo getOrderByIfn(String id) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWORR GETBYIFN");
        List<String> l = this.lCall(id);
        return this.setOrderFromResults(l);
    }

    private OrderInfo setOrderFromResults(List<String> l) {
        String x = "";
        StringBuffer y = new StringBuffer();
        StringBuffer z = new StringBuffer();
        while (l.size() > 0) {
            x = l.get(0);
            l.remove(0);
            if (x.charAt(0) != '~') continue;
            y.delete(0, y.length());
            while (l.size() > 0 && l.get(0).charAt(0) != '~' && l.get(0).charAt(0) != '|') {
                y.append(l.get(0).substring(1, l.get(0).length()));
                y.append('\r');
                y.append('\n');
                l.remove(0);
            }
            if (y.length() > 0) {
                y.delete(y.length() - 2, y.length());
            }
            z.delete(0, z.length());
            if (l.size() <= 0 || !l.get(0).equals("|")) continue;
            l.remove(0);
            while (l.size() > 0 && l.get(0).charAt(0) != '~' && l.get(0).charAt(0) != '|') {
                z.append(l.get(0).substring(1, l.get(0).length()));
                l.remove(0);
            }
        }
        return this.setOrderFields(x, y.toString(), z.toString());
    }

    public String getOrderDetails(String orderId, String patientDfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQOR DETAIL");
        Object[] params = new Object[]{orderId, patientDfn};
        List<String> list = this.lCall(params);
        StringBuffer results = new StringBuffer();
        for (String s : list) {
            results.append(s + '\n');
        }
        return results.toString().trim();
    }

    public String getOrderDetails(String orderId) throws Exception {
        return this.getOrderDetails(orderId, "0");
    }

    public String getAlsiOrderDetails(String orderId) throws Exception {
        this.setDefaultContext(null);
        this.setDefaultRpcName("ALSI ORDER DETAIL");
        Object[] params = new Object[]{orderId};
        List<String> list = this.lCall(params);
        StringBuffer results = new StringBuffer();
        for (String s : list) {
            results.append(s + '\n');
        }
        return results.toString().trim();
    }

    public String getOrderResult(String dfn, String orderId) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWOR RESULT");
        Object[] params = new Object[]{String.valueOf(dfn), orderId, orderId};
        List<String> list = this.lCall(params);
        StringBuffer results = new StringBuffer();
        for (String s : list) {
            results.append(s + '\n');
        }
        return results.toString().trim();
    }

    public List<String> getDGroupMap() throws Exception {
        return this.getDGroupMap(true);
    }

    private List<String> getDGroupMap(boolean primary) throws Exception {
        List<String> dGroup = dGroupMap.get(this.getDivision());
        if (dGroup != null) {
            return dGroup;
        }
        if (!primary && (this.securityContext.getRpcContext() != null && this.securityContext.getRpcContext().length() > 0 || this.securityContext.getRpcName() != null && this.securityContext.getRpcName().length() > 0)) {
            String err = "The security context has an overriding rpc context or rpc name so this  rpc cannot be called indirectly.  This method caches the DGroup into a static map, it must be called once before any method requiring access to the map, particularly patient orders";
            log.error((Object)err);
            throw new VistaBrokerIllegalStateException(err);
        }
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWORDG MAPSEQ");
        dGroup = this.lCall();
        dGroupMap.put(this.getDivision(), dGroup);
        return dGroup;
    }

    public DGroup getSeqOfDGroup(String ien) throws Exception {
        List<String> dGroup = this.getDGroupMap(false);
        String value = null;
        for (int i = 0; i < dGroup.size(); ++i) {
            String k = StringUtils.piece((String)dGroup.get(i), (char)'=', (int)1);
            if (!k.equals(ien)) continue;
            value = StringUtils.piece((String)dGroup.get(i), (char)'=', (int)2);
            break;
        }
        if (value != null) {
            DGroup dgroup = new DGroup();
            dgroup.setIen(StringUtils.piece(value, (int)1));
            dgroup.setItem(StringUtils.piece(value, (int)2));
            dgroup.setSubitem(StringUtils.piece((String)value, (int)3));
            return dgroup;
        }
        return null;
    }

    public List<OrderSheet> getOrderSheets(String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWOR SHEETS");
        ArrayList<OrderSheet> orderSheets = new ArrayList<OrderSheet>();
        List<String> list = this.lCall(dfn);
        for (String s : list) {
            OrderSheet orderSheet = new OrderSheet();
            orderSheet.setCode(StringUtils.piece((String)s, (int)1));
            orderSheet.setId(StringUtils.piece((String)s, (int)2));
            orderSheet.setName(StringUtils.piece((String)s, (int)3));
            orderSheets.add(orderSheet);
        }
        return orderSheets;
    }

    public List<DcReason> getDiscontinueReasons() throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDX2 DCREASON");
        ArrayList<DcReason> dcReasons = new ArrayList<DcReason>();
        List<String> list = this.lCall();
        for (String s : list) {
            if (s.startsWith("~")) continue;
            DcReason dcReason = new DcReason();
            dcReason.setIen(StringUtils.piece((String)s.substring(1, s.length()), (int)1));
            dcReason.setName(StringUtils.piece((String)s, (int)2));
            dcReasons.add(dcReason);
        }
        return dcReasons;
    }

    public int discontinueOrder(String orderId, String providerDuz, String locationIen, String reasonIen, boolean dcOrigOrder, boolean newOrder) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDXA DC");
        String dcOrigOrderStr = StringUtils.boolToStr((boolean)dcOrigOrder, (String)"1", (String)"0");
        String newOrderStr = StringUtils.boolToStr((boolean)newOrder, (String)"1", (String)"0");
        Object[] params = new Object[]{orderId, providerDuz, locationIen, reasonIen, dcOrigOrderStr, newOrderStr};
        String x = this.sCall(params);
        return StringUtils.toInt((String)StringUtils.piece((String)x, (int)14), (int)0);
    }

    public OrderInfo holdOrder(String orderId, String providerDuz) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDXA HOLD");
        Object[] params = new Object[]{orderId, providerDuz};
        List<String> l = this.lCall(params);
        return this.setOrderFromResults(l);
    }

    public OrderInfo releaseOrderHold(String orderId, String providerDuz) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDXA UNHOLD");
        Object[] params = new Object[]{orderId, providerDuz};
        List<String> l = this.lCall(params);
        return this.setOrderFromResults(l);
    }

    public OrderInfo verifyOrder(String orderId, String esCode) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDXA VERIFY");
        Object[] params = new Object[]{orderId, esCode};
        List<String> l = this.lCall(params);
        return this.setOrderFromResults(l);
    }

    public OrderInfo completeOrder(String orderId, String esCode) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDXA COMPLETE");
        Object[] params = new Object[]{orderId, esCode};
        List<String> l = this.lCall(params);
        return this.setOrderFromResults(l);
    }

    public OrdersInfoList getOrdersListForDefaultView(String dfn) throws Exception {
        OrderView orderView = this.getOrderViewDefault();
        return this.getOrdersList(dfn, orderView);
    }

    public OrdersInfoList getOrdersList(String dfn, OrderView orderView) throws Exception {
        return this.getOrdersList(dfn, orderView, null);
    }

    public OrdersInfoList getOrdersList(String dfn, OrderView orderView, Calendar startDate) throws Exception {
        return this.getOrdersList(dfn, orderView, startDate, true);
    }

    public OrdersInfoList getOrdersList(String dfn, OrderView orderView, Calendar startDate, boolean checkUrgency) throws Exception {
        OrdersInfoList ordersInfoList = this.getOrdersAbbr(dfn, orderView);
        return this.getOrdersList(dfn, startDate, checkUrgency, ordersInfoList);
    }

    public OrdersInfoList getOrdersList(String dfn, Calendar startDate, boolean checkUrgency, OrdersInfoList ordersInfoList) throws Exception {
        if (ordersInfoList == null || ordersInfoList.getOrdersInfo() == null || ordersInfoList.getOrdersInfo().size() == 0) {
            return null;
        }
        ArrayList<OrderInfo> ordersList = new ArrayList<OrderInfo>();
        ArrayList<String> idList = new ArrayList<String>();
        List<OrderInfo> orders = ordersInfoList.getOrdersInfo();
        for (OrderInfo o : orders) {
            idList.add(o.getId());
        }
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWORR GET4LST");
        Object[] params = new Object[]{String.valueOf(ordersInfoList.getTextView()), String.valueOf(ordersInfoList.getFmDatetime()), idList};
        this.setTimeoutForCall(30000);
        List<String> list = this.lCall(params);
        int orderIndex = -1;
        StringBuffer orderData = new StringBuffer();
        StringBuffer text = new StringBuffer();
        StringBuffer xmlText = new StringBuffer();
        OrderInfo orderInfo = null;
        int lineIndex = 0;
        while (list.size() > 0 && lineIndex < list.size()) {
            String x = list.get(lineIndex);
            text.delete(0, text.length());
            if (x.charAt(0) != '~' && !StringUtils.piece((String)x, (int)1).equals("~" + orderInfo.getId())) {
                while (lineIndex < list.size() && x.charAt(0) != '~' && x.charAt(0) != '|') {
                    orderData.append(x + '\n');
                    text.append(x.substring(1) + '\n');
                    do {
                        if (++lineIndex >= list.size()) continue;
                        x = list.get(lineIndex);
                    } while (x.length() == 0 && lineIndex < list.size());
                }
                if (text.length() > 0) {
                    text.deleteCharAt(text.length() - 1);
                }
                orderInfo.setText(text.toString());
                xmlText.delete(0, xmlText.length());
                if (x.charAt(0) == '|') {
                    x = list.get(++lineIndex);
                    while (lineIndex < list.size() && x.charAt(0) != '~' && x.charAt(0) != '|') {
                        orderData.append(x + '\n');
                        text.append(x.substring(1) + '\n');
                        do {
                            if (++lineIndex >= list.size()) continue;
                            x = list.get(lineIndex);
                        } while (x.length() == 0 && lineIndex < list.size());
                    }
                }
                orderInfo.setXmlText(xmlText.toString());
                orders.set(orderIndex, orderInfo);
                continue;
            }
            double orderFmDatetime = StringUtils.toDouble((String)StringUtils.piece((String)x, (int)3), (double)0.0);
            Date date = FMDateUtils.fmDateTimeToDate(orderFmDatetime);
            orderData.append(x + '\n');
            orderInfo = new OrderInfo();
            ++orderIndex;
            if (date != null) {
                GregorianCalendar gc = new GregorianCalendar();
                gc.setTime(date);
                orderInfo.setOrderDatetime(gc);
            }
            OrderInfo oi = orders.get(orderIndex);
            orderInfo.setId(oi.getId());
            orderInfo.setEventPtr(oi.getEventPtr());
            orderInfo.setEventName(oi.getEventName());
            orderInfo.setDGroupSeq(oi.getDGroupSeq());
            orderInfo.setDGroupName(oi.getDGroupName());
            orderInfo.setDGroup(StringUtils.piece((String)x, (int)2));
            orderInfo.setFmOrderDatetime(orderFmDatetime);
            try {
                orderInfo.setOrderDatetimeStr(FMDateUtils.fmDateTimeToEnglishDateTime(orderFmDatetime));
            }
            catch (ParseException pe) {
                // empty catch block
            }
            try {
                orderInfo.setStartTimeStr(FMDateUtils.fmDateTimeToEnglishDateTime(StringUtils.toDouble((String)StringUtils.piece((String)x, (int)4), (double)0.0)));
            }
            catch (ParseException pe) {
                // empty catch block
            }
            try {
                orderInfo.setStopTimeStr(FMDateUtils.fmDateTimeToEnglishDateTime(StringUtils.toDouble((String)StringUtils.piece((String)x, (int)5), (double)0.0)));
            }
            catch (ParseException pe) {
                // empty catch block
            }
            orderInfo.setStatusIen(StringUtils.piece((String)x, (int)6));
            orderInfo.setStatus(OrdersDao.getNameOfStatus(orderInfo.getStatusIen()));
            orderInfo.setSignature(StringUtils.toInt((String)StringUtils.piece((String)x, (int)7), (int)0));
            orderInfo.setVerNurse(StringUtils.piece((String)x, (int)8));
            orderInfo.setVerClerk(StringUtils.piece((String)x, (int)9));
            orderInfo.setChartRev(StringUtils.piece((String)x, (int)15));
            orderInfo.setProviderDuz(StringUtils.piece((String)x, (int)10));
            orderInfo.setProviderName(StringUtils.piece((String)x, (int)11));
            orderInfo.setProviderDEA(StringUtils.piece((String)x, (int)16));
            orderInfo.setProviderVA(StringUtils.piece((String)x, (int)17));
            orderInfo.setDigSigReq(StringUtils.piece((String)x, (int)18));
            orderInfo.setFlagged(StringUtils.piece((String)x, (int)13).equals("1"));
            String urgency = null;
            if (checkUrgency) {
                urgency = this.getOrderUrgency(orderInfo.getId(), dfn);
            }
            if (urgency == null) {
                urgency = "";
            }
            orderInfo.setUrgency(urgency);
            orderData.delete(0, orderData.length());
            if (startDate == null || date.getTime() >= startDate.getTimeInMillis()) {
                ordersList.add(orderInfo);
            }
            ++lineIndex;
        }
        OrdersInfoList newOrdersInfoList = new OrdersInfoList();
        newOrdersInfoList.setCount(ordersList.size());
        newOrdersInfoList.setTextView(ordersInfoList.getTextView());
        newOrdersInfoList.setFmDatetime(ordersInfoList.getFmDatetime());
        newOrdersInfoList.setOrdersInfo(orders);
        return newOrdersInfoList;
    }

    public OrdersInfoList getOrdersAbbrForDefaultView(String dfn) throws Exception {
        OrderView orderView = this.getOrderViewDefault();
        return this.getOrdersAbbr(dfn, orderView);
    }

    public OrdersInfoList getOrdersAbbr(String dfn, OrderView orderView) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWORR AGET");
        String filterTS = String.valueOf(orderView.getFilter()) + "^" + String.valueOf(orderView.getEventDelaySpecialty());
        Object[] params = new Object[]{dfn, filterTS, orderView.getDGroup(), String.valueOf(orderView.getFmTimeFrom()), String.valueOf(orderView.getFmTimeThru()), "C;0"};
        this.setTimeoutForCall(60000);
        List<String> list = this.lCall(params);
        OrdersInfoList ordersInfoList = new OrdersInfoList();
        if (list.size() > 0) {
            String x = list.get(0);
            int num = StringUtils.toInt((String)StringUtils.piece((String)x, (int)1), (int)0);
            ordersInfoList.setTextView(StringUtils.toInt((String)StringUtils.piece((String)x, (int)2), (int)0));
            ordersInfoList.setFmDatetime(StringUtils.toDouble((String)StringUtils.piece((String)x, (int)3), (double)0.0));
            ArrayList<OrderInfo> orders = new ArrayList<OrderInfo>();
            if (num > 0) {
                int index = 0;
                for (String s : list) {
                    if (index > 0) {
                        OrderInfo orderInfo = new OrderInfo();
                        orderInfo = new OrderInfo();
                        orderInfo.setId(StringUtils.piece((String)s, (int)1));
                        orderInfo.setDGroup(StringUtils.piece((String)s, (int)2));
                        orderInfo.setFmOrderDatetime(StringUtils.toDouble((String)StringUtils.piece((String)s, (int)3), (double)0.0));
                        Date date = FMDateUtils.fmDateTimeToDate(orderInfo.getFmOrderDatetime());
                        if (date != null) {
                            GregorianCalendar gc = new GregorianCalendar();
                            gc.setTime(date);
                            orderInfo.setOrderDatetime(gc);
                            try {
                                orderInfo.setOrderDatetimeStr(FMDateUtils.fmDateTimeToEnglishDateTime(orderInfo.getFmOrderDatetime()));
                            }
                            catch (ParseException pe) {
                                // empty catch block
                            }
                        }
                        orderInfo.setEventPtr(StringUtils.piece((String)s, (int)4));
                        orderInfo.setEventName(StringUtils.piece((String)s, (int)5));
                        DGroup dgroup = this.getSeqOfDGroup(orderInfo.getDGroup());
                        if (dgroup != null) {
                            orderInfo.setDGroupSeq(dgroup.getIen());
                            orderInfo.setDGroupName(dgroup.getItem());
                        }
                        orders.add(orderInfo);
                    }
                    ++index;
                }
            }
            ordersInfoList.setOrdersInfo(orders);
        }
        return ordersInfoList;
    }

    public List<String> getUnsignedOrders(String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWOR UNSIGN");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("0", "");
        Object[] params = new Object[]{String.valueOf(dfn), map};
        return this.lCall(params);
    }

    public String getDisplayGroupIen(String group) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWORDG IEN");
        Object[] params = new Object[]{group};
        return this.sCall(params);
    }

    public OrderStatus parseOrderDetail(String orderId, String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQOR DETAIL");
        Object[] params = new Object[]{orderId, String.valueOf(dfn)};
        List<String> list = this.lCall(params);
        OrderStatus orderStatus = new OrderStatus();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String x = list.get(i).toUpperCase();
            if (x.startsWith("ACTIVITY:")) {
                orderStatus.setOrderDatetimeStr(list.get(i + 1).substring(0, 16));
                try {
                    orderStatus.setOrderDatetime(DateUtils.convertDateStr((String)orderStatus.getOrderDatetimeStr(), (String)DateUtils.ENGLISH_DATE_TIME_FORMAT2));
                }
                catch (ParseException pe) {}
                continue;
            }
            if (x.startsWith("LAB TEST:")) {
                orderStatus.setOrderName(x.substring(9, x.length()));
                continue;
            }
            if (x.startsWith("ORDERED BY:")) {
                orderStatus.setOrderedBy(x.substring(11, x.length()));
                continue;
            }
            if (x.startsWith("COLLECTION DATE/TIME:")) {
                orderStatus.setCollectionDatetimeStr(x.substring(21, x.length()));
                try {
                    orderStatus.setCollectionDatetime(DateUtils.convertDateStr((String)orderStatus.getCollectionDatetimeStr(), (String)DateUtils.ENGLISH_DATE_TIME_FORMAT2));
                }
                catch (ParseException pe) {}
                continue;
            }
            if (x.startsWith("SIGNATURE:")) {
                orderStatus.setSignedBy(x.substring(10, x.length()));
                continue;
            }
            if (x.startsWith("URGENCY:")) {
                orderStatus.setUrgency(x.substring(8, x.length()));
                continue;
            }
            if (x.startsWith("ELEC SIGNATURE:")) {
                orderStatus.setSignedBy(x.substring(15, x.length()));
                continue;
            }
            if (!x.startsWith("CURRENT STATUS:")) continue;
            orderStatus.setStatus(x.substring(15, x.length()));
        }
        return orderStatus;
    }

    public String getOrderUrgency(String orderId, String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        if (this.orderUrgencyRpcContextState == 1) {
            if (this.orderUrgencyRpcContext == null) {
                this.orderUrgencyRpcContext = "OR CPRS GUI CHART";
            }
            try {
                return this.doGetOrderUrgency(orderId, this.orderUrgencyRpcContext);
            }
            catch (Exception be1) {
                try {
                    log.warn((Object)("'ALSI URGENCY OF ORDER' is not registered to '" + this.orderUrgencyRpcContext + "' context."));
                    this.orderUrgencyRpcContext = "ALS CLINICAL RPC";
                    return this.doGetOrderUrgency(orderId, this.orderUrgencyRpcContext);
                }
                catch (Exception be2) {
                    log.warn((Object)("'ALSI URGENCY OF ORDER' is not registered to '" + this.orderUrgencyRpcContext + "' context."));
                    this.orderUrgencyRpcContext = "";
                    this.orderUrgencyRpcContextState = 0;
                    return this.parseOrderUrgency(orderId, dfn);
                }
            }
        }
        return this.parseOrderUrgency(orderId, dfn);
    }

    private String doGetOrderUrgency(String orderId, String context) throws Exception {
        this.setDefaultContext(context);
        orderId = StringUtils.piece((String)orderId, (char)';', (int)1);
        Object[] params = new Object[]{orderId};
        String urgency = null;
        String saveRpcName = null;
        try {
            if (this.securityContext.getRpcName() != null && this.securityContext.getRpcName().length() > 0) {
                saveRpcName = this.securityContext.getRpcName();
                this.securityContext.setRpcName("ALSI URGENCY OF ORDER");
            }
            this.setDefaultRpcName("ALSI URGENCY OF ORDER");
            urgency = this.sCall(params);
            if (saveRpcName != null) {
                this.securityContext.setRpcName(saveRpcName);
            }
        }
        catch (Exception be) {
            try {
                throw new Exception("ALSI URGENCY OF ORDER is not registered in the context " + context);
            }
            catch (Throwable throwable) {
                if (saveRpcName != null) {
                    this.securityContext.setRpcName(saveRpcName);
                }
                throw throwable;
            }
        }
        if (urgency.equals("0")) {
            urgency = "";
        }
        return urgency;
    }

    public String parseOrderUrgency(String orderId, String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQOR DETAIL");
        Object[] params2 = new Object[]{orderId, String.valueOf(dfn)};
        List<String> list = this.lCall(params2);
        int n = list.size();
        String urgency = null;
        for (int i = 0; i < n; ++i) {
            String x = list.get(i);
            if (x.length() <= 0) continue;
            char c = x.charAt(0);
            if ((c == 'U' || c == 'u') && x.toUpperCase().startsWith("URGENCY:")) {
                urgency = x.substring(8, x.length()).trim();
                break;
            }
            if (c != 'P' && c != 'p' || !x.toUpperCase().startsWith("PRIORITY:")) continue;
            urgency = x.substring(9, x.length()).trim();
            break;
        }
        return urgency;
    }

    public OrderDetails parseOrderDetails(String orderId, String patientDfn) throws Exception {
        OrderDetails orderDetails = new OrderDetails();
        String text = this.getOrderDetails(orderId, patientDfn);
        String[] lines = StringUtils.pieceList((String)text, (char)'\n');
        Matcher m = null;
        for (int i = 0; i < lines.length; ++i) {
            String str;
            m = labOrderNumPattern.matcher(lines[i]);
            if (m.matches()) {
                orderDetails.setLabOrderNum(m.group(1));
                continue;
            }
            m = orderTextPattern.matcher(lines[i]);
            if (m.matches()) {
                orderDetails.setOrderText(m.group(1));
                continue;
            }
            m = natureOfOrderPattern.matcher(lines[i]);
            if (m.matches()) {
                orderDetails.setNatureOfOrder(m.group(1));
                continue;
            }
            m = enteredByPattern.matcher(lines[i]);
            if (m.matches()) {
                str = m.group(1);
                str = StringUtils.piece((String)str, (char)'(', (int)1).trim();
                orderDetails.setEnteredBy(str);
                continue;
            }
            m = releasedByPattern.matcher(lines[i]);
            if (m.matches()) {
                str = m.group(1);
                str = StringUtils.piece((String)str, (char)'(', (int)1).trim();
                orderDetails.setReleasedBy(str);
                continue;
            }
            m = signedByPattern.matcher(lines[i]);
            if (m.matches()) {
                str = m.group(1);
                str = StringUtils.piece((String)str, (char)'(', (int)1).trim();
                orderDetails.setSignedBy(str);
                continue;
            }
            m = orderedByPattern.matcher(lines[i]);
            if (m.matches()) {
                str = m.group(1);
                str = StringUtils.piece((String)str, (char)'(', (int)1).trim();
                orderDetails.setOrderedBy(str);
                continue;
            }
            m = orderNumPattern.matcher(lines[i]);
            if (m.matches()) {
                orderDetails.setOrderNum(m.group(1));
                continue;
            }
            m = currentDataPattern.matcher(lines[i]);
            if (m.matches()) {
                orderDetails.setCurrentData(m.group(1));
                continue;
            }
            m = treatingSpecialtyPattern.matcher(lines[i]);
            if (m.matches()) {
                orderDetails.setTreatingSpecialty(m.group(1));
                continue;
            }
            m = orderingLocationPattern.matcher(lines[i]);
            if (m.matches()) {
                orderDetails.setOrderingLocation(m.group(1));
                continue;
            }
            m = startDatetimePattern.matcher(lines[i]);
            if (m.matches()) {
                str = m.group(1);
                try {
                    orderDetails.setStartDatetime(DateUtils.toDate((String)str, (String)"MM/dd/yyyy HH:mm"));
                }
                catch (ParseException pe) {}
                continue;
            }
            m = stopDatetimePattern.matcher(lines[i]);
            if (m.matches()) {
                str = m.group(1);
                try {
                    orderDetails.setStopDatetime(DateUtils.toDate((String)str, (String)"MM/dd/yyyy HH:mm"));
                }
                catch (ParseException pe) {}
                continue;
            }
            m = currentStatusPattern.matcher(lines[i]);
            if (m.matches()) {
                orderDetails.setCurrentStatus(m.group(1));
                continue;
            }
            m = orderNumPattern.matcher(lines[i]);
            if (m.matches()) {
                orderDetails.setOrderNum(m.group(1));
                continue;
            }
            m = labTestPattern.matcher(lines[i]);
            if (m.matches()) {
                orderDetails.setLabTest(m.group(1));
                continue;
            }
            m = collectedByPattern.matcher(lines[i]);
            if (m.matches()) {
                orderDetails.setCollectedBy(m.group(1));
                continue;
            }
            m = collectionSamplePattern.matcher(lines[i]);
            if (m.matches()) {
                orderDetails.setCollectionSample(m.group(1));
                continue;
            }
            m = specimenPattern.matcher(lines[i]);
            if (m.matches()) {
                orderDetails.setSpecimen(m.group(1));
                continue;
            }
            m = collectionDatetimePattern.matcher(lines[i]);
            if (m.matches()) {
                str = m.group(1);
                if (str.trim().equals("NOW")) {
                    orderDetails.setCollectionDatetime(new Date());
                    continue;
                }
                try {
                    orderDetails.setCollectionDatetime(DateUtils.toDate((String)str, (String)"MM/dd/yyyy HH:mm"));
                }
                catch (ParseException pe) {}
                continue;
            }
            m = urgencyPattern.matcher(lines[i]);
            if (m.matches()) {
                orderDetails.setUrgency(m.group(1));
                continue;
            }
            m = howOftenPattern.matcher(lines[i]);
            if (!m.matches()) continue;
            orderDetails.setHowOften(m.group(1));
        }
        return orderDetails;
    }

    public OrderDetails parseOrderDetails(String orderId) throws Exception {
        return this.parseOrderDetails(orderId, "0");
    }

    public int getOrderStatus(String orderId) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("OREVNTX1 GETSTS");
        String x = this.sCall(orderId);
        return StringUtils.toInt((String)x, (int)1);
    }

    public String getLabTestOrderData(String orderId) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDLR32 LOAD");
        return this.sCall(orderId);
    }

    public String alertOrder(String orderIen) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ALSLR ORDER ALERT");
        return this.sCall(orderIen);
    }

    public String validateOrderAction(String id, String action, String providerDuz) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDXA VALID");
        Object[] params = new Object[]{id, action, providerDuz};
        return this.sCall(params);
    }

    public String validateComplexOrderAction(String id) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDXA OFCPLX");
        return this.sCall(id);
    }

    public String alertOrderForRecipient(String orderIen, String recipientDuz) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDXA ALERT");
        Object[] params = new Object[]{orderIen, recipientDuz};
        return this.sCall(params);
    }

    public LockDocumentResult lockPatient(String patientDfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDX LOCK");
        LockDocumentResult lockDocumentResult = new LockDocumentResult();
        String x = this.sCall(patientDfn);
        if (x.charAt(0) == '1') {
            lockDocumentResult.setSuccess(true);
            lockDocumentResult.setMessage("");
        } else {
            lockDocumentResult.setSuccess(false);
            lockDocumentResult.setMessage(StringUtils.piece((String)x, (int)2));
        }
        return lockDocumentResult;
    }

    public String unlockPatient(String patientDfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDX UNLOCK");
        return this.sCall(patientDfn);
    }

    public LockDocumentResult lockOrder(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDX LOCK ORDER");
        LockDocumentResult lockDocumentResult = new LockDocumentResult();
        String x = this.sCall(ien);
        if (x.charAt(0) == '1') {
            lockDocumentResult.setSuccess(true);
            lockDocumentResult.setMessage("");
        } else {
            lockDocumentResult.setSuccess(false);
            lockDocumentResult.setMessage(StringUtils.piece((String)x, (int)2));
        }
        return lockDocumentResult;
    }

    public String unlockOrder(String ien) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDX UNLOCK ORDER");
        return this.sCall(ien);
    }

    public OrderDialogResolved buildReponses(String patientDfn, String encLocation, String encProvider, boolean inpatient, String patientSex, int patientAge, int scPercent, String keyVars, String inputId, boolean forImo) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDXM1 BLDQRSP");
        String delayEvent = "0;C;0;0";
        StringBuffer sb = new StringBuffer();
        sb.append(patientDfn + "^");
        sb.append(encLocation + "^");
        sb.append(encProvider + "^");
        sb.append(StringUtils.boolToStr((boolean)inpatient, (String)"1", (String)"0") + "^");
        sb.append(patientSex + "^");
        sb.append(patientAge + "^");
        sb.append(delayEvent + "^");
        sb.append(scPercent + "^");
        sb.append("^");
        sb.append("^");
        sb.append(keyVars);
        Object[] params = new String[]{inputId, sb.toString(), StringUtils.boolToStr((boolean)forImo, (String)"1", (String)"0"), encLocation};
        List<String> list = this.lCall(params);
        String x = list.get(0);
        OrderDialogResolved dialog = new OrderDialogResolved();
        dialog.setQuickLevel(StringUtils.toInt((String)StringUtils.piece((String)x, (int)1), (int)0));
        dialog.setResponseId(StringUtils.piece((String)x, (int)2));
        dialog.setDialogIen(StringUtils.piece((String)x, (int)3));
        dialog.setDialogType(StringUtils.piece((String)x, (int)4).charAt(0));
        dialog.setFormId(StringUtils.toInt((String)StringUtils.piece((String)x, (int)5), (int)0));
        dialog.setDisplayGroup(StringUtils.piece((String)x, (int)6));
        dialog.setQoKeyVars(StringUtils.pieces((String)x, (char)'^', (int)7, (int)17));
        return dialog;
    }

    public List<OrderResponse> loadResponses(String orderId, boolean xferOutToInOnMeds, boolean xferInToOutNow) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDX LOADRSP");
        ArrayList<OrderResponse> responses = new ArrayList<OrderResponse>();
        String transfer = StringUtils.boolToStr(((xferOutToInOnMeds || xferInToOutNow) && orderId.charAt(0) == 'C' ? 1 : 0) != 0, (String)"1", (String)"0");
        Object[] params = new String[]{orderId, transfer};
        List<String> list = this.lCall(params);
        int i = 0;
        while (i < list.size()) {
            if (list.get(i).charAt(0) != '~') continue;
            OrderResponse response = new OrderResponse();
            response.setPromptIen(StringUtils.piece((String)list.get(i).substring(1, list.get(i).length()), (int)1));
            response.setInstance(StringUtils.toInt((String)StringUtils.piece((String)list.get(i), (int)2), (int)0));
            response.setPromptId(StringUtils.piece((String)list.get(i), (int)3));
            ++i;
            while (i < list.size() && list.get(i).charAt(0) != '~') {
                if (list.get(i).charAt(0) == 'i') {
                    response.setiValue(list.get(i).substring(1, list.get(i).length()));
                } else if (list.get(i).charAt(0) == 'e') {
                    response.seteValue(list.get(i).substring(1, list.get(i).length()));
                } else if (list.get(i).charAt(0) == 't') {
                    String eValue = response.geteValue();
                    if (eValue == null) {
                        eValue = "";
                    }
                    if (eValue.length() > 0) {
                        eValue = eValue + "\r\n";
                    }
                    eValue = eValue + list.get(i).substring(1, list.get(i).length());
                    response.seteValue(eValue);
                    response.setiValue(TX_WPTYPE);
                }
                ++i;
            }
            responses.add(response);
        }
        return responses;
    }

    public List<String> buildOcItems(String startDtTm, String fillerId, List<OrderResponse> orderResponses) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDX LOADRSP");
        ArrayList<String> ocItems = new ArrayList<String>();
        for (OrderResponse orderResponse : orderResponses) {
            if (orderResponse.getPromptId().equals("ORDERABLE") || orderResponse.getPromptId().equals("ADDITIVE")) {
                String orderableIen = orderResponse.getiValue();
                String pkgPart = null;
                int instance = orderResponse.getInstance();
                if (fillerId.equals("LR")) {
                    pkgPart = "^LR^" + OrdersDao.iValueFor(orderResponses, "SPECIMEN", instance);
                } else if (fillerId.equals("PSI") || fillerId.equals("PSO") || fillerId.equals("PSH") || fillerId.equals("PSNV")) {
                    pkgPart = "^" + fillerId + "^" + OrdersDao.iValueFor(orderResponses, "DRUG", instance);
                } else if (fillerId.equals("PSIV")) {
                    if (orderResponse.getPromptId().equals("ORDERABLE")) {
                        pkgPart = "PSIV^B;" + OrdersDao.iValueFor(orderResponses, "VOLUME", instance);
                    } else if (orderResponse.getPromptId().equals("ADDITIVE")) {
                        pkgPart = "PSIV^A;";
                    }
                }
                ocItems.add(orderableIen + pkgPart);
            }
            if (!fillerId.equals("PSI") && !fillerId.equals("PSO") && !fillerId.equals("PSH") && !fillerId.equals("PSNV") || orderResponse.getPromptId().equals("COMMENT")) continue;
            ocItems.add(fillerId + "^" + orderResponse.getPromptId() + "^" + orderResponse.getInstance() + "^" + OrdersDao.iValueFor(orderResponses, orderResponse.getPromptId(), orderResponse.getInstance()) + "^" + OrdersDao.eValueFor(orderResponses, orderResponse.getPromptId(), orderResponse.getInstance()));
        }
        return ocItems;
    }

    private static String eValueFor(List<OrderResponse> orderResponses, String promptId, int instance) {
        for (OrderResponse orderResponse : orderResponses) {
            if (!orderResponse.getPromptId().equals(promptId) || orderResponse.getInstance() != instance) continue;
            return orderResponse.geteValue();
        }
        return null;
    }

    private static String iValueFor(List<OrderResponse> orderResponses, String promptId, int instance) {
        for (OrderResponse orderResponse : orderResponses) {
            if (!orderResponse.getPromptId().equals(promptId) || orderResponse.getInstance() != instance) continue;
            return orderResponse.getiValue();
        }
        return null;
    }

    public List<OrderDialogPrompt> loadDialogDefinition(String dialogName) throws Exception {
        ArrayList<OrderDialogPrompt> prompts = new ArrayList<OrderDialogPrompt>();
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDX DLGDEF");
        List<String> list = this.lCall(dialogName);
        for (int i = 0; i < list.size(); ++i) {
            OrderDialogPrompt prompt = new OrderDialogPrompt();
            prompt.setId(StringUtils.piece((String)list.get(i), (int)1));
            prompt.setIen(StringUtils.piece((String)list.get(i), (int)2));
            if (StringUtils.piece((String)list.get(i), (int)3).length() > 0) {
                prompt.setSequence(StringUtils.toDouble((String)StringUtils.piece((String)list.get(i), (int)3), (double)0.0));
            } else {
                prompt.setSequence(0.0);
            }
            prompt.setFmtCode(StringUtils.piece((String)list.get(i), (int)4));
            prompt.setOmit(StringUtils.piece((String)list.get(i), (int)5));
            prompt.setLeading(StringUtils.piece((String)list.get(i), (int)6));
            prompt.setTrailing(StringUtils.piece((String)list.get(i), (int)7));
            prompt.setNewLine(StringUtils.piece((String)list.get(i), (int)8).equals("1"));
            prompt.setWrapWp(StringUtils.piece((String)list.get(i), (int)9).equals("1"));
            prompt.setChildren(StringUtils.piece((String)list.get(i), (int)10));
            prompt.setIsChild(StringUtils.piece((String)list.get(i), (int)11).equals("1"));
            prompts.add(prompt);
        }
        return prompts;
    }

    public List<String> orderChecksOnAccept(String patientDfn, String encLocation, String fillerId, String startDtTm, List<String> oiList, String dupORIFN, String renewal) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDXC ACCEPT");
        if (oiList != null && oiList.size() > 0) {
            Object[] params = new Object[]{patientDfn, fillerId, startDtTm, encLocation, oiList, dupORIFN, renewal};
            return this.lCall(params);
        }
        Object[] params = new String[]{patientDfn, fillerId, startDtTm, encLocation};
        return this.lCall(params);
    }

    public OrderInfo putNewOrder(NewOrder newOrder) throws Exception {
        OrderDialogResolved dialog = this.buildReponses(newOrder.getPatientDfn(), newOrder.getEncLocation(), newOrder.getEncProvider(), newOrder.isInpatient(), newOrder.getPatientSex(), newOrder.getPatientAge(), newOrder.getScPercent(), "", newOrder.getOrderId(), false);
        List<OrderResponse> responseList = this.loadResponses(dialog.getResponseId(), false, false);
        Hashtable<String, String> responseListHT = new Hashtable<String, String>();
        for (OrderResponse orderResponse : responseList) {
            responseListHT.put(orderResponse.getPromptId(), orderResponse.getPromptId());
        }
        List<OrderDialogPrompt> prompts = this.loadDialogDefinition(newOrder.getDialogName());
        for (OrderDialogPrompt prompt : prompts) {
            if (responseListHT.containsKey(prompt.getId())) continue;
            OrderResponse orderResponse = new OrderResponse();
            orderResponse.setPromptId(prompt.getId());
            orderResponse.setPromptIen(prompt.getIen());
            responseList.add(orderResponse);
        }
        for (OrderResponse orderResponse : responseList) {
            if (orderResponse.getPromptId().equals("ORDERABLE") && newOrder.getOrderable() != null) {
                orderResponse.setiValue(newOrder.getOrderable().getiValue());
                orderResponse.seteValue(newOrder.getOrderable().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("INSTR") && newOrder.getInstr() != null) {
                orderResponse.setiValue(newOrder.getInstr().getiValue());
                orderResponse.seteValue(newOrder.getInstr().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("DRUG") && newOrder.getDrug() != null) {
                orderResponse.setiValue(newOrder.getDrug().getiValue());
                orderResponse.seteValue(newOrder.getDrug().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("DOSE") && newOrder.getDose() != null) {
                orderResponse.setiValue(newOrder.getDose().getiValue());
                orderResponse.seteValue(newOrder.getDose().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("STRENGTH") && newOrder.getStrength() != null) {
                orderResponse.setiValue(newOrder.getStrength().getiValue());
                orderResponse.seteValue(newOrder.getStrength().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("ROUTE") && newOrder.getRoute() != null) {
                orderResponse.setiValue(newOrder.getRoute().getiValue());
                orderResponse.seteValue(newOrder.getRoute().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("SCHEDULE") && newOrder.getSchedule() != null) {
                orderResponse.setiValue(newOrder.getSchedule().getiValue());
                orderResponse.seteValue(newOrder.getSchedule().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("URGENCY") && newOrder.getUrgency() != null) {
                orderResponse.setiValue(newOrder.getUrgency().getiValue());
                orderResponse.seteValue(newOrder.getUrgency().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("SUPPLY") && newOrder.getSupply() != null) {
                orderResponse.setiValue(newOrder.getSupply().getiValue());
                orderResponse.seteValue(newOrder.getSupply().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("QTY") && newOrder.getQty() != null) {
                orderResponse.setiValue(newOrder.getQty().getiValue());
                orderResponse.seteValue(newOrder.getQty().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("REFILLS") && newOrder.getRefills() != null) {
                orderResponse.setiValue(newOrder.getRefills().getiValue());
                orderResponse.seteValue(newOrder.getRefills().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("SC") && newOrder.getSc() != null) {
                orderResponse.setiValue(newOrder.getSc().getiValue());
                orderResponse.seteValue(newOrder.getSc().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("PICKUP") && newOrder.getPickup() != null) {
                orderResponse.setiValue(newOrder.getPickup().getiValue());
                orderResponse.seteValue(newOrder.getPickup().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("PI") && newOrder.getPi() != null) {
                orderResponse.setiValue(newOrder.getPi().getiValue());
                orderResponse.seteValue(newOrder.getPi().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("SIG") && newOrder.getSig() != null) {
                orderResponse.setiValue(newOrder.getSig().getiValue());
                orderResponse.seteValue(newOrder.getSig().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("COMMENT") && newOrder.getComment() != null) {
                orderResponse.setiValue(newOrder.getComment().getiValue());
                orderResponse.seteValue(newOrder.getComment().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("START") && newOrder.getStart() != null) {
                orderResponse.setiValue(newOrder.getStart().getiValue());
                orderResponse.seteValue(newOrder.getStart().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("STOP") && newOrder.getStop() != null) {
                orderResponse.setiValue(newOrder.getStop().getiValue());
                orderResponse.seteValue(newOrder.getStop().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("SETTING") && newOrder.getSetting() != null) {
                orderResponse.setiValue(newOrder.getSetting().getiValue());
                orderResponse.seteValue(newOrder.getSetting().geteValue());
                continue;
            }
            if (orderResponse.getPromptId().equals("PLACE") && newOrder.getPlace() != null) {
                orderResponse.setiValue(newOrder.getPlace().getiValue());
                orderResponse.seteValue(newOrder.getPlace().geteValue());
                continue;
            }
            if (!orderResponse.getPromptId().equals("EARLIEST") || newOrder.getEarliest() == null) continue;
            orderResponse.setiValue(newOrder.getEarliest().getiValue());
            orderResponse.seteValue(newOrder.getEarliest().geteValue());
        }
        List<String> oiList = this.buildOcItems(newOrder.getStartDtTm(), newOrder.getFillerId(), responseList);
        List<String> ocList = this.orderChecksOnAccept(newOrder.getPatientDfn(), newOrder.getEncLocation(), newOrder.getFillerId(), newOrder.getStartDtTm(), oiList, "", "0");
        ConstructOrder constructOrder = new ConstructOrder();
        constructOrder.setDialogName(newOrder.getDialogName());
        constructOrder.setOrderItem(newOrder.getOrderId());
        constructOrder.setResponseList(responseList);
        constructOrder.setDgroup(dialog.getDisplayGroup());
        constructOrder.setOcList(ocList);
        return this.putNewOrder(newOrder.getPatientDfn(), newOrder.getEncProvider(), newOrder.getEncLocation(), newOrder.getPatientSpecialty(), newOrder.getEncDatetime(), constructOrder, "", "");
    }

    public OrderInfo putNewOrder(String patientDfn, String encProvider, String encLocation, String patientSpecialty, double encDatetime, ConstructOrder constructOrder, String orderSource, String editOf) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDX SAVE");
        HashMap<String, String> param7 = this.setupORDialog(constructOrder.getResponseList(), constructOrder.getDialogName().equals("PSJI OR PAT FLUID OE"));
        if (constructOrder.getLeadText() != null && constructOrder.getLeadText().length() > 0) {
            param7.put("\"ORLEAD\"", constructOrder.getLeadText());
        }
        if (constructOrder.getTrailText() != null && constructOrder.getTrailText().length() > 0) {
            param7.put("\"ORTRAIL\"", constructOrder.getTrailText());
        }
        if (constructOrder.getOcList() != null) {
            param7.put("\"ORCHECK\"", String.valueOf(constructOrder.getOcList().size()));
        } else {
            param7.put("\"ORCHECK\"", "0");
        }
        List<String> ocList = constructOrder.getOcList();
        if (constructOrder.getOcList() != null) {
            for (int i = 0; i < ocList.size(); ++i) {
                String y = "\"ORCHECK\",\"" + StringUtils.piece((String)ocList.get(i), (int)1) + "\",\"" + StringUtils.piece((String)ocList.get(i), (int)3) + "\",\"" + (i + 1) + "\"";
                String ocStr = StringUtils.pieces((String)ocList.get(i), (char)'^', (int)2, (int)4);
                int len = ocStr.length();
                if (len > 255) {
                    int numLoop = len / 255;
                    int remain = len % 255;
                    int inc = 0;
                    while (inc <= numLoop) {
                        String tmpStr = ocStr.substring(0, 254);
                        ocStr = ocStr.substring(255, ocStr.length());
                        param7.put(RpcRequest.buildMultipleMSubscriptKey((String)(y + "," + inc + ",0")), tmpStr);
                    }
                    if (remain <= 0) continue;
                    param7.put(RpcRequest.buildMultipleMSubscriptKey((String)(y + "," + inc + ",0")), ocStr);
                    continue;
                }
                param7.put(y, ocStr);
            }
        }
        if (Arrays.asList(new char[][]{DELAY_EVENTS}).contains(Character.valueOf(constructOrder.getDelayEvent()))) {
            param7.put("\"OREVENT\"", constructOrder.getPtEventPtr());
        }
        if (constructOrder.getLogTime() > 0.0) {
            param7.put("\"ORSLOG\"", String.valueOf(constructOrder.getLogTime()));
        }
        if (patientSpecialty == null || patientSpecialty.equals("")) {
            patientSpecialty = "0";
        }
        param7.put("\"ORTS\"", patientSpecialty);
        Object[] params = new Object[]{patientDfn, encProvider, encLocation, constructOrder.getDialogName(), constructOrder.getDgroup(), constructOrder.getOrderItem(), editOf, param7, constructOrder.getDigSig(), String.valueOf(encDatetime), orderSource, String.valueOf(constructOrder.getIsEventDefaultOr())};
        List<String> list = this.lCall(params);
        if (list.size() == 0) {
            return null;
        }
        String x = list.get(0);
        String y = "";
        String z = "";
        while (list.size() > 0 && list.get(0).charAt(0) != '~' && list.get(0).charAt(0) != '|') {
            y = y + list.get(0).substring(1, list.get(0).length()) + "\r\n";
            list.remove(0);
        }
        if (y.length() > 0) {
            y = y.substring(0, y.length() - 2);
        }
        if (list.size() > 0 && list.get(0).equals("|")) {
            list.remove(0);
            while (list.size() > 0 && list.get(0).charAt(0) != '~' && list.get(0).charAt(0) != '|') {
                z = z + list.get(0).substring(1, list.get(0).length());
                list.remove(0);
            }
        }
        return this.setOrderFields(x, y, z);
    }

    public List<String> sendOrders(String patientDfn, String providerDuz, String encLocation, String esCode, List<String> orderList) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDX SEND");
        Object[] params = new Object[]{patientDfn, providerDuz, encLocation, " " + esCode, orderList};
        return this.lCall(params);
    }

    private OrderInfo setOrderFields(String x, String y, String z) {
        OrderInfo order = new OrderInfo();
        String t = StringUtils.piece((String)x, (int)1);
        order.setId(t.substring(1, t.length()));
        order.setDGroup(StringUtils.piece((String)x, (int)2));
        order.setFmOrderDatetime(Double.valueOf(StringUtils.piece((String)x, (int)3)));
        order.setStartTimeStr(StringUtils.piece((String)x, (int)4));
        order.setStopTimeStr(StringUtils.piece((String)x, (int)5));
        order.setStatusIen(StringUtils.piece((String)x, (int)6));
        order.setSignature(StringUtils.toInt((String)StringUtils.piece((String)x, (int)7), (int)0));
        order.setVerNurse(StringUtils.piece((String)x, (int)8));
        order.setVerClerk(StringUtils.piece((String)x, (int)9));
        order.setChartRev(StringUtils.piece((String)x, (int)15));
        order.setProviderDuz(StringUtils.piece((String)x, (int)10));
        order.setProviderName(StringUtils.piece((String)x, (int)11));
        order.setProviderDEA(StringUtils.piece((String)x, (int)16));
        order.setProviderVA(StringUtils.piece((String)x, (int)17));
        order.setDigSigReq(StringUtils.piece((String)x, (int)18));
        t = StringUtils.piece((String)x, (int)13);
        order.setFlagged(t != null ? t.equals("1") : false);
        order.setOrderLocIen(StringUtils.piece((String)StringUtils.piece((String)x, (int)19), (char)':', (int)2));
        if (StringUtils.piece((String)StringUtils.piece((String)x, (int)19), (char)':', (int)1).equals("0;SC(")) {
            order.setOrderLocName("Unknown");
        } else {
            order.setOrderLocName(StringUtils.piece((String)StringUtils.piece((String)x, (int)19), (char)':', (int)1));
        }
        order.setText(y);
        order.setXmlText(z);
        try {
            DGroup dgroup = this.getSeqOfDGroup(order.getDGroup());
            order.setDGroupSeq(dgroup.getItem());
            order.setDGroupName(dgroup.getSubitem());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (order.getText().indexOf("Entered in error") >= 0) {
            order.setEnteredInError(1);
        } else {
            order.setEnteredInError(0);
        }
        if (StringUtils.piece((String)x, (int)20).equals("1")) {
            order.setDcOriginalOrder(true);
        } else {
            order.setDcOriginalOrder(false);
        }
        if (StringUtils.piece((String)x, (int)21).equals("1")) {
            order.setIsOrderPendDc(true);
        } else {
            order.setIsOrderPendDc(false);
        }
        if (StringUtils.piece((String)x, (int)22).equals("1")) {
            order.setIsDelayOrder(true);
        } else {
            order.setIsDelayOrder(false);
        }
        return order;
    }

    private HashMap<String, String> setupORDialog(List<OrderResponse> responseList, boolean isIV) {
        int piIdx = 0;
        int odIdx = 0;
        String thePI = "";
        String odTxt = "";
        for (int i = 0; i < responseList.size(); ++i) {
            String ivDurVal;
            String ivDuration;
            if (responseList.get(i).getPromptId().equals("SIG")) {
                odTxt = responseList.get(i).geteValue();
                odIdx = i;
            }
            if (responseList.get(i).getPromptId().equals("PI")) {
                thePI = responseList.get(i).geteValue();
            }
            if (thePI.trim().length() > 0) {
                piIdx = odTxt.indexOf(thePI);
            }
            if (piIdx > 0) {
                StringBuffer sb = new StringBuffer(odTxt);
                odTxt = sb.delete(piIdx, thePI.length()).toString();
                responseList.get(odIdx).seteValue(odTxt);
            }
            if (!isIV || !responseList.get(i).getPromptId().equals("DAYS") || (ivDuration = responseList.get(i).geteValue()).length() <= 1 || ivDuration.toUpperCase().indexOf("TOTAL") > 0 || ivDuration.toUpperCase().indexOf("FOR") > 0) continue;
            if (ivDuration.toUpperCase().indexOf("H") > 0) {
                ivDurVal = ivDuration.substring(0, ivDuration.length() - 1);
                responseList.get(i).setIen("for " + ivDurVal + " hours");
                continue;
            }
            if (ivDuration.toUpperCase().indexOf("D") > 0) {
                if (ivDuration.toUpperCase().indexOf("DOSES") > 0) {
                    ivDurVal = ivDuration.substring(0, ivDuration.length() - 5);
                    responseList.get(i).setiValue("for a total of " + ivDurVal + " doses");
                    continue;
                }
                ivDurVal = ivDuration.substring(0, ivDuration.length() - 1);
                responseList.get(i).setiValue("for " + ivDurVal + " days");
                continue;
            }
            if (ivDuration.toUpperCase().indexOf("ML") > 0 || ivDuration.toUpperCase().indexOf("CC") > 0) {
                ivDurVal = ivDuration.substring(0, ivDuration.length() - 2);
                responseList.get(i).setiValue("with total volume " + ivDurVal + " ml");
                continue;
            }
            if (ivDuration.toUpperCase().indexOf("L") <= 0) continue;
            ivDurVal = ivDuration.substring(0, ivDuration.length() - 1);
            responseList.get(i).setiValue("with total volume " + ivDurVal + " L");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < responseList.size(); ++i) {
            OrderResponse resp = responseList.get(i);
            String multSubs = RpcRequest.buildMultipleMSubscriptKey((String)("\"" + resp.getPromptIen() + "\"," + resp.getInstance()));
            if (resp.getiValue().equals(TX_WPTYPE)) {
                if (resp.geteValue().length() > 74) {
                    resp.seteValue(StringUtils.wrapLine((String)resp.geteValue(), (int)74));
                }
                String subs = resp.getPromptIen() + "," + resp.getInstance();
                map.put(multSubs, "ORDIALOG(\"WP\"," + subs + ")");
                String[] wpStrings = StringUtils.pieceList((String)resp.geteValue(), (char)'\n');
                for (int j = 0; j < wpStrings.length; ++j) {
                    map.put(RpcRequest.buildMultipleMSubscriptKey((String)("\"WP\"," + subs + "," + (j + 1) + ",0")), wpStrings[j].trim());
                }
                continue;
            }
            map.put(multSubs, resp.getiValue());
        }
        return map;
    }

    static {
        try {
            labOrderNumPattern = Pattern.compile("^[\\w\\s]+\\s{1}LB #(\\d{4,12})$");
            enteredByPattern = Pattern.compile("^[\\w\\s/:]+\\s{1}New Order entered by\\s{1}([\\w\\s,\\(\\)'-]+)$");
            orderTextPattern = Pattern.compile("^\\s{5}Order Text:\\s{8}([\\w\\s,\\(\\)'-]+)$");
            natureOfOrderPattern = Pattern.compile("^\\s{5}Nature of Order:\\s{3}([\\w\\s,\\(\\)'-]+)\\s{1}on\\s{1}.*$");
            releasedByPattern = Pattern.compile("^\\s{5}Released by:\\s{7}([\\w\\s,\\(\\)'-]+)\\s{1}on\\s{1}.*$");
            signedByPattern = Pattern.compile("^\\s{5}Elec Signature:\\s{4}([\\w\\s,\\(\\)'-]+)\\s{1}on\\s{1}.*$");
            orderedByPattern = Pattern.compile("^\\s{5}Ordered by:\\s{8}([\\w\\s,\\(\\)'-]+).*$");
            currentDataPattern = Pattern.compile("^Current Data:\\s{17}([\\w\\s\\d,\\(\\)'-\\\\\\.\\<\\>/&]+)$");
            treatingSpecialtyPattern = Pattern.compile("^Treating Specialty:\\s{11}([\\w\\s\\d,\\(\\)'-\\\\\\.\\<\\>/&]+)$");
            orderingLocationPattern = Pattern.compile("^Ordering Location:\\s{12}([\\w\\s\\d,\\(\\)'-\\\\\\.\\<\\>/&]+)$");
            startDatetimePattern = Pattern.compile("^Start Date/Time:\\s{14}(\\d{2}\\/\\d{2}\\/\\d{4}\\s{1}\\d{2}:\\d{2})$");
            stopDatetimePattern = Pattern.compile("^Stop Date/Time:\\s{14}(\\d{2}\\/\\d{2}\\/\\d{4}\\s{1}\\d{2}:\\d{2})$");
            currentStatusPattern = Pattern.compile("^Current Status:\\s{15}([\\w\\s\\d,\\(\\)'-\\\\\\.\\<\\>/]+)$");
            orderNumPattern = Pattern.compile("^Order #(\\d{4,12})$");
            labTestPattern = Pattern.compile("^Lab Test:\\s{21}([\\w\\s\\d,\\(\\)'-\\\\\\.\\<\\>/&]+)$");
            collectedByPattern = Pattern.compile("^Collected By:\\s{17}([\\w\\s\\d,\\(\\)'-\\\\\\.\\<\\>/&]+)$");
            collectionSamplePattern = Pattern.compile("^Collection Sample:\\s{12}([\\w\\s\\d,\\(\\)'-\\\\\\.\\<\\>/&]+)$");
            specimenPattern = Pattern.compile("^Specimen:\\s{21}([\\w\\s\\d,\\(\\)'-\\\\\\.\\<\\>/&]+)$");
            collectionDatetimePattern = Pattern.compile("^Collection Date/Time:\\s{9}([\\w\\s/:]+)$");
            urgencyPattern = Pattern.compile("^Urgency:\\s{22}([\\w\\s]+)$");
            howOftenPattern = Pattern.compile("^How often:\\s{20}([\\w\\s]+)$");
        }
        catch (PatternSyntaxException pse) {
            log.error((Object)ExceptionUtils.describeException((Throwable)pse));
        }
    }
}

