/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.patient.data.EditedTiuNote;
import gov.va.med.lom.vistabroker.patient.data.NewTiuNote;
import gov.va.med.lom.vistabroker.patient.data.TiuNote;
import gov.va.med.lom.vistabroker.util.FMDateUtils;
import gov.va.med.vistalink.rpc.RpcRequest;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;

public class NewTiuNoteDao
extends BaseDao {
    public NewTiuNoteDao() {
    }

    public NewTiuNoteDao(BaseDao baseDao) {
        super(baseDao);
    }

    public TiuNote createTiuNote(NewTiuNote newTiuNote) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU CREATE RECORD");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(".11", StringUtils.boolToStr((boolean)newTiuNote.getCpt(), (String)"1", (String)"0"));
        map.put("1202", newTiuNote.getAuthorDuz());
        if (newTiuNote != null && newTiuNote.getRefDate() != null && newTiuNote.getRefDate().length() > 0) {
            try {
                map.put("1301", String.valueOf(FMDateUtils.ansiDateTimeToFMDateTime(newTiuNote.getRefDate())));
            }
            catch (ParseException pe) {
                try {
                    map.put("1301", String.valueOf(FMDateUtils.ansiDateTimeToFMDateTime(DateUtils.getCurrentDateTime())));
                }
                catch (ParseException pe2) {
                    // empty catch block
                }
            }
        }
        if (newTiuNote.getDictDate() != null) {
            try {
                map.put("1307", String.valueOf(FMDateUtils.ansiDateTimeToFMDateTime(newTiuNote.getDictDate())));
            }
            catch (ParseException pe) {
                try {
                    map.put("1307", String.valueOf(FMDateUtils.ansiDateTimeToFMDateTime(DateUtils.getCurrentDateTime())));
                }
                catch (ParseException pe2) {
                    // empty catch block
                }
            }
        }
        String visitDate = null;
        if (newTiuNote.getVisitDate() != null) {
            try {
                visitDate = String.valueOf(FMDateUtils.ansiDateTimeToFMDateTime(newTiuNote.getVisitDate()));
            }
            catch (ParseException pe) {
                visitDate = "";
            }
        }
        String visitStr = null;
        visitStr = newTiuNote.getVisitStr() != null ? newTiuNote.getVisitStr() : "";
        if (!newTiuNote.getVisitLocationIen().equals("0")) {
            map.put("1205", String.valueOf(newTiuNote.getVisitLocationIen()));
        }
        if (newTiuNote.getCosignerDuz() != null && !newTiuNote.getCosignerDuz().equals("0")) {
            map.put("1208", String.valueOf(newTiuNote.getCosignerDuz()));
        }
        if (newTiuNote.getSubject() != null) {
            map.put("1701", newTiuNote.getSubject());
        }
        if (newTiuNote.getParentNoteIen() != null && !newTiuNote.getParentNoteIen().equals("0")) {
            map.put("2101", String.valueOf(newTiuNote.getParentNoteIen()));
        }
        if (newTiuNote.getPackageRef() != null) {
            map.put("1405", newTiuNote.getPackageRef());
        }
        ArrayList list = StringUtils.getArrayList((String)newTiuNote.getText());
        for (int i = 0; i < list.size(); ++i) {
            map.put(RpcRequest.buildMultipleMSubscriptKey((String)("\"TEXT\"," + String.valueOf(i + 1) + ",0")), (String)list.get(i));
        }
        Object[] params = new Object[]{newTiuNote.getDfn(), newTiuNote.getTitleIen(), visitDate, newTiuNote.getVisitLocationIen(), "", map, visitStr, StringUtils.boolToStr((boolean)newTiuNote.getSuppress(), (String)"1", (String)"0")};
        String x = this.sCall(params);
        String ien = StringUtils.piece((String)x, (int)1);
        TiuNote tiuNote = new TiuNote();
        tiuNote.setIen(ien);
        tiuNote.setDfn(newTiuNote.getDfn());
        tiuNote.setText(newTiuNote.getText());
        if (ien.equals("0")) {
            tiuNote.setMessage(StringUtils.piece((String)x, (int)2));
        }
        return tiuNote;
    }

    public TiuNote updateTiuNote(EditedTiuNote editedTiuNote) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU UPDATE RECORD");
        HashMap<String, String> map = new HashMap<String, String>();
        if (editedTiuNote.getAddend() == 0 && editedTiuNote.getTitleIen() != null && editedTiuNote.getTitleIen().length() > 0 && !editedTiuNote.getTitleIen().equals("0")) {
            map.put(".01", String.valueOf(editedTiuNote.getTitleIen()));
        }
        if (editedTiuNote.getAuthorDuz() != null && editedTiuNote.getAuthorDuz().length() > 0 && !editedTiuNote.getAuthorDuz().equals("0")) {
            map.put("1202", String.valueOf(editedTiuNote.getAuthorDuz()));
        }
        if (editedTiuNote.getCosignerDuz() != null && editedTiuNote.getCosignerDuz().length() > 0 && !editedTiuNote.getCosignerDuz().equals("0")) {
            map.put("1208", String.valueOf(editedTiuNote.getCosignerDuz()));
        }
        if (editedTiuNote.getPackageRef() != null && editedTiuNote.getPackageRef().length() > 0) {
            map.put("1405", editedTiuNote.getPackageRef());
        }
        if (editedTiuNote.getFmDateTime() > 0.0) {
            map.put("1301", String.valueOf(editedTiuNote.getFmDateTime()));
        }
        if (editedTiuNote.getSubject() != null && editedTiuNote.getSubject().length() > 0) {
            map.put("1701", editedTiuNote.getSubject());
        }
        if (editedTiuNote.getClinicalProcedureSummaryCode() > 0) {
            map.put("70201", String.valueOf(editedTiuNote.getClinicalProcedureSummaryCode()));
        }
        if (editedTiuNote.getClinicalProcedureFMDateTime() > 0.0) {
            map.put("70202", String.valueOf(editedTiuNote.getClinicalProcedureFMDateTime()));
        }
        ArrayList list = StringUtils.getArrayList((String)editedTiuNote.getText());
        for (int i = 0; i < list.size(); ++i) {
            map.put(RpcRequest.buildMultipleMSubscriptKey((String)("\"TEXT\"," + String.valueOf(i + 1) + ",0")), (String)list.get(i));
        }
        Object[] params = new Object[]{editedTiuNote.getIen(), map};
        String x = this.sCall(params);
        String ien = StringUtils.piece((String)x, (int)1);
        TiuNote tiuNote = new TiuNote();
        tiuNote.setIen(ien);
        tiuNote.setDfn(editedTiuNote.getDfn());
        tiuNote.setText(editedTiuNote.getText());
        if (ien.equals("0")) {
            tiuNote.setMessage(StringUtils.piece((String)x, (int)2));
        }
        return tiuNote;
    }

    public TiuNote createAddendum(NewTiuNote newTiuNote, String addendumTo) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("TIU CREATE ADDENDUM RECORD");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1202", String.valueOf(newTiuNote.getAuthorDuz()));
        if (newTiuNote.getRefDate().length() > 0) {
            try {
                map.put("1301", String.valueOf(FMDateUtils.ansiDateTimeToFMDateTime(newTiuNote.getRefDate())));
            }
            catch (ParseException pe) {
                // empty catch block
            }
        }
        if (newTiuNote.getCosignerDuz() != null) {
            map.put("1208", String.valueOf(newTiuNote.getCosignerDuz()));
        }
        ArrayList list = StringUtils.getArrayList((String)newTiuNote.getText());
        for (int i = 0; i < list.size(); ++i) {
            map.put(RpcRequest.buildMultipleMSubscriptKey((String)("\"TEXT\"," + String.valueOf(i + 1) + ",0")), (String)list.get(i));
        }
        Object[] params = new Object[]{String.valueOf(addendumTo), map};
        String x = this.sCall(params);
        String ien = StringUtils.piece((String)x, (int)1);
        TiuNote tiuNote = new TiuNote();
        tiuNote.setIen(ien);
        tiuNote.setDfn(newTiuNote.getDfn());
        tiuNote.setText(newTiuNote.getText());
        if (ien.equals("0")) {
            tiuNote.setMessage(StringUtils.piece((String)x, (int)2));
        }
        return tiuNote;
    }
}

