/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.misc.dao.MiscRpcsDao;
import gov.va.med.lom.vistabroker.patient.data.CumulativeLabResults;
import gov.va.med.lom.vistabroker.patient.data.LabResultTestType;
import gov.va.med.lom.vistabroker.patient.data.LabTestResult;
import gov.va.med.lom.vistabroker.util.FMDateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabsDao
extends BaseDao {
    public LabsDao() {
    }

    public LabsDao(BaseDao baseDao) {
        super(baseDao);
    }

    public List<LabTestResult> getRecentLabs(String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWCV LAB");
        List<String> list = this.lCall(dfn);
        ArrayList<LabTestResult> labTestResults = new ArrayList<LabTestResult>();
        for (String s : list) {
            if (s.trim().length() <= 0 || StringUtils.piece((String)s, (int)1).length() <= 0) continue;
            String labIen = StringUtils.piece((String)StringUtils.piece((String)s, (int)1), (char)';', (int)1);
            Object[] params = new Object[]{String.valueOf(dfn), String.valueOf(labIen)};
            this.setDefaultRpcName("ORQQLR DETAIL");
            String y = this.sCall(params);
            LabTestResult recentLab = new LabTestResult();
            recentLab.setDfn(dfn);
            recentLab.setIen(labIen);
            recentLab.setName(StringUtils.mixedCase((String)StringUtils.piece((String)s, (int)2)));
            recentLab.setDate(FMDateUtils.fmDateTimeToDate(StringUtils.piece((String)s, (int)3)));
            try {
                recentLab.setDateStr(DateUtils.toEnglishDate((Date)recentLab.getDate()));
            }
            catch (ParseException pe) {
                // empty catch block
            }
            recentLab.setStatus(StringUtils.mixedCase((String)StringUtils.piece((String)s, (int)4)));
            recentLab.setResult(StringUtils.mixedCase((String)y));
            labTestResults.add(recentLab);
        }
        return labTestResults;
    }

    public List<String> getLabTestData(String labTestIen) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWDLR32 LOAD");
        return this.lCall(labTestIen);
    }

    public CumulativeLabResults getCumulativeLabResults(String patientDfn, int daysBack, Date date1, Date date2) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWLR CUMULATIVE REPORT");
        double fmDate1 = 0.0;
        double fmDate2 = 0.0;
        if (date1 == null) {
            MiscRpcsDao miscRpcsDao = new MiscRpcsDao(this);
            fmDate1 = miscRpcsDao.fmNow();
        } else {
            fmDate1 = FMDateUtils.dateToFMDate(date1);
        }
        fmDate2 = date2 == null ? FMDateUtils.dateToFMDate(DateUtils.subtractDaysFromDate((Date)new Date(), (int)daysBack)) : FMDateUtils.dateToFMDate(date2);
        Object[] params = new Object[]{patientDfn, daysBack, fmDate1 += 0.2359, fmDate2};
        List<String> list = this.lCall(params);
        CumulativeLabResults cumulativeLabResults = new CumulativeLabResults();
        ArrayList<String> repList = new ArrayList<String>();
        for (String s : list) {
            if (!s.startsWith("[HIDDEN TEXT]") && !s.startsWith("[REPORT TEXT]")) {
                repList.add(s);
                continue;
            }
            if (!s.startsWith("[REPORT TEXT]")) continue;
            break;
        }
        ArrayList<LabResultTestType> labResultTestTypes = new ArrayList<LabResultTestType>();
        for (String s : repList) {
            LabResultTestType labResultTestType = new LabResultTestType();
            labResultTestType.setStart(StringUtils.toInt((String)StringUtils.piece((String)s, (int)1), (int)0));
            labResultTestType.setName(StringUtils.piece((String)s, (int)2));
            labResultTestTypes.add(labResultTestType);
        }
        cumulativeLabResults.setLabResultTestTypes(labResultTestTypes);
        StringBuffer results = new StringBuffer();
        for (String s : list) {
            results.append(s + "\n");
        }
        cumulativeLabResults.setText(results.toString().trim());
        return cumulativeLabResults;
    }

    public String getTestsByDate(String patientDfn, int daysBack, Date date1, Date date2) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWLRR INTERIM");
        double fmDate1 = 0.0;
        double fmDate2 = 0.0;
        if (date1 == null) {
            MiscRpcsDao miscRpcsDao = new MiscRpcsDao(this);
            fmDate1 = miscRpcsDao.fmNow();
        } else {
            fmDate1 = FMDateUtils.dateToFMDate(date1);
        }
        fmDate2 = date2 == null ? FMDateUtils.dateToFMDate(DateUtils.subtractDaysFromDate((Date)new Date(), (int)daysBack)) : FMDateUtils.dateToFMDate(date2);
        Object[] params = new Object[]{patientDfn, fmDate1 += 0.2359, fmDate2};
        StringBuffer sb = new StringBuffer();
        List<String> list = this.lCall(params);
        for (String s : list) {
            sb.append((Object)s);
            sb.append("\n");
        }
        return sb.toString();
    }
}

