/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.QSCallBack;
import gov.va.med.lom.javaUtils.misc.QuickSort;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.patient.data.Appointment;
import gov.va.med.lom.vistabroker.patient.data.CancelledAppointment;
import gov.va.med.lom.vistabroker.util.FMDateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppointmentsDao
extends BaseDao {
    public AppointmentsDao() {
    }

    public AppointmentsDao(BaseDao baseDao) {
        super(baseDao);
    }

    public List<Appointment> getAppointments(String dfn, Date fromDate, Date throughDate) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQVS VISITS/APPTS");
        if (fromDate == null) {
            fromDate = DateUtils.subtractDaysFromDate((Date)new Date(), (int)30);
        }
        if (throughDate == null) {
            throughDate = DateUtils.addDaysToDate((Date)new Date(), (int)180);
        }
        double fmDate1 = FMDateUtils.dateToFMDate(fromDate);
        double fmDate2 = FMDateUtils.dateToFMDate(throughDate);
        Object[] params = new Object[]{dfn, String.valueOf(fmDate1), String.valueOf(fmDate2)};
        List<String> list = this.lCall(params);
        ArrayList<Appointment> appointments = new ArrayList<Appointment>();
        for (int i = list.size() - 1; i >= 0; --i) {
            String x = list.get(i);
            if (x.trim().length() <= 0 || StringUtils.piece((String)x, (int)1).length() <= 0) continue;
            Appointment appointment = new Appointment();
            appointment.setDfn(dfn);
            appointment.setId(StringUtils.piece((String)StringUtils.piece((String)x, (int)1), (int)1));
            appointment.setLocation(StringUtils.piece((String)x, (int)2));
            appointment.setHeader(StringUtils.piece((String)x, (int)3));
            appointment.setFmDatetime(StringUtils.toDouble((String)StringUtils.piece((String)x, (int)4), (double)0.0));
            Date dt = FMDateUtils.fmDateTimeToDate(appointment.getFmDatetime());
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(dt);
            appointment.setDatetime(gc);
            try {
                appointment.setDatetimeStr(DateUtils.toEnglishDateTime((Date)dt));
            }
            catch (ParseException pe) {
                // empty catch block
            }
            appointment.setInverseDate(StringUtils.toDouble((String)StringUtils.piece((String)x, (int)5), (double)0.0));
            appointments.add(appointment);
        }
        QuickSort quickSort = new QuickSort();
        QuickSortCallBack qsCallBack = new QuickSortCallBack();
        quickSort.setQSCallBack((QSCallBack)qsCallBack);
        quickSort.quickSort(appointments);
        return appointments;
    }

    public String getVisitDetail(String dfn, String id) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWCV DTLVST");
        Object[] params = new Object[]{dfn, id};
        List<String> list = this.lCall(params);
        StringBuffer sb = new StringBuffer();
        for (String s : list) {
            sb.append(s + "\n");
        }
        return sb.toString().trim();
    }

    public CancelledAppointment cancelAppointment(String dfn, double apptDatetime, String clinic) throws Exception {
        this.setDefaultContext("ALT INTRANET RPCS");
        CancelledAppointment cancelledAppointment = null;
        cancelledAppointment = new CancelledAppointment();
        cancelledAppointment.setDfn(dfn);
        cancelledAppointment.setFmDatetime(apptDatetime);
        cancelledAppointment.setLocation(clinic);
        Object[] params = null;
        if (clinic != null && clinic.trim().length() > 0) {
            params = new String[3];
            params[2] = clinic;
        } else {
            params = new String[]{String.valueOf(dfn), String.valueOf(apptDatetime)};
        }
        this.setDefaultRpcName("ALSI APPOINTMENT COMMENTS");
        String x = this.sCall(params);
        String commentCode = StringUtils.piece((String)x, (int)1);
        try {
            cancelledAppointment.setCommentCode(Integer.valueOf(commentCode));
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String comment = StringUtils.piece((String)x, (int)2);
        cancelledAppointment.setComment(comment);
        this.setDefaultRpcName("ALSI APPOINTMENT CANCELLATION");
        x = this.sCall(params);
        if (x.equals("0")) {
            cancelledAppointment.setCancelled(true);
            cancelledAppointment.setErrorCode(0);
            cancelledAppointment.setErrorMessage("");
        } else {
            cancelledAppointment.setCancelled(false);
            String code = StringUtils.piece((String)x, (int)1);
            try {
                cancelledAppointment.setErrorCode(Integer.valueOf(code));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            cancelledAppointment.setErrorMessage(StringUtils.piece((String)x, (int)2));
        }
        return cancelledAppointment;
    }

    class QuickSortCallBack
    implements QSCallBack {
        QuickSortCallBack() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 != null && obj2 != null) {
                double fmDate2;
                double fmDate1 = ((Appointment)obj1).getFmDatetime();
                double c = fmDate1 - (fmDate2 = ((Appointment)obj2).getFmDatetime());
                if (c < 0.0) {
                    return -1;
                }
                if (c > 0.0) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }
    }
}

