/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.patient.dao;

import gov.va.med.lom.javaUtils.misc.DateUtils;
import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.patient.data.Admission;
import gov.va.med.lom.vistabroker.util.FMDateUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdmissionsDao
extends BaseDao {
    public AdmissionsDao() {
    }

    public AdmissionsDao(BaseDao baseDao) {
        super(baseDao);
    }

    public List<Admission> getAdmissions(String dfn) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPT ADMITLST");
        List<String> list = this.lCall(dfn);
        ArrayList<Admission> admissions = new ArrayList<Admission>();
        for (int i = 0; i < list.size(); ++i) {
            String x = list.get(i);
            if (x.trim().length() <= 0 || StringUtils.piece((String)x, (int)1).length() <= 0) continue;
            double admit = StringUtils.toDouble((String)StringUtils.piece((String)x, (int)1), (double)0.0);
            Object[] params = new String[]{String.valueOf(dfn), String.valueOf(admit)};
            this.setDefaultRpcName("ORWPT DISCHARGE");
            String y = this.sCall(params);
            Admission admission = new Admission();
            admission.setRpcResult(y);
            admission.setDfn(dfn);
            admission.setAdmitDate(FMDateUtils.fmDateTimeToDate(StringUtils.piece((String)x, (int)1)));
            try {
                admission.setAdmitDateStr(DateUtils.toEnglishDate((Date)admission.getAdmitDate()));
            }
            catch (ParseException pe) {
                // empty catch block
            }
            admission.setDischargeDate(FMDateUtils.fmDateTimeToDate(StringUtils.piece((String)y, (int)1)));
            try {
                admission.setDischargeDateStr(DateUtils.toEnglishDate((Date)admission.getDischargeDate()));
            }
            catch (ParseException pe) {
                // empty catch block
            }
            admission.setLocationIen(StringUtils.piece((String)x, (int)2));
            admission.setLocation(StringUtils.piece((String)x, (int)3));
            admission.setType(StringUtils.piece((String)x, (int)4));
            admissions.add(admission);
        }
        return admissions;
    }
}

