/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.lists.dao;

import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.lists.data.ListItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecialtiesTeamsDao
extends BaseDao {
    public SpecialtiesTeamsDao() {
    }

    public SpecialtiesTeamsDao(BaseDao baseDao) {
        super(baseDao);
    }

    public synchronized List<ListItem> listAllSpecialties() throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQPT SPECIALTIES");
        List<String> list = this.lCall();
        return this.getItems(list, false);
    }

    public synchronized List<ListItem> listAllTeams() throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQPT TEAMS");
        List<String> list = this.lCall();
        return this.getItems(list, false);
    }

    public Map<String, String> listAllTeamsMap() throws Exception {
        List<ListItem> list = this.listAllTeams();
        return this.getMap(list);
    }

    public Map<String, String> listAllSpecialtiesMap() throws Exception {
        List<ListItem> list = this.listAllSpecialties();
        return this.getMap(list);
    }

    private Map<String, String> getMap(List<ListItem> list) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (ListItem t : list) {
            m.put(t.getIen(), t.getName());
        }
        return m;
    }

    private List<ListItem> getItems(List<String> list, boolean mixedCase) {
        ArrayList<ListItem> specialtyTeamList = new ArrayList<ListItem>();
        for (String x : list) {
            ListItem listItem = new ListItem();
            String ien = StringUtils.piece((String)x, (int)1);
            String name = mixedCase ? StringUtils.mixedCase((String)StringUtils.piece((String)x, (int)2)) : StringUtils.piece((String)x, (int)2);
            listItem.setIen(ien);
            listItem.setName(name);
            listItem.setValue(StringUtils.piece((String)x, (int)3));
            listItem.setRpcResult(x);
            specialtyTeamList.add(listItem);
        }
        return specialtyTeamList;
    }
}

