/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.lists.dao;

import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.lists.data.ListItem;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServicesDao
extends BaseDao {
    public ServicesDao() {
    }

    public ServicesDao(BaseDao baseDao) {
        super(baseDao);
    }

    public synchronized List<ListItem> getServiceList(int purpose) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQCN SVCTREE");
        List<String> list = this.lCall(purpose);
        return this.getItems(list);
    }

    public synchronized List<ListItem> getServiceListWithSynonyms(int purpose) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQCN SVC W/SYNONYMS");
        Object[] params = new Object[]{"1", String.valueOf(purpose), "true"};
        List<String> list = this.lCall(params);
        return this.getItems(list);
    }

    public synchronized List<ListItem> getServiceListWithSynonymsForConsult(int purpose, String consultIen) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQCN SVC W/SYNONYMS");
        Object[] params = new Object[]{"1", purpose, "true", consultIen};
        List<String> list = this.lCall(params);
        return this.getItems(list);
    }

    public synchronized List<ListItem> getSubSetOfServices(String startFrom, int direction) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQQCN SVCLIST");
        Object[] params = new Object[]{startFrom, direction};
        List<String> list = this.lCall(params);
        return this.getItems(list);
    }

    private List<ListItem> getItems(List<String> list) {
        ArrayList<ListItem> listItems = new ArrayList<ListItem>();
        for (String s : list) {
            ListItem listItem = new ListItem();
            listItem.setIen(StringUtils.piece((String)s, (int)1));
            listItem.setName(StringUtils.piece((String)s, (int)2));
            listItem.setValue(StringUtils.piece((String)s, (int)3));
            listItem.setRpcResult(s);
            listItems.add(listItem);
        }
        return listItems;
    }
}

