/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.lists.dao;

import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.lists.data.ListItem;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationsDao
extends BaseDao {
    public LocationsDao() {
    }

    public LocationsDao(BaseDao baseDao) {
        super(baseDao);
    }

    public synchronized List<ListItem> listAllWards() throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQPT WARDS");
        List<String> list = this.lCall();
        return this.getItems(list);
    }

    public synchronized List<ListItem> getSubSetOfLocations(String startFrom, int direction) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWU HOSPLOC");
        Object[] params = new String[]{startFrom, String.valueOf(direction)};
        List<String> list = this.lCall(params);
        return this.getItems(list);
    }

    public synchronized List<ListItem> getSubSetOfInpatientLocations(String startFrom, int direction) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWU INPLOC");
        Object[] params = new String[]{startFrom, String.valueOf(direction)};
        List<String> list = this.lCall(params);
        return this.getItems(list);
    }

    public synchronized List<ListItem> getSubSetOfNewLocations(String startFrom, int direction) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWU1 NEWLOC");
        Object[] params = new String[]{startFrom, String.valueOf(direction)};
        List<String> list = this.lCall(params);
        return this.getItems(list);
    }

    public synchronized List<ListItem> listAllClinics() throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORQPT CLINICS");
        List<String> list = this.lCall();
        return this.getItems(list);
    }

    public synchronized List<ListItem> getSubSetOfClinics(String startFrom, int direction) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWU CLINLOC");
        Object[] params = new String[]{startFrom, String.valueOf(direction)};
        List<String> list = this.lCall(params);
        return this.getItems(list);
    }

    private List<ListItem> getItems(List<String> list) {
        ArrayList<ListItem> listItems = new ArrayList<ListItem>();
        for (String s : list) {
            ListItem listItem = new ListItem();
            listItem.setIen(StringUtils.piece((String)s, (int)1));
            listItem.setName(StringUtils.piece((String)s, (int)2));
            listItem.setValue(StringUtils.piece((String)s, (int)3));
            listItem.setRpcResult(s);
            listItems.add(listItem);
        }
        return listItems;
    }
}

