/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.lists.dao;

import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.lists.data.ListItem;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabTestTypesDao
extends BaseDao {
    public LabTestTypesDao() {
    }

    public LabTestTypesDao(BaseDao baseDao) {
        super(baseDao);
    }

    public synchronized List<ListItem> getAtomicTests(String startFrom, int direction) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWLRR ATOMICS");
        Object[] params = new Object[]{startFrom, String.valueOf(direction)};
        List<String> list = this.lCall(params);
        return this.getList(list);
    }

    public synchronized List<ListItem> getSpecimens(String startFrom, int direction) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWLRR SPEC");
        Object[] params = new Object[]{startFrom, String.valueOf(direction)};
        List<String> list = this.lCall(params);
        return this.getList(list);
    }

    public synchronized List<ListItem> getAllTests(String startFrom, int direction) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWLRR ALLTESTS");
        Object[] params = new Object[]{startFrom, String.valueOf(direction)};
        List<String> list = this.lCall(params);
        return this.getList(list);
    }

    public synchronized List<ListItem> getChemTests(String startFrom, int direction) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWLRR CHEMTEST");
        Object[] params = new Object[]{startFrom, String.valueOf(direction)};
        List<String> list = this.lCall(params);
        return this.getList(list);
    }

    public synchronized List<ListItem> getLabUsers(String startFrom, int direction) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWLRR USERS");
        Object[] params = new Object[]{startFrom, String.valueOf(direction)};
        List<String> list = this.lCall(params);
        return this.getList(list);
    }

    public synchronized List<ListItem> getTestGroupsForLabUser(String userDuz) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWLRR TG");
        List<String> list = this.lCall(userDuz);
        return this.getList(list);
    }

    public synchronized List<ListItem> getATest(String testIen) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWLRR ATESTS");
        List<String> list = this.lCall(testIen);
        return this.getList(list);
    }

    public synchronized List<ListItem> getATestGroup(String testGroupIen, String userDuz) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWLRR ATG");
        Object[] params = new Object[]{testGroupIen, userDuz};
        List<String> list = this.lCall(params);
        return this.getList(list);
    }

    public synchronized String getTestInfo(String testIen) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWLRR INFO");
        return this.sCall(testIen);
    }

    public synchronized List<ListItem> getLabReportLists() throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWRP LAB REPORT LISTS");
        List<String> list = this.lCall();
        String[] results = StringUtils.extractSection(list, (String)"[LAB REPORT LIST]", (boolean)true);
        ArrayList<ListItem> labReports = new ArrayList<ListItem>();
        for (int i = 0; i < results.length; ++i) {
            ListItem listItem = new ListItem();
            listItem.setIen(StringUtils.piece((String)results[i], (int)1));
            listItem.setName(StringUtils.piece((String)results[i], (int)2));
            listItem.setValue(StringUtils.piece((String)results[i], (int)6));
            listItem.setRpcResult(results[i]);
            labReports.add(listItem);
        }
        return labReports;
    }

    private synchronized List<ListItem> getList(List<String> list) {
        ArrayList<ListItem> listItems = new ArrayList<ListItem>();
        for (int i = 0; i < list.size(); ++i) {
            String x = list.get(i);
            ListItem listItem = new ListItem();
            listItem.setIen(StringUtils.piece((String)x, (int)1));
            listItem.setName(StringUtils.piece((String)x, (int)2));
            listItem.setValue(StringUtils.piece((String)x, (int)3));
            listItem.setRpcResult(x);
            listItems.add(listItem);
        }
        return listItems;
    }
}

