/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.lists.dao;

import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.lists.data.CptCode;
import gov.va.med.lom.vistabroker.lists.data.Icd9Code;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodesDao
extends BaseDao {
    public CodesDao() {
    }

    public CodesDao(BaseDao baseDao) {
        super(baseDao);
    }

    public synchronized List<Icd9Code> listICD9Codes(String dsix, String scr) throws Exception {
        this.setDefaultContext("ALS CLINICAL RPC");
        this.setDefaultRpcName("DSIC ICD9 GET LIST");
        Object[] params = new Object[]{dsix, scr};
        List<String> list = this.lCall(params);
        ArrayList<Icd9Code> icd9Codes = new ArrayList<Icd9Code>();
        for (String s : list) {
            Icd9Code icd9Code = new Icd9Code();
            icd9Code.setRpcResult(s);
            icd9Code.setIen(StringUtils.piece((String)s, (int)1));
            icd9Code.setCode(StringUtils.piece((String)s, (int)2));
            icd9Code.setDiagnosis(StringUtils.piece((String)s, (int)3));
            icd9Codes.add(icd9Code);
        }
        return icd9Codes;
    }

    public synchronized List<CptCode> listCPTCodes(String val) throws Exception {
        this.setDefaultContext("ALS CLINICAL RPC");
        this.setDefaultRpcName("EC GETCPTLST");
        List<String> list = this.lCall(val);
        ArrayList<CptCode> cptCodes = new ArrayList<CptCode>();
        for (String s : list) {
            CptCode cptCode = new CptCode();
            cptCode.setRpcResult(s);
            cptCode.setIen(StringUtils.piece((String)s, (int)1));
            cptCode.setCode(StringUtils.piece((String)s, (int)2));
            cptCode.setDescription(StringUtils.piece((String)s, (int)3));
            cptCodes.add(cptCode);
        }
        return cptCodes;
    }

    public synchronized List<Icd9Code> listIcd9Lexicon(String lex, double dt) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPCE LEX");
        Object[] params = new Object[]{lex, "ICD", String.valueOf(dt)};
        List<String> list = this.lCall(params);
        ArrayList<Icd9Code> icd9CodesList = new ArrayList<Icd9Code>();
        for (String s : list) {
            Icd9Code icd9Code = new Icd9Code();
            icd9Code.setRpcResult(s);
            icd9Code.setIen(StringUtils.piece((String)s, (int)1));
            String x = StringUtils.piece((String)s, (int)2);
            icd9Code.setDiagnosis(StringUtils.piece((String)x, (char)'(', (int)1).trim());
            icd9Code.setCode(CodesDao.parseCode(x));
            icd9CodesList.add(icd9Code);
        }
        return icd9CodesList;
    }

    public synchronized String lexiconToIcd9Code(String ien, double dt) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPCE LEXCODE");
        Object[] params = new Object[]{ien, "ICD", String.valueOf(dt)};
        return this.sCall(params);
    }

    public synchronized List<CptCode> listCptLexicon(String lex, double dt) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPCE LEX");
        Object[] params = new Object[]{lex, "CPT", String.valueOf(dt)};
        List<String> list = this.lCall(params);
        ArrayList<CptCode> cptCodes = new ArrayList<CptCode>();
        for (String s : list) {
            CptCode cptCode = new CptCode();
            cptCode.setRpcResult(s);
            cptCode.setIen(StringUtils.piece((String)s, (int)1));
            String x = StringUtils.piece((String)s, (int)2);
            cptCode.setDescription(StringUtils.piece((String)x, (char)'(', (int)1).trim());
            cptCode.setCode(CodesDao.parseCode(x));
            cptCodes.add(cptCode);
        }
        return cptCodes;
    }

    public synchronized String lexiconToCptCode(String ien, double dt) throws Exception {
        this.setDefaultContext("OR CPRS GUI CHART");
        this.setDefaultRpcName("ORWPCE LEXCODE");
        Object[] params = new Object[]{ien, "CPT", String.valueOf(dt)};
        return this.sCall(params);
    }

    private static String parseCode(String x) {
        StringBuffer code = new StringBuffer();
        int i = x.lastIndexOf(41) - 1;
        while (x.charAt(i) != ' ') {
            code.insert(0, x.charAt(i));
            --i;
        }
        return code.toString();
    }
}

