/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.ddr;

import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.ddr.DdrParams;
import gov.va.med.lom.vistabroker.security.ISecurityContext;
import java.util.HashMap;
import java.util.List;

public class DdrValidator
extends BaseDao {
    public static final String DDR_VALIDATOR = "DDR VALIDATOR";
    public static final String SC_VALIDATOR = "SC VALIDATOR";
    private String file;
    private String iens;
    private String field;
    private String value;
    private boolean useScLister;

    public DdrValidator(ISecurityContext securityContext) {
        this.setSecurityContext(securityContext);
    }

    public DdrValidator(BaseDao baseDao) {
        super(baseDao);
    }

    public String execute(DdrParams ddrParams) throws Exception {
        this.file = ddrParams.getFile();
        this.iens = ddrParams.getIens();
        this.field = ddrParams.getField();
        this.value = ddrParams.getValue();
        this.useScLister = ddrParams.isUseScLister();
        return this.execute();
    }

    public String execute() throws Exception {
        if (this.file == null || this.file.equals("")) {
            throw new Exception("Must have a file");
        }
        if (this.iens == null || this.iens.equals("")) {
            throw new Exception("Must have IENS");
        }
        if (this.field == null || this.field.equals("")) {
            throw new Exception("Must have a field");
        }
        if (this.value == null || this.value.equals("")) {
            throw new Exception("Must have a value");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("FILE", this.file);
        map.put("IENS", this.iens);
        map.put("FIELD", this.field);
        map.put("VALUE", this.value);
        Object[] params = new Object[]{map};
        if (this.getDefaultContext() == null || !this.getDefaultContext().equals("DVBA CAPRI GUI")) {
            if (this.useScLister) {
                this.setDefaultContext("SCMC PCMM GUI WORKSTATION");
            } else {
                this.setDefaultContext("DVBA CAPRI GUI");
            }
        }
        String rpc = this.isUseScLister() ? SC_VALIDATOR : DDR_VALIDATOR;
        this.setDefaultRpcName(rpc);
        String response = this.sCall(params);
        List list = StringUtils.getStringList((String)response);
        for (String str : list) {
            if (!str.startsWith("[ERRORS]")) continue;
            String theValue = null;
            for (String s : list) {
                if (!s.startsWith("The value")) continue;
                theValue = s;
                break;
            }
            if (theValue == null) {
                throw new Exception("Unexpected return value from VistA: " + response);
            }
            return theValue;
        }
        return "OK";
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getIens() {
        return this.iens;
    }

    public void setIens(String iens) {
        this.iens = iens;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isUseScLister() {
        return this.useScLister;
    }

    public void setUseScLister(boolean useScLister) {
        this.useScLister = useScLister;
    }
}

