/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.ddr;

import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.ddr.DdrField;
import gov.va.med.lom.vistabroker.ddr.DdrParams;
import gov.va.med.lom.vistabroker.ddr.DdrQuery;
import gov.va.med.lom.vistabroker.security.ISecurityContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DdrLister
extends DdrQuery {
    public static final String DDR_LISTER = "DDR LISTER";
    public static final String SC_LISTER = "SC LISTER";
    private String file;
    private String iens;
    private List<String> requestedFields;
    private Hashtable<String, String> requestedFieldsTable;
    private List<String> ienList;
    private String flags;
    private Integer max;
    private String from;
    private String part;
    private String xref;
    private String screen;
    private String id;
    private String options;
    private String moreFrom;
    private String moreIens;

    public DdrLister(ISecurityContext securityContext) {
        super(securityContext);
    }

    public DdrLister(BaseDao baseDao) {
        super(baseDao);
    }

    public List<String> execute(DdrParams ddrParams) throws Exception {
        this.setFile(ddrParams.getFile());
        this.setIens(ddrParams.getIens());
        this.setFields(ddrParams.getFields());
        this.setFlags(ddrParams.getFlags());
        this.setMax(ddrParams.getMax());
        this.setFrom(ddrParams.getFrom());
        this.setPart(ddrParams.getPart());
        this.setXref(ddrParams.getXref());
        this.setScreen(ddrParams.getScreen());
        this.setId(ddrParams.getId());
        this.setOptions(ddrParams.getOptions());
        this.setMoreFrom(ddrParams.getMoreFrom());
        this.setMoreIens(ddrParams.getMoreIens());
        super.setUseScLister(ddrParams.isUseScLister());
        return this.execute();
    }

    public List<String> execute() throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.file != null && !this.file.equals("")) {
            map.put("FILE", this.file);
        }
        if (this.iens != null && !this.iens.equals("")) {
            map.put("IENS", this.iens);
        }
        if (this.requestedFields != null && this.requestedFields.size() > 0) {
            map.put("FIELDS", this.getFieldsArg());
        }
        if (this.flags != null && !this.flags.equals("")) {
            map.put("FLAGS", this.flags);
        }
        if (this.max != null && this.max > 0) {
            map.put("MAX", String.valueOf(this.max));
        }
        if (this.from != null && !this.from.equals("")) {
            map.put("FROM", this.from);
        }
        if (this.part != null && !this.part.equals("")) {
            map.put("PART", this.part);
        }
        if (this.xref != null && !this.xref.equals("")) {
            map.put("XREF", this.xref);
        }
        if (this.screen != null && !this.screen.equals("")) {
            map.put("SCREEN", this.screen);
        }
        if (this.id != null && !this.id.equals("")) {
            map.put("ID", this.id);
        }
        if (this.options != null && !this.options.equals("")) {
            map.put("OPTIONS", this.options);
        }
        if (this.moreFrom != null && !this.moreFrom.equals("")) {
            map.put("FROM", this.moreFrom);
        }
        if (this.moreIens != null && !this.moreIens.equals("")) {
            map.put("IENS", this.moreIens);
        }
        Object[] params = new Object[]{map};
        String rpc = super.isUseScLister() ? SC_LISTER : DDR_LISTER;
        String response = super.execute(rpc, params);
        List list = StringUtils.getStringList((String)response);
        int i = 0;
        String str = (String)list.get(0);
        if (str.equals("[Misc]")) {
            if (!((String)list.get(++i)).startsWith("MORE")) {
                throw new Exception("Error packing LISTER return; expected 'MORE...', got " + (String)list.get(i));
            }
            this.setMoreParams((String)list.get(i));
        }
        List<String> results = null;
        results = this.flags != null && this.flags.indexOf("P") != -1 ? this.parsePackedResult(list) : this.packResult(list);
        return results;
    }

    public static DdrLister buildIenNameQuery(ISecurityContext securityContext, String fileNumber) {
        DdrLister query = new DdrLister(securityContext);
        query.setFile(fileNumber);
        query.setFields(".01");
        query.setFlags("IP");
        query.setXref("#");
        return query;
    }

    public static DdrLister buildFileQuery(ISecurityContext securityContext, String fileNumber, String fieldString) {
        DdrLister query = new DdrLister(securityContext);
        query.setFile(fileNumber);
        query.setFields(fieldString);
        query.setFlags("IP");
        query.setXref("#");
        return query;
    }

    private String getFieldsArg() {
        String result = "@";
        for (int i = 0; i < this.requestedFields.size(); ++i) {
            if (this.requestedFields.get(i).equals("@")) continue;
            result = result + ';' + this.requestedFields.get(i);
        }
        return result;
    }

    private void setMoreParams(String line) throws Exception {
        String[] flds = StringUtils.pieceList((String)line, (char)'^');
        if (!flds[0].equals("MORE")) {
            throw new Exception("Invalid return data: expected 'MORE', got " + flds[0]);
        }
        this.moreFrom = flds[1];
        this.moreIens = flds[2];
    }

    private List<String> toStringArray(Hashtable<String, Hashtable<String, DdrField>> hashedRex) {
        ArrayList<String> list = new ArrayList<String>();
        for (int recnum = 0; recnum < this.ienList.size(); ++recnum) {
            String s = this.ienList.get(recnum);
            Hashtable<String, DdrField> hashedFlds = hashedRex.get(this.ienList.get(recnum));
            for (int fldnum = 0; fldnum < this.requestedFields.size(); ++fldnum) {
                String fmNum = this.requestedFields.get(fldnum);
                boolean external = false;
                if (fmNum.indexOf(69) != -1) {
                    fmNum = fmNum.substring(0, fmNum.length() - 1);
                    external = true;
                }
                DdrField fld = hashedFlds.get(fmNum);
                s = external ? s + '^' + fld.getExternalVal() : s + '^' + fld.getVal();
            }
            list.add(s);
        }
        return list;
    }

    private List<String> parsePackedResult(List<String> lines) throws Exception {
        int index = -1;
        for (String str : lines) {
            ++index;
            if (!str.startsWith("[Errors]")) continue;
            throw new Exception("error parsing packed result");
        }
        index = -1;
        for (String str : lines) {
            ++index;
            if (!str.startsWith("[Data]")) continue;
            ArrayList<String> lst = new ArrayList<String>();
            ++index;
            while (index < lines.size()) {
                lst.add(lines.get(index++));
            }
            return lst;
        }
        throw new Exception("Error parsing packed result: expected [Data], found none.");
    }

    private List<String> packResult(List<String> lines) throws Exception {
        int index = 0;
        if (lines.get(index).equals("0^*^0^")) {
            return new ArrayList<String>();
        }
        Hashtable<String, Hashtable<String, DdrField>> rs = new Hashtable<String, Hashtable<String, DdrField>>();
        for (String str : lines) {
            if (str.startsWith("[Errors]")) {
                throw new Exception("error packing result");
            }
            ++index;
        }
        for (String str : lines) {
            if (str.startsWith("[Data]")) {
                this.ienList = new ArrayList<String>();
                if (!lines.get(++index).equals("BEGIN_IENs")) {
                    throw new Exception("Incorrectly formatted return data");
                }
            }
            ++index;
            while (!lines.get(index).equals("END_IENs")) {
                this.ienList.add(lines.get(index++));
            }
            if (!lines.get(++index).equals("BEGIN_IDVALUES")) {
                throw new Exception("Incorrectly formatted return data");
            }
            String[] flds = StringUtils.pieceList((String)lines.get(++index), (char)';');
            int recIdx = 0;
            ++index;
            while (!lines.get(index).equals("END_IDVALUES")) {
                Hashtable<String, DdrField> rec = new Hashtable<String, DdrField>();
                for (int fldIdx = 0; fldIdx < flds.length - 1; ++fldIdx) {
                    DdrField f = new DdrField();
                    f.setFmNumber(flds[fldIdx]);
                    String requestedOptions = this.requestedFieldsTable.get(f.getFmNumber());
                    f.setFExternal(requestedOptions.indexOf(69) != -1);
                    if (f.isFExternal()) {
                        f.setExternalVal(lines.get(index++));
                    }
                    if (requestedOptions.indexOf(73) != -1) {
                        f.setVal(lines.get(index++));
                    }
                    rec.put(f.getFmNumber(), f);
                }
                rs.put(this.ienList.get(recIdx++), rec);
            }
        }
        return this.toStringArray(rs);
    }

    private String getErrMsg(List<String> lines, int index) {
        String msg = lines.get(index + 3);
        int endIndex = lines.size();
        for (int i = index + 4; i < endIndex; ++i) {
            if (msg.charAt(msg.length() - 1) != '.') {
                msg = msg + ". ";
            }
            msg = msg + lines.get(i);
        }
        return msg;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getIens() {
        return this.iens;
    }

    public void setIens(String iens) {
        this.iens = iens;
    }

    public List<String> getRequestedFields() {
        return this.requestedFields;
    }

    public void setRequestedFields(List<String> requestedFields) {
        this.requestedFields = requestedFields;
    }

    public Hashtable<String, String> getRequestedFieldsTable() {
        return this.requestedFieldsTable;
    }

    public void setRequestedFieldsTable(Hashtable<String, String> requestedFieldsTable) {
        this.requestedFieldsTable = requestedFieldsTable;
    }

    public List<String> getIenList() {
        return this.ienList;
    }

    public void setIenList(List<String> ienList) {
        this.ienList = ienList;
    }

    public void setFields(String value) {
        int i;
        String[] arr = StringUtils.pieceList((String)value, (char)';');
        this.requestedFields = new ArrayList<String>();
        for (i = 0; i < arr.length; ++i) {
            this.requestedFields.add(arr[i]);
        }
        this.requestedFieldsTable = new Hashtable();
        for (i = 0; i < this.requestedFields.size(); ++i) {
            if (this.requestedFields.get(i).equals("")) continue;
            String fldnum = this.requestedFields.get(i);
            String option = "I";
            if (fldnum.indexOf(69) != -1) {
                fldnum = fldnum.substring(0, fldnum.length() - 1);
                option = "E";
            }
            if (!this.requestedFieldsTable.containsKey(fldnum)) {
                this.requestedFieldsTable.put(fldnum, option);
                continue;
            }
            this.requestedFieldsTable.put(fldnum, this.requestedFieldsTable.get(fldnum) + option);
        }
    }

    public String getFlags() {
        return this.flags;
    }

    public void setFlags(String flags) {
        this.flags = flags;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getPart() {
        return this.part;
    }

    public void setPart(String part) {
        this.part = part;
    }

    public String getXref() {
        return this.xref;
    }

    public void setXref(String xref) {
        this.xref = xref;
    }

    public String getScreen() {
        return this.screen;
    }

    public void setScreen(String screen) {
        this.screen = screen;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public String getMoreFrom() {
        return this.moreFrom;
    }

    public void setMoreFrom(String moreFrom) {
        this.moreFrom = moreFrom;
    }

    public String getMoreIens() {
        return this.moreIens;
    }

    public void setMoreIens(String moreIens) {
        this.moreIens = moreIens;
    }
}

