/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.ddr;

import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import gov.va.med.lom.vistabroker.ddr.DdrParams;
import gov.va.med.lom.vistabroker.ddr.DdrQuery;
import gov.va.med.lom.vistabroker.security.ISecurityContext;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DdrGetsEntry
extends DdrQuery {
    public static final String DDR_GETS_ENTRY_DATA = "DDR GETS ENTRY DATA";
    public static final String SC_GETS_ENTRY_DATA = "SC GETS ENTRY DATA";
    private String file;
    private String iens;
    private String fields;
    private String flags;

    public DdrGetsEntry(ISecurityContext securityContext) {
        super(securityContext);
    }

    public DdrGetsEntry(BaseDao baseDao) {
        super(baseDao);
    }

    public List<String> execute(DdrParams ddrParams) throws Exception {
        this.setFile(ddrParams.getFile());
        this.setIens(ddrParams.getIens());
        this.setFields(ddrParams.getFields());
        this.setFlags(ddrParams.getFlags());
        return this.execute();
    }

    public List<String> execute() throws Exception {
        if (this.file == null || this.file.equals("")) {
            throw new Exception("Must have a file");
        }
        if (this.iens == null || this.iens.equals("")) {
            throw new Exception("Must have IENS");
        }
        if (this.fields == null || this.fields.equals("")) {
            throw new Exception("Must have a field");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("\"FILE\"", this.file);
        map.put("\"IENS\"", this.iens);
        map.put("\"FIELDS\"", this.fields);
        if (this.flags != null && !this.flags.equals("")) {
            map.put("\"FLAGS\"", this.flags);
        }
        Object[] params = new Object[]{map};
        String rpc = super.isUseScLister() ? SC_GETS_ENTRY_DATA : DDR_GETS_ENTRY_DATA;
        String response = super.execute(rpc, params);
        return StringUtils.getStringList((String)response);
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getIens() {
        return this.iens;
    }

    public void setIens(String iens) {
        this.iens = iens;
    }

    public String getFields() {
        return this.fields;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public String getFlags() {
        return this.flags;
    }

    public void setFlags(String flags) {
        this.flags = flags;
    }
}

