/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.lom.vistabroker.admin.dao;

import gov.va.med.lom.javaUtils.misc.StringUtils;
import gov.va.med.lom.vistabroker.admin.data.TidesDisplayOrderComparator;
import gov.va.med.lom.vistabroker.admin.data.TidesItem;
import gov.va.med.lom.vistabroker.dao.BaseDao;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TidesDao
extends BaseDao {
    private static final Log log = LogFactory.getLog(TidesDao.class);

    public TidesDao() {
    }

    public TidesDao(BaseDao baseDao) {
        super(baseDao);
    }

    public SortedMap<String, TidesItem> getPromptOrData(String dfn, String contactDT, String field, String flags) throws Exception {
        this.setDefaultContext("ALS CLINICAL RPC");
        this.setDefaultRpcName("ALS TIDES GET PROMPTS OR DATA");
        Object[] params = new Object[]{dfn, contactDT, field, flags};
        List<String> results = this.lCall(params);
        TreeMap<Object, TidesItem> questions = new TreeMap<Object, TidesItem>(new TidesDisplayOrderComparator());
        String header = "";
        for (String s : results) {
            TidesItem item = new TidesItem(s);
            if (0 != item.getDisplayOrder().compareToIgnoreCase("0")) {
                String p;
                String[] displayOrder = item.getDisplayOrder().split("\\.");
                item.setHeader(header);
                if (2 == displayOrder.length && questions.containsKey(displayOrder[0])) {
                    TidesItem parentItem;
                    TidesItem childItem = parentItem = (TidesItem)questions.get(displayOrder[0]);
                    while (null != childItem.getParentItem()) {
                        childItem = childItem.getParentItem();
                    }
                    if (null == parentItem) continue;
                    item.setDisplayOrder(displayOrder[0]);
                    childItem.setParentItem(item);
                    if (0 == parentItem.getDataType().compareTo("m")) {
                        parentItem.setFormElement(this.CreateFormObjectCheckBoxes(parentItem));
                    } else if (0 == parentItem.getDataType().compareTo("M")) {
                        parentItem.setFormElement(this.CreateFormObjectMULTIPLE(parentItem));
                    } else if (0 == parentItem.getDataType().compareToIgnoreCase("s") && 0 == item.getDataType().compareToIgnoreCase("w")) {
                        parentItem.setFormElement(this.CreateFormObjectBasic(item));
                    }
                    item.setDisplayOrder(displayOrder[1]);
                    continue;
                }
                if (0 == item.getDataType().compareToIgnoreCase("f")) {
                    item.setFormElement(this.CreateFormObjectBasic(item));
                } else if (0 == item.getDataType().compareToIgnoreCase("d")) {
                    item.setFormElement(this.CreateFormObjectBasic(item));
                } else if (0 == item.getDataType().compareToIgnoreCase("s")) {
                    item.setFormElement(this.CreateFormObjectDropDowns(item));
                } else if (0 == item.getDataType().compareToIgnoreCase("n")) {
                    item.setFormElement(this.CreateFormObjectDropDowns(item));
                } else if (0 == item.getDataType().compareToIgnoreCase("r")) {
                    item.setFormElement(this.CreateRadioButtons(item));
                } else if (0 == item.getDataType().compareToIgnoreCase("w")) {
                    item.setFormElement(this.CreateFormObjectBasic(item));
                } else if (0 != item.getDataType().compareTo("m") && 0 != item.getDataType().compareTo("M") && 0 == (p = item.getDataType().substring(0, 1)).compareToIgnoreCase("p")) {
                    item.setFormElement(this.CreateFormObjectDropDowns(item));
                }
                questions.put(item.getDisplayOrder(), item);
                continue;
            }
            if (0 == item.getDataType().compareToIgnoreCase("h")) {
                header = item.getTextPrompt();
                continue;
            }
            if (0 != item.getDataType().compareToIgnoreCase("d")) continue;
        }
        return questions;
    }

    public String setFileData(List<String> data, String flags) throws Exception {
        this.setDefaultContext("ALS CLINICAL RPC");
        this.setDefaultRpcName("ALS TIDES FILE DATA");
        Object[] params = new Object[]{data, flags};
        String results = this.sCall(params);
        return results;
    }

    public String setWordProcessingData(String ien, String fieldNumber, List<String> data) throws Exception {
        this.setDefaultContext("ALS CLINICAL RPC");
        this.setDefaultRpcName("ALS TIDES MULTI-WP FILER");
        Object[] params = new Object[]{ien, data};
        String results = this.sCall(params);
        return results;
    }

    public List<String> getTargetValues(String shortForm, String file, String iens, String fields, String flags, String number, String from, String part, String index, String screen, String indextifier) throws Exception {
        this.setDefaultContext("ALS CLINICAL RPC");
        this.setDefaultRpcName("ALS TIDES LIST TARGET VALUES");
        Object[] params = new Object[]{shortForm, file, iens, fields, flags, number, from, part, index, screen, indextifier};
        List<String> results = null;
        try {
            results = this.lCall(params);
        }
        catch (Exception e) {
            log.error((Object)("ALS TIDES LIST TARGET VALUES failed with input of: " + file));
        }
        return results;
    }

    private String CreateFormObjectBasic(TidesItem item) throws Exception {
        StringBuffer element = new StringBuffer();
        element.append("<formElement>");
        element.append("<displayOrder>" + item.getDisplayOrder() + "</displayOrder>");
        element.append("<dataType>" + item.getDataType() + "</dataType>");
        element.append("<textPrompt>" + item.getTextPrompt() + "</textPrompt>");
        element.append("</formElement>");
        return element.toString();
    }

    private String CreateFormObjectDropDowns(TidesItem item) throws Exception {
        StringBuffer element = new StringBuffer();
        element.append("<formElement>");
        element.append("<displayOrder>" + item.getDisplayOrder() + "</displayOrder>");
        element.append("<textPrompt>" + item.getTextPrompt() + "</textPrompt>");
        if (0 == item.getDataType().compareToIgnoreCase("s")) {
            element.append("<dataType>" + item.getDataType() + "</dataType>");
            item.setAnswerList(this.ParseOptionsS(item.getSetOfCodes()));
            Iterator<String> itr = item.getAnswerList().keySet().iterator();
            while (itr.hasNext()) {
                String value = itr.next().toString();
                String name = StringUtils.escapeEntities((String)((String)item.getAnswerList().get(value)).toString());
                element.append("<answer><name>" + name + "</name><value>" + value + "</value></answer>");
            }
        } else if (0 == item.getDataType().compareToIgnoreCase("n")) {
            element.append("<dataType>" + item.getDataType() + "</dataType>");
            String[] optionsArray = item.getSetOfCodes().split(":");
            if (2 <= optionsArray.length) {
                int start = new Integer(optionsArray[0]);
                int stop = new Integer(optionsArray[1]);
                for (int i = start; i <= stop; ++i) {
                    element.append("<answer><name>" + i + "</name><value>" + i + "</value></answer>");
                }
            }
        } else {
            String p = item.getDataType().substring(0, 1);
            if (0 == p.compareToIgnoreCase("p")) {
                element.append("<dataType>s</dataType>");
                List<String> optionsList = this.GetTargetValues(item.getDataType());
                item.setAnswerList(this.ParseOptionsP(optionsList));
                Iterator<String> itr = item.getAnswerList().keySet().iterator();
                while (itr.hasNext()) {
                    String value = itr.next().toString();
                    String name = StringUtils.escapeEntities((String)((String)item.getAnswerList().get(value)).toString());
                    element.append("<answer><name>" + name + "</name><value>" + value + "</value></answer>");
                }
            }
        }
        element.append("</formElement>");
        return element.toString();
    }

    private String CreateFormObjectCheckBoxes(TidesItem item) throws Exception {
        StringBuffer element = new StringBuffer();
        element.append("<formElement>");
        element.append("<displayOrder>" + item.getDisplayOrder() + "</displayOrder>");
        element.append("<textPrompt>" + item.getTextPrompt() + "</textPrompt>");
        TidesItem childItem = item.getParentItem();
        Iterator<String> itr = null;
        if (null != childItem) {
            if (0 == childItem.getDataType().compareToIgnoreCase("s")) {
                element.append("<dataType>" + item.getDataType() + "</dataType>");
                childItem.setAnswerList(this.ParseOptionsS(childItem.getSetOfCodes()));
            } else {
                String file = childItem.getDataType().substring(1, childItem.getDataType().length());
                if (0 == file.compareToIgnoreCase("200")) {
                    element.append("<dataType>200</dataType>");
                } else {
                    element.append("<dataType>" + item.getDataType() + "</dataType>");
                }
                List<String> optionsList = this.GetTargetValues(childItem.getDataType());
                childItem.setAnswerList(this.ParseOptionsP(optionsList));
            }
            if (null != childItem.getAnswerList()) {
                itr = childItem.getAnswerList().keySet().iterator();
            }
            if (null != itr) {
                while (itr.hasNext()) {
                    String value = itr.next().toString();
                    String name = ((String)childItem.getAnswerList().get(value)).toString();
                    element.append("<answer><id>" + item.getDisplayOrder() + "</id><name>" + StringUtils.escapeEntities((String)name) + "</name><value>" + StringUtils.escapeEntities((String)value) + "</value></answer>");
                }
            }
        }
        element.append("</formElement>");
        return element.toString();
    }

    private String CreateFormObjectMULTIPLE(TidesItem item) throws Exception {
        StringBuffer element = new StringBuffer();
        element.append("<formElement>");
        element.append("<displayOrder>" + item.getDisplayOrder() + "</displayOrder>");
        element.append("<dataType>" + item.getDataType() + "</dataType>");
        element.append("<textPrompt>" + item.getTextPrompt() + "</textPrompt>");
        for (TidesItem child = item.getParentItem(); null != child; child = child.getParentItem()) {
            element.append("<answer>");
            element.append("<name>" + child.getDataType() + "</name>");
            if (0 == child.getDataType().compareToIgnoreCase("f")) {
                element.append("<value>");
                element.append("<textPrompt>" + child.getTextPrompt() + "</textPrompt>");
                element.append("<displayOrder>" + item.getDisplayOrder() + "</displayOrder>");
                element.append("</value>");
            } else if (0 == child.getDataType().compareToIgnoreCase("s")) {
                element.append("<value>");
                element.append("<textPrompt>" + child.getTextPrompt() + "</textPrompt>");
                element.append("<displayOrder>" + item.getDisplayOrder() + "</displayOrder>");
                child.setAnswerList(this.ParseOptionsS(child.getSetOfCodes()));
                Iterator<String> itr = null;
                if (null != child.getAnswerList()) {
                    itr = child.getAnswerList().keySet().iterator();
                }
                if (null != itr) {
                    while (itr.hasNext()) {
                        String value = itr.next().toString();
                        String name = ((String)child.getAnswerList().get(value)).toString();
                        element.append("<answer><name>" + StringUtils.escapeEntities((String)name) + "</name><value>" + StringUtils.escapeEntities((String)value) + "</value></answer>");
                    }
                }
                element.append("</value>");
            }
            element.append("</answer>");
        }
        element.append("</formElement>");
        return element.toString();
    }

    private String CreateRadioButtons(TidesItem item) throws Exception {
        StringBuffer element = new StringBuffer();
        element.append("<formElement>");
        element.append("<displayOrder>" + item.getDisplayOrder() + "</displayOrder>");
        element.append("<textPrompt>" + item.getTextPrompt() + "</textPrompt>");
        element.append("<dataType>" + item.getDataType() + "</dataType>");
        item.setAnswerList(this.ParseOptionsS(item.getSetOfCodes()));
        Iterator<String> itr = item.getAnswerList().keySet().iterator();
        while (itr.hasNext()) {
            String value = itr.next().toString();
            String name = StringUtils.escapeEntities((String)((String)item.getAnswerList().get(value)).toString());
            element.append("<answer><name>" + name + "</name><value>" + value + "</value></answer>");
        }
        element.append("</formElement>");
        return element.toString();
    }

    private SortedMap<String, String> ParseOptionsS(String options) throws Exception {
        TreeMap<Object, String> optionsList = new TreeMap<Object, String>(new TidesDisplayOrderComparator());
        try {
            String[] optionsArray;
            for (String o : optionsArray = options.split(";")) {
                String[] stripped = o.split(":");
                if (null == stripped || 2 > stripped.length) continue;
                optionsList.put(stripped[0], stripped[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return optionsList;
    }

    private SortedMap<String, String> ParseOptionsP(List<String> options) throws Exception {
        TreeMap<Object, String> optionsList = new TreeMap<Object, String>(new TidesDisplayOrderComparator());
        try {
            for (String option : options) {
                String[] stripped = option.split("\\^");
                if (null != stripped && 2 <= stripped.length) {
                    optionsList.put(stripped[0], stripped[1]);
                    continue;
                }
                optionsList.put(option, option);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return optionsList;
    }

    private List<String> GetTargetValues(String pointer) throws Exception {
        String file = pointer.substring(1, pointer.length());
        if (0 != file.compareToIgnoreCase("200")) {
            return this.getTargetValues("1", file, "", "", "", "", "", "", "", "", "");
        }
        return null;
    }
}

