/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel.ccow;

import gov.va.med.authentication.kernel.KaajeeException;
import gov.va.med.authentication.kernel.LoginUserInfoVO;
import gov.va.med.authentication.kernel.VistALogon;
import gov.va.med.authentication.kernel.ccow.CcowEnv;
import gov.va.med.authentication.kernel.ccow.CommonContextMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class VistaTokenValidator {
    private static Logger logger = Logger.getLogger(VistaTokenValidator.class);
    private CcowEnv ccowEnv;

    public VistaTokenValidator(CcowEnv ccowEnv) {
        this.ccowEnv = ccowEnv;
    }

    public boolean hasVAContext() {
        return null != this.ccowEnv.getCurrentCommonContext();
    }

    public LoginUserInfoVO validate() throws KaajeeException {
        String clientIP;
        boolean validValues;
        LoginUserInfoVO userInfo = null;
        if (!this.hasVAContext()) {
            return userInfo;
        }
        CommonContextMap vaContext = this.ccowEnv.getCurrentCommonContext();
        String vistaToken = vaContext.getContextItem("user.id.logon.vistatoken");
        String vistaLogon = vaContext.getContextItem("user.id.logon.vistalogon");
        boolean bl = validValues = vistaToken != null && vistaToken.length() > 0 && vistaLogon != null && vistaLogon.split("\\^").length > 1;
        if (!validValues) {
            throw new KaajeeException("invalid user context in VA context");
        }
        String[] array = vistaLogon.split("\\^");
        String institution = array[1];
        userInfo = VistALogon.getLoginUserInfo(vistaToken, institution, clientIP = this.ccowEnv.getClientIPAddr());
        if (userInfo != null && logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)("successfully validated the user using ccow sso:" + userInfo));
        }
        return userInfo;
    }
}

