/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel.ccow;

import gov.va.med.authentication.kernel.LoginUserInfoVO;
import gov.va.med.authentication.kernel.ccow.CcowEnv;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LoginResult {
    private static Logger logger = Logger.getLogger(LoginResult.class);
    private CcowEnv ccowEnv;
    private LoginUserInfoVO userInfo;
    private Principal principal;

    public LoginResult(CcowEnv ccowEnv, HttpServletRequest req) {
        this.ccowEnv = ccowEnv;
        HttpSession session = ccowEnv.getHttpSession();
        this.userInfo = (LoginUserInfoVO)session.getAttribute("gov.va.med.authentication.kernel.LoginUserInfo");
        this.principal = req.getUserPrincipal();
    }

    public boolean UsingToken() {
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)("user logged in using ccow/sso token? " + this.ccowEnv.isLoginUsingToken()));
        }
        return this.ccowEnv.isLoginUsingToken();
    }

    public boolean UsingLoginPage() {
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)("user logged in using login page? LoginUserInfoVO: " + this.userInfo));
        }
        return this.userInfo != null;
    }

    public boolean isSuccessful() {
        return this.principal != null && this.userInfo != null;
    }
}

