/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel.ccow;

import gov.va.med.authentication.kernel.ccow.CcowEnv;
import gov.va.med.authentication.kernel.ccow.ContextWriter;
import gov.va.med.authentication.kernel.ccow.LoginResult;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ContextWriterFilter
implements Filter {
    private static Logger logger = Logger.getLogger(ContextWriterFilter.class);

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest servletReq, ServletResponse servletResp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)servletReq;
        HttpServletResponse res = (HttpServletResponse)servletResp;
        chain.doFilter(servletReq, servletResp);
        this.doAfter(req, res);
    }

    private void doAfter(HttpServletRequest req, HttpServletResponse res) {
        CcowEnv ccowEnv = CcowEnv.getInstance(req);
        if (ccowEnv == null) {
            return;
        }
        LoginResult result = new LoginResult(ccowEnv, req);
        if (!result.isSuccessful()) {
            if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                logger.debug((Object)"user failed to log in . . . ");
            }
            return;
        }
        if (result.UsingToken()) {
            if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                logger.debug((Object)"user logged in using ccow/sso . . . ");
            }
            return;
        }
        if (result.UsingLoginPage()) {
            if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                logger.debug((Object)"user logged in using login page and will write user context . . . ");
            }
            ContextWriter ctxWriter = new ContextWriter(ccowEnv);
            ctxWriter.writeContext();
            return;
        }
    }

    public void destroy() {
    }
}

