/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel.ccow;

import gov.va.med.authentication.kernel.KaajeeException;
import gov.va.med.authentication.kernel.LoginUserInfoVO;
import gov.va.med.authentication.kernel.VistALogon;
import gov.va.med.authentication.kernel.ccow.CcowEnv;
import gov.va.med.authentication.kernel.ccow.CommonContextSession;
import gov.va.med.authentication.kernel.ccow.ContextManager;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ContextWriter {
    private static Logger logger = Logger.getLogger(ContextWriter.class);
    private CcowEnv ccowEnv;

    public ContextWriter(CcowEnv ccowEnv) {
        this.ccowEnv = ccowEnv;
    }

    public void writeContext() {
        LoginUserInfoVO userInfo = this.getLoginUserInfoVo();
        Map newContext = this.getNewContext(userInfo);
        if (newContext != null) {
            CommonContextSession ctxSession = this.joinContext(this.ccowEnv, userInfo);
            if (ctxSession != null) {
                try {
                    ctxSession.setContext(newContext);
                    this.ccowEnv.setActiveContextSession(ctxSession);
                }
                catch (KaajeeException e) {
                    if (logger.isEnabledFor((Priority)Level.ERROR)) {
                        logger.debug((Object)("error writing context: " + (Object)((Object)e)));
                    }
                    ctxSession.stop();
                }
            } else if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                logger.debug((Object)("common context session is null: " + ctxSession));
            }
        } else if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)("new user context is null: " + newContext));
        }
    }

    private LoginUserInfoVO getLoginUserInfoVo() {
        HttpSession session = this.ccowEnv.getHttpSession();
        return (LoginUserInfoVO)session.getAttribute("gov.va.med.authentication.kernel.LoginUserInfo");
    }

    private Map getNewContext(LoginUserInfoVO userInfo) {
        String name;
        HashMap<String, String> newContext = null;
        String idAndDomain = this.getKernelCcowToken(userInfo);
        if (idAndDomain == null) {
            return newContext;
        }
        String[] array = idAndDomain.split("\\n");
        if (array.length < 2) {
            return newContext;
        }
        String tokenId = array[0];
        String domainAndInstitution = array[1];
        String vpid = userInfo.getUserVpid();
        String vistaName = name = userInfo.getUserName01();
        newContext = new HashMap<String, String>();
        newContext.put("user.id.logon.vistaname", vistaName);
        newContext.put("user.id.logon.vistatoken", tokenId);
        newContext.put("user.id.logon.vistalogon", domainAndInstitution);
        newContext.put("user.id.logon.vpid", vpid);
        newContext.put("user.co.name", name);
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)("new context :" + vistaName + "\n" + tokenId + "\n" + domainAndInstitution + "\n" + vpid + "\n" + name + "\n"));
        }
        return newContext;
    }

    private String getKernelCcowToken(LoginUserInfoVO userInfo) {
        String token = null;
        String institution = userInfo.getLoginStationNumber();
        String duz = userInfo.getUserDuz();
        String clientIP = this.ccowEnv.getClientIPAddr();
        token = VistALogon.getKernelCcowToken(institution, duz, clientIP);
        return token;
    }

    private CommonContextSession joinContext(CcowEnv ccowEnv, LoginUserInfoVO userInfo) {
        CommonContextSession ctxSession = null;
        String passcode = this.getPasscode(userInfo);
        if (passcode != null && passcode.length() > 0) {
            ctxSession = ContextManager.joinWriteContext(passcode, ccowEnv);
        } else if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)"failed to obtain the passcode");
        }
        return ctxSession;
    }

    private String getPasscode(LoginUserInfoVO userInfo) {
        String passCode = null;
        String institution = userInfo.getLoginStationNumber();
        String duz = userInfo.getUserDuz();
        passCode = VistALogon.getSecureCcowPasscode(institution, duz);
        return passCode;
    }
}

