/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel.ccow;

import com.sentillion.sdkweb.webcontextor.ContextItemCollection;
import gov.va.med.authentication.kernel.LoginUserInfoVO;
import gov.va.med.authentication.kernel.ccow.CcowEnv;
import gov.va.med.authentication.kernel.ccow.CommonContextMap;
import gov.va.med.authentication.kernel.ccow.CommonContextSession;
import gov.va.med.authentication.kernel.ccow.ContextChangesMessage;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ContextParticipant {
    private static Logger logger = Logger.getLogger(ContextParticipant.class);
    private static final String ACCEPTED = "ContextChangesAccepted";
    private ContextChangesMessage msg;

    public ContextParticipant(ContextChangesMessage msg) {
        this.msg = msg;
    }

    public void respond() {
        block5: {
            CcowEnv ccowEnv = this.msg.getCcowEnv();
            if (ccowEnv == null) {
                if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                    logger.debug((Object)"in contextParticipant respond: CcowEnv is null");
                }
                return;
            }
            boolean acceptChange = true;
            if (this.msg.getMethodValue().equalsIgnoreCase(ACCEPTED)) {
                acceptChange = this.handleChange();
            }
            HttpServletResponse res = this.msg.getResponse();
            String contents = "decision=accept";
            res.setContentType("application/x-www-form-urlencoded");
            res.setContentLength(contents.length());
            try {
                PrintWriter out = res.getWriter();
                out.write(contents);
            }
            catch (IOException e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) break block5;
                logger.debug((Object)"error in writing response from the context participant");
            }
        }
    }

    private boolean handleChange() {
        boolean acceptChange = true;
        if (this.userChanged()) {
            this.logoff();
        }
        return acceptChange;
    }

    private boolean userChanged() {
        boolean userChanged = false;
        String currentUser = null;
        String newUser = null;
        CcowEnv ccowEnv = this.msg.getCcowEnv();
        CommonContextSession ctxSession = ccowEnv.getActiveContextSession();
        if (ctxSession == null) {
            userChanged = true;
        } else {
            ContextItemCollection newItemCollection = ctxSession.getCurrentContext();
            CommonContextMap newContext = new CommonContextMap(newItemCollection);
            newUser = newContext.getContextItem("user.id.logon.vistaname");
            LoginUserInfoVO userInfo = ccowEnv.getLoginUserInfo();
            if (userInfo != null) {
                currentUser = userInfo.getUserName01();
            }
            if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                logger.debug((Object)("\ncurrent user is : " + currentUser));
                logger.debug((Object)("\nnew user is : " + newUser));
            }
            userChanged = newUser != null && currentUser != null ? !newUser.equals(currentUser) : true;
        }
        return userChanged;
    }

    private void logoff() {
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)"\ncurrent user is being logged off");
        }
        CcowEnv ccowEnv = this.msg.getCcowEnv();
        ccowEnv.getHttpSession().invalidate();
    }
}

