/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel.ccow;

import com.sentillion.sdkweb.webcontextor.WebContextor;
import com.sentillion.sdkweb.webcontextor.WebContextorException;
import gov.va.med.authentication.kernel.ccow.CcowEnv;
import gov.va.med.authentication.kernel.ccow.CommonContextSession;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class ContextManager {
    private static Logger logger = Logger.getLogger(ContextManager.class);

    public static CommonContextSession joinReadContext(CcowEnv ccowEnv) {
        return ContextManager.joinContext("", ccowEnv);
    }

    public static CommonContextSession joinWriteContext(String passcode, CcowEnv ccowEnv) {
        CommonContextSession contextSession = null;
        if (passcode == null) {
            if (logger.isEnabledFor((Priority)Level.WARN)) {
                logger.debug((Object)"attempted to obtain a Write Context session with a null passcode");
            }
            contextSession = ContextManager.joinReadContext(ccowEnv);
        } else {
            contextSession = ContextManager.joinContext(passcode, ccowEnv);
        }
        return contextSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommonContextSession joinContext(String passcode, CcowEnv ccowEnv) {
        Map sessions = ccowEnv.getContextSessions();
        CommonContextSession ctxSession = null;
        String applName = null;
        String contextManagerUrl = ccowEnv.getContextManagerURL();
        String contextParticipantURL = ccowEnv.getContextParticipantURL();
        String appName = ccowEnv.getApplicationName();
        WebContextor contextor = new WebContextor();
        String[] contextorBlob = new String[1];
        try {
            contextor.run(contextorBlob, contextManagerUrl, contextParticipantURL, appName + "#", passcode, true);
            applName = contextor.getName(contextorBlob);
            ctxSession = new CommonContextSession(contextorBlob[0]);
            sessions.put(applName, ctxSession);
        }
        catch (WebContextorException e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.debug((Object)("run contextor error: " + (Object)((Object)e)));
            }
        }
        finally {
            ccowEnv.setContextSessions(sessions);
        }
        return ctxSession;
    }

    public static void suspendContext(CcowEnv ccowEnv) {
        CommonContextSession ctxSession;
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)("in suspendContext for ccowEnv: " + ccowEnv));
        }
        if (ccowEnv != null && (ctxSession = ccowEnv.getActiveContextSession()) != null) {
            ctxSession.suspend();
            ccowEnv.setActiveContextSession(null);
        }
    }

    public static void abandonContext(CcowEnv ccowEnv) {
        Map sessions;
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)("in abandonContext for CcowEnv: " + ccowEnv));
        }
        if (ccowEnv != null && (sessions = ccowEnv.getContextSessions()) != null) {
            Set keys = sessions.keySet();
            for (Object next : keys) {
                CommonContextSession ctxSession = (CommonContextSession)sessions.get(next);
                if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                    logger.debug((Object)("abandoning context for : " + ctxSession));
                }
                ctxSession.stop();
            }
        }
    }
}

