/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel.ccow;

import gov.va.med.authentication.kernel.KaajeeException;
import gov.va.med.authentication.kernel.LoginUserInfoVO;
import gov.va.med.authentication.kernel.ccow.CcowEnv;
import gov.va.med.authentication.kernel.ccow.ContextInitializer;
import gov.va.med.authentication.kernel.ccow.ContextManager;
import gov.va.med.authentication.kernel.ccow.LoginDispatcher;
import gov.va.med.authentication.kernel.ccow.VistaTokenValidator;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ContextInitializerFilter
implements Filter {
    private static Logger logger = Logger.getLogger(ContextInitializerFilter.class);
    public static String CONTEXT_PARTICIPANT = "ccowcp";
    public static String APPLET_CODEBASE = "applets/";
    public static String CCOW_KAAJEE_APPL_NAME = "VistaLinkLoginModule";
    public static String SESSION_ID = "kaajeeJSESSIONID";
    public static String APP_ARCHIVE_J2 = "WebJ2Applets.jar";
    public static String APP_ARCHIVE_IE = "WebIEApplets.cab";
    public static boolean UseIETag = false;
    public static String APP_LOCATE_TIMEOUT = "60";
    public static String LOCATOR_APPLET_BODY = "loading CCOW locator applet . . . .";
    public static String APP_DEBUG = "debug";

    public void init(FilterConfig config) throws ServletException {
        CONTEXT_PARTICIPANT = config.getInitParameter("context-participant");
        APPLET_CODEBASE = config.getInitParameter("applet-codebase");
        CCOW_KAAJEE_APPL_NAME = config.getInitParameter("ccow-kaajee-appl-name");
        SESSION_ID = config.getInitParameter("session-id");
        APP_ARCHIVE_J2 = config.getInitParameter("app-archive-J2");
        APP_ARCHIVE_IE = config.getInitParameter("app-archive-IE");
        UseIETag = Boolean.valueOf(config.getInitParameter("UseIETag"));
        APP_LOCATE_TIMEOUT = config.getInitParameter("app-locate-timeout");
        LOCATOR_APPLET_BODY = config.getInitParameter("locator-applet-body");
        APP_DEBUG = config.getInitParameter("app-debug");
    }

    public void doFilter(ServletRequest servletReq, ServletResponse servletResp, FilterChain chain) throws IOException, ServletException {
        VistaTokenValidator validator;
        HttpServletRequest req = (HttpServletRequest)servletReq;
        HttpServletResponse res = (HttpServletResponse)servletResp;
        req.getSession(true);
        CcowEnv ccowEnv = CcowEnv.getInstance(req);
        ContextInitializer initializer = new ContextInitializer(ccowEnv, req, res);
        LoginDispatcher dispatcher = new LoginDispatcher(ccowEnv, req, res);
        if (initializer.isUserLoggedIn()) {
            dispatcher.continueChain(servletReq, servletResp, chain);
            return;
        }
        if (!initializer.locatorSent()) {
            this.initializeEnvironment(initializer);
            return;
        }
        if (initializer.detectedCtxMgrParam()) {
            this.joinCommonContext(initializer);
        }
        if ((validator = new VistaTokenValidator(ccowEnv)).hasVAContext()) {
            try {
                LoginUserInfoVO userInfo = validator.validate();
                ccowEnv.setLoginUserInfo(userInfo);
                ccowEnv.setLoginUsingToken();
                dispatcher.forwardToLoginController(userInfo);
                return;
            }
            catch (KaajeeException e) {
                if (logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.debug((Object)("failed to validate existing user context or to forward to LoginController:" + (Object)((Object)e)));
                }
                this.suspendContext(ccowEnv);
            }
        } else {
            this.suspendContext(ccowEnv);
        }
        dispatcher.continueChain(servletReq, servletResp, chain);
    }

    private void initializeEnvironment(ContextInitializer initializer) {
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)"initializing ccow environment . . . ");
        }
        initializer.setEnvironment();
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)"sending locator applet . . . ");
        }
        initializer.sendLocatorApplet();
    }

    private void joinCommonContext(ContextInitializer initializer) {
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)"joining Context using initializer: ");
        }
        initializer.joincontext();
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)"retrieving VA context: ");
        }
        initializer.retrieveUserContext();
    }

    private void suspendContext(CcowEnv ccowEnv) {
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)"Suspending temporary read Context");
        }
        ContextManager.suspendContext(ccowEnv);
        ccowEnv.setNotLoginUsingToken();
    }

    public void destroy() {
    }
}

