/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel.ccow;

import com.sentillion.sdkweb.webcontextor.ContextItemCollection;
import gov.va.med.authentication.kernel.KaajeeSSLHelper;
import gov.va.med.authentication.kernel.ccow.AppletTag;
import gov.va.med.authentication.kernel.ccow.CcowEnv;
import gov.va.med.authentication.kernel.ccow.CommonContextMap;
import gov.va.med.authentication.kernel.ccow.CommonContextSession;
import gov.va.med.authentication.kernel.ccow.ContextInitializerFilter;
import gov.va.med.authentication.kernel.ccow.ContextManager;
import gov.va.med.authentication.kernel.ccow.LoginResult;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ContextInitializer {
    private static Logger logger = Logger.getLogger(ContextInitializer.class);
    private final String CONTEXT_PARTICIPANT = ContextInitializerFilter.CONTEXT_PARTICIPANT;
    private final String APPLET_CODEBASE = ContextInitializerFilter.APPLET_CODEBASE;
    private final String CCOW_KAAJEE_APPL_NAME = ContextInitializerFilter.CCOW_KAAJEE_APPL_NAME;
    private final String SESSION_ID = ContextInitializerFilter.SESSION_ID;
    private final String BODY_TEXT = ContextInitializerFilter.LOCATOR_APPLET_BODY;
    private CcowEnv ccowEnv;
    private HttpServletRequest req;
    private HttpServletResponse res;

    public ContextInitializer(CcowEnv ccowEnv, HttpServletRequest req, HttpServletResponse res) {
        this.ccowEnv = ccowEnv;
        this.req = req;
        this.res = res;
    }

    public boolean locatorSent() {
        return this.ccowEnv.locatorSent();
    }

    public void setEnvironment() {
        String url = this.req.getRequestURL().toString();
        String contextPath = this.req.getContextPath();
        String base = url.split(contextPath)[0];
        String applCodebaseURL = base + contextPath + "/" + this.APPLET_CODEBASE;
        String clientIPAddr = this.req.getRemoteAddr();
        String serverName = this.req.getServerName();
        KaajeeSSLHelper helper = new KaajeeSSLHelper();
        int nonSSLPort = 80;
        try {
            nonSSLPort = helper.getListenPort();
        }
        catch (Exception e) {
            logger.warn((Object)("Error obtaining port number from this server: " + e.getMessage()));
        }
        String contextParticipantURL = "http://" + serverName + ":" + nonSSLPort + contextPath + "/" + this.CONTEXT_PARTICIPANT;
        String encodedContextParticipantURL = contextParticipantURL + ";" + this.SESSION_ID + "=" + this.req.getSession().getId();
        this.ccowEnv.setApplicationName(this.CCOW_KAAJEE_APPL_NAME);
        this.ccowEnv.setContextParticipantURL(encodedContextParticipantURL);
        this.ccowEnv.setAppletCodebaseURL(applCodebaseURL);
        this.ccowEnv.setClientIPAddr(clientIPAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLocatorApplet() {
        String contextParticipantURL = this.ccowEnv.getContextParticipantURL();
        String appletCodebaseURL = this.ccowEnv.getAppletCodebaseURL();
        String refreshURL = this.req.getRequestURL().toString();
        AppletTag applet = new AppletTag(contextParticipantURL, appletCodebaseURL, refreshURL);
        try {
            this.sendApplet(this.res, applet);
        }
        catch (IOException e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.debug((Object)("Error sending the Locator Applet: " + e.getMessage()));
            }
        }
        finally {
            this.ccowEnv.setLocatorSent();
        }
    }

    private void sendApplet(HttpServletResponse res, AppletTag applet) throws IOException {
        res.setContentType("text/html");
        PrintWriter out = res.getWriter();
        res.setHeader("Cache-Control", "no-cache");
        res.setHeader("Pragma", "no-cache");
        res.setHeader("Expires", "0");
        String TITLE = "LOCATOR APPLET PAGE";
        out.print("<HEAD><TITLE> " + TITLE + " </TITLE></HEAD><BODY>");
        out.print("<h1> " + this.BODY_TEXT + " </h1>");
        String LocatorApplet = applet.getLocatorAppletTag();
        out.print(LocatorApplet);
        out.print("</BODY>");
        out.flush();
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)"Locator Applet sent back to browser: ");
        }
    }

    public boolean detectedCtxMgrParam() {
        String contextManagerUrl;
        boolean detected = false;
        String existing = this.ccowEnv.getContextManagerURL();
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)("before: " + existing));
        }
        boolean bl = detected = (contextManagerUrl = this.req.getParameter("contextManagerUrl")) != null && contextManagerUrl.length() > 0;
        if (detected) {
            boolean different;
            if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                logger.debug((Object)("detected: " + contextManagerUrl));
            }
            boolean bl2 = different = !contextManagerUrl.equals(existing);
            if (different) {
                this.ccowEnv.setContextManagerURL(contextManagerUrl);
                this.ccowEnv.setActiveContextSession(null);
                this.ccowEnv.setCurrentCommonContext(null);
            }
        }
        return detected;
    }

    public void joincontext() {
        CommonContextSession ctxSession = null;
        ctxSession = this.ccowEnv.getActiveContextSession();
        if (ctxSession == null) {
            ctxSession = ContextManager.joinReadContext(this.ccowEnv);
            if (ctxSession != null) {
                this.ccowEnv.setActiveContextSession(ctxSession);
            } else if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                logger.debug((Object)"Failed to join a ReadContext session . . . ");
            }
        } else {
            if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                logger.debug((Object)"already in ReadContext session, will resume . . . ");
            }
            ctxSession.resume();
            if (ctxSession.getState() != 2) {
                this.ccowEnv.setActiveContextSession(null);
                if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                    logger.debug((Object)("failed to resume context session: " + ctxSession));
                }
            }
        }
    }

    public void retrieveUserContext() {
        CommonContextMap context = null;
        context = this.ccowEnv.getCurrentCommonContext();
        if (context == null) {
            CommonContextSession ctxSession = this.ccowEnv.getActiveContextSession();
            if (ctxSession != null) {
                ContextItemCollection collection = ctxSession.getCurrentContext();
                if (collection != null && collection.count() > 0) {
                    context = new CommonContextMap(collection);
                    this.ccowEnv.setCurrentCommonContext(context);
                } else if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                    logger.debug((Object)"there is no current VA context");
                }
            } else if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                logger.debug((Object)"there is no active context");
            }
        } else if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)"there is already a current VA context");
        }
    }

    public boolean isUserLoggedIn() {
        LoginResult result = new LoginResult(this.ccowEnv, this.req);
        return result.isSuccessful();
    }
}

