/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel.ccow;

import gov.va.med.authentication.kernel.ccow.CcowEnv;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ContextChangesMessage {
    private static Logger logger = Logger.getLogger(ContextChangesMessage.class);
    private static final String INTERFACE = "interface";
    private static final String METHOD = "method";
    private static final String CONTEXT_COUPON = "contextCoupon";
    private HttpServletRequest req;
    private HttpServletResponse res;
    String interfaceValue = "";
    String methodValue = "";
    String contextCouponValue = "";

    public ContextChangesMessage(HttpServletRequest req, HttpServletResponse res) {
        this.req = req;
        this.res = res;
        this.parseRequest();
    }

    private void parseRequest() {
        String messageString = this.req.getQueryString();
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)("query string: " + messageString));
        }
        this.interfaceValue = this.req.getParameter(INTERFACE);
        this.methodValue = this.req.getParameter(METHOD);
        this.contextCouponValue = this.req.getParameter(CONTEXT_COUPON);
    }

    public String getContextCouponValue() {
        return this.contextCouponValue;
    }

    public String getInterfaceValue() {
        return this.interfaceValue;
    }

    public String getMethodValue() {
        return this.methodValue;
    }

    public HttpServletResponse getResponse() {
        return this.res;
    }

    public CcowEnv getCcowEnv() {
        return CcowEnv.getInstance(this.req);
    }
}

