/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel.ccow;

import com.sentillion.sdkweb.webcontextor.ContextItem;
import com.sentillion.sdkweb.webcontextor.ContextItemCollection;
import com.sentillion.sdkweb.webcontextor.WebContextor;
import com.sentillion.sdkweb.webcontextor.WebContextorException;
import gov.va.med.authentication.kernel.KaajeeException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class CommonContextSession
implements Serializable {
    private static Logger logger = Logger.getLogger(CommonContextSession.class);
    private String contextorBlobString = null;

    CommonContextSession(String contextorBlobString) {
        this.contextorBlobString = contextorBlobString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ContextItemCollection getCurrentContext() {
        ContextItemCollection contextItemCollection = null;
        WebContextor webContextor = new WebContextor();
        String[] contextorBlob = new String[1];
        if (this.getState() != 1) {
            contextorBlob[0] = this.contextorBlobString;
            try {
                contextItemCollection = webContextor.getCurrentContext(contextorBlob);
                return contextItemCollection;
            }
            catch (WebContextorException e1) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) return contextItemCollection;
                logger.debug((Object)("in getCurrentContext: error in getting current context: " + (Object)((Object)e1)));
                return contextItemCollection;
            }
            finally {
                this.contextorBlobString = contextorBlob[0];
            }
        } else {
            if (!logger.isEnabledFor((Priority)Level.DEBUG)) return contextItemCollection;
            logger.debug((Object)"in getCurrentContext: contextor is not running: ");
        }
        return contextItemCollection;
    }

    public void setContext(Map newContext) throws KaajeeException {
        WebContextor contextor = new WebContextor();
        String[] contextorBlob = new String[]{this.contextorBlobString};
        try {
            contextor.startContextChange(contextorBlob);
            ContextItemCollection collection = new ContextItemCollection();
            String value = "";
            Set newItems = newContext.keySet();
            for (String key : newItems) {
                ContextItem item = new ContextItem();
                item.setName(key);
                value = (String)newContext.get(key);
                item.setValue(value);
                collection.add(item);
                if (!logger.isEnabledFor((Priority)Level.DEBUG)) continue;
                logger.debug((Object)("adding item: " + key + ":" + value + "\n"));
            }
            String[] responses = null;
            boolean[] notContinue = new boolean[1];
            responses = contextor.endContextChange(contextorBlob, true, collection, notContinue);
            boolean shouldCommit = true;
            String listeners = null;
            String[] coupon = new String[1];
            if (shouldCommit) {
                listeners = contextor.commitContextChange(contextorBlob, coupon);
            } else {
                contextor.cancelContextChange(contextorBlob);
            }
            if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                logger.debug((Object)("\n SET CONTEXT results :" + responses + "\n" + responses.length + "\n" + notContinue[0] + "\n" + coupon[0] + "\n" + listeners + "\n"));
            }
        }
        catch (WebContextorException e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.debug((Object)("Failed to write new user context to vault: " + (Object)((Object)e)));
            }
            throw new KaajeeException("Failed to write new user context to vault");
        }
        finally {
            this.contextorBlobString = contextorBlob[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stop() {
        WebContextor contextor = new WebContextor();
        if (this.getState() != 1) {
            String[] contextorBlob = new String[]{this.contextorBlobString};
            try {
                contextor.stop(contextorBlob);
                return;
            }
            catch (WebContextorException e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) return;
                logger.debug((Object)("error in trying to stop context session: " + (Object)((Object)e)));
                return;
            }
            finally {
                this.contextorBlobString = contextorBlob[0];
            }
        } else {
            if (!logger.isEnabledFor((Priority)Level.DEBUG)) return;
            logger.debug((Object)"in context session stop: contextor is not running");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resume() {
        WebContextor contextor = new WebContextor();
        String[] contextorBlob = new String[]{this.contextorBlobString};
        if (this.getState() != 2) {
            try {
                contextor.resume(contextorBlob);
                return;
            }
            catch (WebContextorException e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) return;
                logger.debug((Object)"error in trying to resume context session: ");
                logger.debug((Object)("the state of the session is " + this.getState()));
                logger.debug((Object)("the error was " + (Object)((Object)e)));
                return;
            }
            finally {
                this.contextorBlobString = contextorBlob[0];
            }
        } else {
            if (!logger.isEnabledFor((Priority)Level.DEBUG)) return;
            logger.debug((Object)"in resume context session: session is already participating");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void suspend() {
        WebContextor contextor = new WebContextor();
        String[] contextorBlob = new String[]{this.contextorBlobString};
        if (this.getState() == 2) {
            try {
                contextor.suspend(contextorBlob);
                return;
            }
            catch (WebContextorException e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) return;
                logger.debug((Object)("error in trying to suspend context session: " + (Object)((Object)e)));
                return;
            }
            finally {
                this.contextorBlobString = contextorBlob[0];
            }
        } else {
            if (!logger.isEnabledFor((Priority)Level.DEBUG)) return;
            logger.debug((Object)"in suspend context: not participating");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getState() {
        int status = 1;
        WebContextor contextor = new WebContextor();
        String[] contextorBlob = new String[]{this.contextorBlobString};
        try {
            status = contextor.getState(contextorBlob);
        }
        catch (WebContextorException e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.debug((Object)("error in trying to get state of context session: " + (Object)((Object)e)));
            }
            status = 1;
        }
        finally {
            this.contextorBlobString = contextorBlob[0];
            if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                logger.debug((Object)("contextor status: " + status));
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        String name = null;
        String[] contextorBlob = new String[]{this.contextorBlobString};
        WebContextor contextor = new WebContextor();
        try {
            name = contextor.getName(contextorBlob);
        }
        catch (WebContextorException e) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.debug((Object)("error in trying to get name of context session: " + (Object)((Object)e)));
            }
        }
        finally {
            this.contextorBlobString = contextorBlob[0];
        }
        return name;
    }
}

