/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel.ccow;

import com.sentillion.sdkweb.webcontextor.ContextItem;
import com.sentillion.sdkweb.webcontextor.ContextItemCollection;
import com.sentillion.sdkweb.webcontextor.WebContextorException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class CommonContextMap {
    private static Logger logger = Logger.getLogger(CommonContextMap.class);
    private Map context;
    private ContextItemCollection contextItemCollection;
    public static final String VHA_CCOW_LOGON_TOKEN = "user.id.logon.vistatoken";
    public static final String VHA_CCOW_LOGON_NAME = "user.id.logon.vistaname";
    public static final String VHA_CCOW_LOGON_NAME_GENERIC = "user.co.name";
    public static final String VHA_CCOW_LOGON_VPID = "user.id.logon.vpid";
    public static final String VHA_CCOW_LOGON_DOMAIN = "user.id.logon.vistalogon";

    public CommonContextMap(ContextItemCollection collection) {
        this.contextItemCollection = collection;
        this.transform();
    }

    private void transform() {
        this.context = new HashMap();
        if (this.contextItemCollection != null) {
            int count = this.contextItemCollection.count();
            for (int j = 1; j <= count; ++j) {
                ContextItem contextItem = null;
                try {
                    contextItem = this.contextItemCollection.item(j);
                    this.context.put(contextItem.getName(), contextItem.getValue());
                    continue;
                }
                catch (WebContextorException e) {
                    if (!logger.isEnabledFor((Priority)Level.ERROR)) continue;
                    logger.debug((Object)("error retrieving context item: " + j + " error: " + (Object)((Object)e)));
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isEnabledFor((Priority)Level.ERROR)) continue;
                    logger.debug((Object)("error retrieving context item: " + j + " error: " + e));
                }
            }
        }
    }

    public String getContextItem(String name) {
        return (String)this.context.get(name);
    }
}

