/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel.ccow;

import gov.va.med.authentication.kernel.LoginUserInfoVO;
import gov.va.med.authentication.kernel.ccow.CommonContextMap;
import gov.va.med.authentication.kernel.ccow.CommonContextSession;
import gov.va.med.authentication.kernel.ccow.ContextManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class CcowEnv
implements Serializable {
    private static Logger logger = Logger.getLogger(CcowEnv.class);
    public static final String LOCATOR_SENT = "locatorAppletSent";
    public static final String CONTEXT_MANAGER_URL = "contextManagerUrl";
    public static final String CONTEXT_SESSIONS = "contextSessions";
    public static final String COMMON_CONTEXT = "currentCommonContext";
    public static final String THIS_CCOWENV = "authentication.kernel.ccow.ccowEnv";
    public static final String CONTEXT_PARTICIPANT_URL = "contextParticipantUrl";
    public static final String APPLICATION_NAME = "applicationName";
    public static final String APPLET_CODEBASE_URL = "appletCodebaseURL";
    public static final String LOGIN_USING_TOKEN = "loginUsingToken";
    public static final String ACTIVE_CONTEXT_SESSION = "activeContextSession";
    public static final String CLIENT_IP_ADDRESS = "clientIPAddr";
    private HttpSession httpSession;
    private Map env;

    private CcowEnv(HttpSession currentSession) {
        this.httpSession = currentSession;
        this.env = new HashMap();
        this.httpSession.setAttribute(THIS_CCOWENV, (Object)this);
    }

    public static CcowEnv getInstance(HttpServletRequest req) {
        CcowEnv instance = null;
        HttpSession session = req.getSession(false);
        if (session != null) {
            instance = CcowEnv.getInstance(session);
        }
        return instance;
    }

    public static CcowEnv getInstance(HttpSession session) {
        CcowEnv instance = null;
        if (session != null && (instance = (CcowEnv)session.getAttribute(THIS_CCOWENV)) == null) {
            instance = new CcowEnv(session);
        }
        return instance;
    }

    public void terminateContextSession() {
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)("terminating context sessions in CcowEnv: " + this));
        }
        ContextManager.abandonContext(this);
        this.httpSession.removeAttribute(THIS_CCOWENV);
    }

    public void setContextManagerURL(String url) {
        this.env.put(CONTEXT_MANAGER_URL, url);
    }

    public String getContextManagerURL() {
        return (String)this.env.get(CONTEXT_MANAGER_URL);
    }

    public void setContextParticipantURL(String url) {
        this.env.put(CONTEXT_PARTICIPANT_URL, url);
    }

    public String getContextParticipantURL() {
        return (String)this.env.get(CONTEXT_PARTICIPANT_URL);
    }

    public void setApplicationName(String app_name) {
        this.env.put(APPLICATION_NAME, app_name);
    }

    public String getApplicationName() {
        return (String)this.env.get(APPLICATION_NAME);
    }

    public boolean locatorSent() {
        String locatorSent = (String)this.env.get(LOCATOR_SENT);
        return locatorSent != null;
    }

    public void setLocatorSent() {
        this.env.put(LOCATOR_SENT, "");
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public void setLoginUserInfo(LoginUserInfoVO userInfo) {
        this.httpSession.setAttribute("gov.va.med.authentication.kernel.LoginUserInfo", (Object)userInfo);
    }

    public LoginUserInfoVO getLoginUserInfo() {
        return (LoginUserInfoVO)this.httpSession.getAttribute("gov.va.med.authentication.kernel.LoginUserInfo");
    }

    public void setAppletCodebaseURL(String url) {
        this.env.put(APPLET_CODEBASE_URL, url);
    }

    public String getAppletCodebaseURL() {
        return (String)this.env.get(APPLET_CODEBASE_URL);
    }

    public void setLoginUsingToken() {
        this.env.put(LOGIN_USING_TOKEN, "");
    }

    public boolean isLoginUsingToken() {
        String loginUsingToken = (String)this.env.get(LOGIN_USING_TOKEN);
        return loginUsingToken != null;
    }

    public void setNotLoginUsingToken() {
        this.env.remove(LOGIN_USING_TOKEN);
    }

    public void setActiveContextSession(CommonContextSession ctxSession) {
        this.env.put(ACTIVE_CONTEXT_SESSION, ctxSession);
    }

    public CommonContextSession getActiveContextSession() {
        return (CommonContextSession)this.env.get(ACTIVE_CONTEXT_SESSION);
    }

    public void setContextSessions(Map sessions) {
        this.env.put(CONTEXT_SESSIONS, sessions);
    }

    public Map getContextSessions() {
        HashMap sessions = (HashMap)this.env.get(CONTEXT_SESSIONS);
        if (sessions == null) {
            sessions = new HashMap();
        }
        return sessions;
    }

    public void setCurrentCommonContext(CommonContextMap vaContext) {
        this.env.put(COMMON_CONTEXT, vaContext);
    }

    public CommonContextMap getCurrentCommonContext() {
        return (CommonContextMap)this.env.get(COMMON_CONTEXT);
    }

    public void setClientIPAddr(String clientIPAddr) {
        this.env.put(CLIENT_IP_ADDRESS, clientIPAddr);
    }

    public String getClientIPAddr() {
        return (String)this.env.get(CLIENT_IP_ADDRESS);
    }
}

