/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel;

import gov.va.med.authentication.kernel.KaajeeException;
import gov.va.med.authentication.kernel.LoginControllerUtils;
import gov.va.med.authentication.kernel.LoginUserInfoVO;
import gov.va.med.authentication.kernel.LoginUserInfoVOAssembler;
import gov.va.med.vistalink.adapter.cci.VistaLinkAppProxyConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkDuzConnectionSpec;
import gov.va.med.vistalink.rpc.RpcRequest;
import gov.va.med.vistalink.rpc.RpcRequestFactory;
import gov.va.med.vistalink.rpc.RpcResponse;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class VistALogon {
    private static final Logger logger = Logger.getLogger(VistALogon.class);

    public static LoginUserInfoVO getLoginUserInfo(String vistaToken, String institution, String clientIp) throws KaajeeException {
        LoginUserInfoVO userInfo = null;
        VistaLinkAppProxyConnectionSpec connSpec = new VistaLinkAppProxyConnectionSpec(institution, "KAAJEE,PROXY");
        VistaLinkConnection conn = LoginControllerUtils.getVistaLinkConnection((String)institution, (VistaLinkConnectionSpec)connSpec);
        userInfo = LoginUserInfoVOAssembler.getLoginUserInfoCCOW(conn, institution, clientIp, vistaToken);
        if (userInfo == null) {
            throw new KaajeeException("no LoginUserInfoVo fount");
        }
        return userInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getKernelCcowToken(String institution, String duz, String clientIP) {
        VistaLinkConnection myConnection = null;
        VistaLinkDuzConnectionSpec duzConnSpec = null;
        String ccowToken = null;
        try {
            duzConnSpec = new VistaLinkDuzConnectionSpec(institution, duz);
            myConnection = LoginControllerUtils.getVistaLinkConnection((String)institution, (VistaLinkConnectionSpec)duzConnSpec);
            ccowToken = VistALogon.getKernelCcowToken(myConnection, clientIP);
        }
        catch (Exception e) {
            try {
                if (logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.debug((Object)"failed to obtain ccowToken");
                }
                ccowToken = null;
            }
            catch (Throwable throwable) {
                LoginControllerUtils.closeVistaLinkConnection(myConnection);
                throw throwable;
            }
            LoginControllerUtils.closeVistaLinkConnection((VistaLinkConnection)myConnection);
        }
        LoginControllerUtils.closeVistaLinkConnection((VistaLinkConnection)myConnection);
        return ccowToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSecureCcowPasscode(String institution, String duz) {
        VistaLinkConnection myConnection = null;
        VistaLinkDuzConnectionSpec duzConnSpec = null;
        String ccowpasscode = null;
        try {
            duzConnSpec = new VistaLinkDuzConnectionSpec(institution, duz);
            myConnection = LoginControllerUtils.getVistaLinkConnection((String)institution, (VistaLinkConnectionSpec)duzConnSpec);
            ccowpasscode = VistALogon.getSecureCcowPasscode(myConnection);
        }
        catch (Exception e) {
            try {
                if (logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.debug((Object)"failed to obtain ccowpasscode");
                }
                ccowpasscode = null;
            }
            catch (Throwable throwable) {
                LoginControllerUtils.closeVistaLinkConnection(myConnection);
                throw throwable;
            }
            LoginControllerUtils.closeVistaLinkConnection((VistaLinkConnection)myConnection);
        }
        LoginControllerUtils.closeVistaLinkConnection((VistaLinkConnection)myConnection);
        return ccowpasscode;
    }

    private static String getKernelCcowToken(VistaLinkConnection myConnection, String clientIP) {
        RpcRequest vReq = null;
        RpcResponse vResp = null;
        String rVal = "";
        logger.debug((Object)"START getKernelCcowToken.");
        try {
            vReq = RpcRequestFactory.getRpcRequest();
            vReq.setRpcContext("XUS KAAJEE WEB LOGON");
            vReq.setRpcClientTimeOut(600);
            vReq.setTimeOut(5000);
            vReq.setUseProprietaryMessageFormat(true);
            vReq.setRpcName("XUS KAAJEE GET CCOW TOKEN");
            vReq.getParams().setParam(1, "string", (Object)clientIP);
            vResp = myConnection.executeRPC(vReq);
            rVal = vResp.getResults();
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to retrieve Kernel CCOW token. XUS GET CCOW TOKEN", (Throwable)ex);
        }
        logger.debug((Object)("kernelccowtoken = [" + rVal + "]"));
        logger.debug((Object)"END getKernelCcowToken.");
        return rVal;
    }

    private static String getSecureCcowPasscode(VistaLinkConnection myConnection) {
        RpcRequest vReq = null;
        RpcResponse vResp = null;
        String returnVal = "";
        logger.debug((Object)"START getSecureCcowPasscode.");
        try {
            vReq = RpcRequestFactory.getRpcRequest();
            vReq.setRpcContext("XUS SIGNON");
            vReq.setRpcClientTimeOut(600);
            vReq.setTimeOut(5000);
            vReq.setUseProprietaryMessageFormat(true);
            vReq.setRpcName("XUS CCOW VAULT PARAM");
            vResp = myConnection.executeRPC(vReq);
            StringTokenizer st = new StringTokenizer(vResp.getResults(), "\n");
            if (st.countTokens() == 2) {
                returnVal = st.nextToken() + st.nextToken();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Failed to retrieve CCOW passcode. XUS GET CCOW TOKEN", (Throwable)ex);
        }
        logger.debug((Object)"END getSecureCcowPasscode.");
        return returnVal;
    }
}

