/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel;

import gov.va.med.authentication.kernel.ApplicationRoleListVOSingleton;
import gov.va.med.authentication.kernel.KaajeeException;
import gov.va.med.authentication.kernel.LoginControllerUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.rpc.RpcRequest;
import gov.va.med.vistalink.rpc.RpcRequestFactory;
import gov.va.med.vistalink.rpc.RpcResponse;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

class RoleUtils {
    private static final Logger LOGGER = Logger.getLogger(RoleUtils.class);

    RoleUtils() {
    }

    static void cacheRoles(String username, VistaLinkConnection myConnection, ApplicationRoleListVOSingleton roleListVO) throws KaajeeException {
        ArrayList<String> userRoleListFromM = new ArrayList<String>();
        try {
            String rpcName = "XUS ALLKEYS";
            RpcRequest vReq = RpcRequestFactory.getRpcRequest();
            vReq.setUseProprietaryMessageFormat(true);
            vReq.setRpcContext("XUS KAAJEE WEB LOGON");
            vReq.setRpcClientTimeOut(600);
            vReq.setRpcName(rpcName);
            RpcResponse vResp = myConnection.executeRPC(vReq);
            String results = vResp.getResults();
            if (LOGGER.isEnabledFor((Priority)Level.DEBUG)) {
                LOGGER.debug((Object)("results of XUS KEY CHECK: " + results));
            }
            StringTokenizer st = new StringTokenizer(results, "\n");
            String keyname = "";
            while (st.hasMoreTokens()) {
                keyname = st.nextToken();
                userRoleListFromM.add(keyname);
                if (!LOGGER.isEnabledFor((Priority)Level.DEBUG)) continue;
                StringBuffer sb = new StringBuffer("Adding role '");
                sb.append(keyname);
                sb.append("' to role cache for username '");
                sb.append(username);
                sb.append("'.");
                LOGGER.debug((Object)sb.toString());
            }
        }
        catch (FoundationsException e) {
            if (LOGGER.isEnabledFor((Priority)Level.ERROR)) {
                LOGGER.error((Object)"Could not retrieve roles.");
            }
            throw new KaajeeException((Exception)((Object)e));
        }
        for (int i = 0; i < userRoleListFromM.size(); ++i) {
            LoginControllerUtils.addMemberToGroup((String)username, (String)userRoleListFromM.get(i).toString());
            if (!LOGGER.isEnabledFor((Priority)Level.DEBUG)) continue;
            StringBuffer sb = new StringBuffer("Adding group '");
            sb.append((String)userRoleListFromM.get(i));
            sb.append("' roles for this username in groupmembers'");
            sb.append(username);
            sb.append("'.");
            sb.append(userRoleListFromM.get(i).toString());
            LOGGER.debug((Object)sb.toString());
        }
    }
}

