/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel;

import gov.va.med.authentication.kernel.KaajeeException;
import gov.va.med.authentication.kernel.LoginControllerUtils;
import gov.va.med.exception.FoundationsException;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkDuzConnectionSpec;
import gov.va.med.vistalink.adapter.record.VistaLinkFaultException;
import gov.va.med.vistalink.rpc.RpcRequest;
import gov.va.med.vistalink.rpc.RpcRequestFactory;
import gov.va.med.vistalink.rpc.RpcResponse;
import javax.resource.ResourceException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LogoutController {
    private static Logger logger = Logger.getLogger(LogoutController.class);
    private static final String LOGOUT_RPC_NAME = "XUS KAAJEE LOGOUT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void performLogoutActions(String signonLogIen, String duz, String loginDivisionStationNumber) {
        VistaLinkConnection myConnection = null;
        if (signonLogIen.length() < 1 | duz.length() < 1 | loginDivisionStationNumber.length() < 1) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                StringBuffer sb = new StringBuffer("Signon IEN, DUZ or Login station # missing. Not able to mark signon log as signed off, for Duz '");
                sb.append(duz);
                sb.append("', login station # '");
                sb.append(loginDivisionStationNumber);
                sb.append("', and signon log IEN '");
                sb.append(signonLogIen);
                sb.append("'.");
                logger.error((Object)sb.toString());
            }
        } else {
            VistaLinkDuzConnectionSpec duzConnSpec = new VistaLinkDuzConnectionSpec(loginDivisionStationNumber, duz);
            try {
                myConnection = LoginControllerUtils.getVistaLinkConnection((String)loginDivisionStationNumber, (VistaLinkConnectionSpec)duzConnSpec);
                RpcRequest vReq = RpcRequestFactory.getRpcRequest();
                vReq.setRpcContext("XUS KAAJEE WEB LOGON");
                vReq.setRpcClientTimeOut(600);
                vReq.setUseProprietaryMessageFormat(true);
                vReq.setRpcName(LOGOUT_RPC_NAME);
                vReq.getParams().setParam(1, "string", (Object)signonLogIen);
                RpcResponse vResp = myConnection.executeRPC(vReq);
                vResp.getResults();
                if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                    StringBuffer sb = new StringBuffer("Executed RPC to mark signon log at station #'");
                    sb.append(loginDivisionStationNumber);
                    sb.append("' for user DUZ '");
                    sb.append(duz);
                    sb.append("' logged off for signon log IEN '");
                    sb.append(signonLogIen);
                    sb.append("'.");
                    logger.debug((Object)sb.toString());
                }
            }
            catch (VistaLinkFaultException e) {
                if (logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.error((Object)"Error marking VistA-side signon log as signed off", (Throwable)e);
                }
            }
            catch (KaajeeException e) {
                if (logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.error((Object)"Error marking VistA-side signon log as signed off", (Throwable)((Object)e));
                }
            }
            catch (FoundationsException e) {
                if (logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.error((Object)"Error marking VistA-side signon log as signed off", (Throwable)e);
                }
            }
            finally {
                block27: {
                    try {
                        myConnection.close();
                    }
                    catch (ResourceException e1) {
                        if (!logger.isEnabledFor((Priority)Level.ERROR)) break block27;
                        logger.error((Object)"Could not close VistaLink Connection.");
                    }
                }
            }
        }
    }
}

