/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel;

import gov.va.med.authentication.kernel.CactusFormsAuthCredentialVO;
import gov.va.med.authentication.kernel.ConfigurationVO;
import gov.va.med.authentication.kernel.KaajeeException;
import gov.va.med.authentication.kernel.KaajeeVistaLinkConnectionSpec;
import gov.va.med.authentication.kernel.LoginControllerUtils;
import gov.va.med.authentication.kernel.LoginUserInfoVO;
import gov.va.med.authentication.kernel.LoginUserInfoVOAssembler;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnection;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionSpec;
import gov.va.med.vistalink.adapter.cci.VistaLinkDuzConnectionSpec;
import java.io.IOException;
import javax.security.auth.callback.CallbackHandler;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import weblogic.security.SimpleCallbackHandler;
import weblogic.servlet.security.ServletAuthentication;

public class LoginController
extends HttpServlet {
    private static Logger logger = Logger.getLogger(LoginController.class);
    private static final String FORM_INSTITUTION_FIELD_NAME = "institution";
    private static final String FORM_ACCESS_CODE_FIELD_NAME = "access";
    private static final String FORM_VERIFY_CODE_FIELD_NAME = "verify";
    private static final String FORM_SORT_INSTITUTION_BY_FIELD_NAME = "sortInstBy";
    private static final String FORM_SUBMIT_FIELD_NAME = "submit";
    private static final String SESSION_KEY_ACCESS = "gov.va.med.authentication.kernel.access";
    private static final String SESSION_KEY_VERIFY = "gov.va.med.authentication.kernel.verify";
    private static final String SESSION_KEY_DIVISION = "gov.va.med.authentication.kernel.division";
    private static final String SESSION_KEY_ERROR_MESSAGE = "gov.va.med.authentication.kernel.errormessage";
    private static final int COOKIE_EXPIRY_DAYS = 180;
    static final String LOGIN_RPC_CONTEXT = "XUS KAAJEE WEB LOGON";
    public static final String SESSION_KEY_COOKIE_DEFAULT_DIVISION = "gov.va.med.authentication.kernel.cookieDivision";
    public static final String COOKIE_DEFAULT_DIVISION_STRING = "gov.va.med.authentication.kernel.defaultDivision";
    public static final String SESSION_KEY_COOKIE_DEFAULT_SORT_INSTITUTION_BY = "gov.va.med.authentication.kernel.cookieSortInstitutionBy";
    public static final String COOKIE_DEFAULT_SORT_INSTITUTION_BY_STRING = "gov.va.med.authentication.kernel.defaultSortInstitutionBy";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.routeRequest(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.routeRequest(request, response);
    }

    private void routeRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String formVerifyValue;
        String formAccessValue;
        HttpSession session;
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)("In doPage. Client host: " + request.getRemoteAddr()));
        }
        if ((session = request.getSession(false)) == null) {
            session = request.getSession(true);
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/login/SessionTimeout.jsp");
            rd.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        session.removeAttribute(SESSION_KEY_ERROR_MESSAGE);
        String formInstitutionValue = request.getParameter(FORM_INSTITUTION_FIELD_NAME);
        String formAvPairValue = request.getParameter(FORM_ACCESS_CODE_FIELD_NAME);
        if (formAvPairValue != null && formAvPairValue.indexOf(59) > -1) {
            String[] formAvArray = formAvPairValue.split(";");
            formAccessValue = formAvArray[0];
            formVerifyValue = formAvArray[1];
        } else {
            formAccessValue = formAvPairValue;
            formVerifyValue = request.getParameter(FORM_VERIFY_CODE_FIELD_NAME);
        }
        String formSortInstitutionByValue = request.getParameter(FORM_SORT_INSTITUTION_BY_FIELD_NAME);
        String formSubmitValue = request.getParameter(FORM_SUBMIT_FIELD_NAME);
        String sessionInstitutionValue = (String)session.getAttribute(SESSION_KEY_DIVISION);
        String sessionAccessValue = (String)session.getAttribute(SESSION_KEY_ACCESS);
        String sessionVerifyValue = (String)session.getAttribute(SESSION_KEY_VERIFY);
        LoginUserInfoVO sessionUserInfo = (LoginUserInfoVO)session.getAttribute("gov.va.med.authentication.kernel.LoginUserInfo");
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)("formSortInstitutionByValue = " + formSortInstitutionByValue));
            logger.debug((Object)("formSubmitValue = " + formSubmitValue));
            logger.debug((Object)("LoginUserInfoVO from ccow validation = " + sessionUserInfo));
        }
        if (sessionUserInfo != null) {
            this.processCredentialsAndLogIn(request, response, sessionInstitutionValue, sessionAccessValue, sessionVerifyValue);
            return;
        }
        if (sessionAccessValue != null && sessionVerifyValue != null && sessionInstitutionValue != null) {
            session.removeAttribute(SESSION_KEY_ACCESS);
            session.removeAttribute(SESSION_KEY_VERIFY);
            session.removeAttribute(SESSION_KEY_DIVISION);
            this.processCredentialsAndLogIn(request, response, sessionInstitutionValue, sessionAccessValue, sessionVerifyValue);
        } else if (this.cookieNeedToBeUpdated(request, response, session, formInstitutionValue, formAccessValue, formVerifyValue, formSortInstitutionByValue)) {
            StringBuffer sb = new StringBuffer(request.getContextPath());
            sb.append("/LoginController");
            logger.debug((Object)("About to redirect to write persistent cookie, to: " + sb.toString()));
            response.sendRedirect(sb.toString());
        } else {
            this.processCredentialsAndLogIn(request, response, formInstitutionValue, formAccessValue, formVerifyValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCredentialsAndLogIn(HttpServletRequest request, HttpServletResponse response, String institution, String access, String verify) throws ServletException, IOException {
        String jUsername = null;
        String jPassword = null;
        VistaLinkConnection myConnection = null;
        LoginUserInfoVO userInfo = null;
        HttpSession session = request.getSession(true);
        String clientIp = request.getRemoteAddr();
        try {
            userInfo = (LoginUserInfoVO)session.getAttribute("gov.va.med.authentication.kernel.LoginUserInfo");
            if (userInfo != null) {
                logger.debug((Object)"ccow");
                String loginStationNumber = userInfo.getLoginStationNumber();
                String duz = userInfo.getUserDuz();
                VistaLinkDuzConnectionSpec connSpec = new VistaLinkDuzConnectionSpec(loginStationNumber, duz);
                myConnection = LoginControllerUtils.getVistaLinkConnection((String)loginStationNumber, (VistaLinkConnectionSpec)connSpec);
            } else {
                logger.debug((Object)"1");
                LoginControllerUtils.checkFormInputValues((String)institution, (String)access, (String)verify);
                logger.debug((Object)"2");
                LoginControllerUtils.validateKaajeeLoginDivision((String)institution);
                logger.debug((Object)"3");
                KaajeeVistaLinkConnectionSpec avConnSpec = new KaajeeVistaLinkConnectionSpec(institution, access, verify, clientIp);
                myConnection = LoginControllerUtils.getVistaLinkConnection((String)institution, (VistaLinkConnectionSpec)avConnSpec);
                logger.debug((Object)"4");
                userInfo = LoginUserInfoVOAssembler.getLoginUserInfo(myConnection, institution, clientIp);
                session.setAttribute("gov.va.med.authentication.kernel.LoginUserInfo", (Object)userInfo);
            }
            logger.debug((Object)"5");
            jUsername = LoginControllerUtils.createJUsername((LoginUserInfoVO)userInfo);
            jPassword = LoginControllerUtils.createJPasswordForWebUser();
            LoginControllerUtils.createAuthenticateUser((String)jUsername, (String)jPassword);
            logger.debug((Object)"6");
            LoginControllerUtils.cacheUserRoles((String)jUsername, (VistaLinkConnection)myConnection);
            logger.debug((Object)"7");
            logger.debug((Object)"8");
            this.doUserManagerRedirect(request, response, jUsername, jPassword);
            LoginControllerUtils.closeVistaLinkConnection((VistaLinkConnection)myConnection);
        }
        catch (KaajeeException e) {
            String exceptionString = "Error processing login credentials: ";
            if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                logger.debug((Object)exceptionString, (Throwable)((Object)e));
            }
            this.doLoginErrorRedirect(request, response, exceptionString + e.getMessage());
        }
        finally {
            LoginControllerUtils.closeVistaLinkConnection(myConnection);
        }
    }

    public static CactusFormsAuthCredentialVO getFormsAuthCredentialsForCactus(String institution, String access, String verify, HttpSession session) throws KaajeeException {
        String jUsername = null;
        String jPassword = null;
        VistaLinkConnection myConnection = null;
        LoginUserInfoVO userInfo = null;
        CactusFormsAuthCredentialVO returnVal = null;
        String clientIp = "cactusTest";
        ConfigurationVO configVO = ConfigurationVO.getInstance();
        if (!configVO.getIsCactusModeEnabled()) {
            String exceptionString = "Warning: Attempt to use Cactus mode without that mode enabled in the KAAJEE configuration. Denying login attempt.";
            logger.error((Object)exceptionString);
            throw new KaajeeException(exceptionString);
        }
        try {
            LoginControllerUtils.checkFormInputValues((String)institution, (String)access, (String)verify);
            logger.debug((Object)"CactusFormsAuthCredentialVO: finished step 1");
            LoginControllerUtils.validateKaajeeLoginDivision((String)institution);
            logger.debug((Object)"CactusFormsAuthCredentialVO: finished step 2");
            KaajeeVistaLinkConnectionSpec avConnSpec = new KaajeeVistaLinkConnectionSpec(institution, access, verify, clientIp);
            myConnection = LoginControllerUtils.getVistaLinkConnection((String)institution, (VistaLinkConnectionSpec)avConnSpec);
            logger.debug((Object)"CactusFormsAuthCredentialVO: finished step 3");
            userInfo = LoginUserInfoVOAssembler.getLoginUserInfo(myConnection, institution, clientIp);
            if (session != null) {
                session.setAttribute("gov.va.med.authentication.kernel.LoginUserInfo", (Object)userInfo);
            }
            logger.debug((Object)"CactusFormsAuthCredentialVO: finished step 4");
            jUsername = LoginControllerUtils.createJUsername((LoginUserInfoVO)userInfo);
            jPassword = LoginControllerUtils.createJPasswordForCactus();
            logger.debug((Object)"CactusFormsAuthCredentialVO: finished step 5");
            LoginControllerUtils.cacheUserRoles((String)jUsername, (VistaLinkConnection)myConnection);
            logger.debug((Object)"CactusFormsAuthCredentialVO: finished step 6");
            LoginControllerUtils.createAuthenticateUser((String)jUsername, (String)jPassword);
            returnVal = new CactusFormsAuthCredentialVO(jUsername, jPassword);
            logger.debug((Object)"CactusFormsAuthCredentialVO: finished step 8");
        }
        catch (KaajeeException e) {
            try {
                String exceptionString = "Error processing Cactus/UnitTest login credentials: ";
                if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                    logger.debug((Object)exceptionString, (Throwable)((Object)e));
                }
                throw e;
            }
            catch (Throwable throwable) {
                LoginControllerUtils.closeVistaLinkConnection(myConnection);
                throw throwable;
            }
        }
        LoginControllerUtils.closeVistaLinkConnection((VistaLinkConnection)myConnection);
        return returnVal;
    }

    private boolean cookieNeedToBeUpdated(HttpServletRequest request, HttpServletResponse response, HttpSession session, String institution, String access, String verify, String sortInstitutionByValue) throws ServletException, IOException {
        boolean returnVal = false;
        String cookieDefaultDivision = (String)session.getAttribute(SESSION_KEY_COOKIE_DEFAULT_DIVISION);
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            StringBuffer sb = new StringBuffer("cookieDefaultDivision = ");
            sb.append(cookieDefaultDivision);
            sb.append("formInstitutionValue = ");
            sb.append(institution);
            sb.append("request.getRequestURI() = ");
            sb.append(request.getRequestURI());
            logger.debug((Object)sb.toString());
        }
        if (cookieDefaultDivision == null || !cookieDefaultDivision.equals(institution)) {
            Cookie institutionCookie = new Cookie(COOKIE_DEFAULT_DIVISION_STRING, institution);
            institutionCookie.setMaxAge(15552000);
            response.addCookie(institutionCookie);
            returnVal = true;
        }
        String cookieDefaultSortInstitutionBy = (String)session.getAttribute(SESSION_KEY_COOKIE_DEFAULT_SORT_INSTITUTION_BY);
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            StringBuffer sb = new StringBuffer("cookieDefaultSortInstitutionBy = ");
            sb.append(cookieDefaultSortInstitutionBy);
            sb.append("formSortInstitutionByValue = ");
            sb.append(sortInstitutionByValue);
            sb.append("request.getRequestURI() = ");
            sb.append(request.getRequestURI());
            logger.debug((Object)sb.toString());
        }
        if (cookieDefaultSortInstitutionBy == null || !cookieDefaultSortInstitutionBy.equals(sortInstitutionByValue)) {
            Cookie sortInstitutionByCookie = new Cookie(COOKIE_DEFAULT_SORT_INSTITUTION_BY_STRING, sortInstitutionByValue);
            sortInstitutionByCookie.setMaxAge(15552000);
            response.addCookie(sortInstitutionByCookie);
            returnVal = true;
        }
        if (returnVal) {
            session.setAttribute(SESSION_KEY_DIVISION, (Object)institution);
            session.setAttribute(SESSION_KEY_ACCESS, (Object)access);
            session.setAttribute(SESSION_KEY_VERIFY, (Object)verify);
        }
        return returnVal;
    }

    private void doUserManagerRedirect(HttpServletRequest request, HttpServletResponse response, String jUsername, String jPassword) throws ServletException, IOException {
        StringBuffer sb;
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)"in doUserManagerRedirect");
        }
        SimpleCallbackHandler callbackHandler = new SimpleCallbackHandler(jUsername, jPassword.getBytes());
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            StringBuffer sb2 = new StringBuffer("About to call ServletAuthentication.authenticate API ");
            sb2.append("to authenticate user: '");
            sb2.append(jUsername);
            sb2.append("'.");
            logger.debug((Object)sb2.toString());
        }
        int result = ServletAuthentication.authenticate((CallbackHandler)callbackHandler, (HttpServletRequest)request);
        String targetURL = ServletAuthentication.getTargetURLForFormAuthentication((HttpSession)request.getSession());
        if (result == 0) {
            if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                sb = new StringBuffer("Succesfully Authenticated");
                logger.debug((Object)sb.toString());
            }
        } else if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            sb = new StringBuffer("Authentication Failed ! ! !");
            logger.debug((Object)sb.toString());
        }
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            sb = new StringBuffer("targetURL = ");
            sb.append(targetURL);
            logger.debug((Object)sb.toString());
        }
        if (result == 0) {
            response.sendRedirect(targetURL);
        } else {
            response.sendRedirect("/login/loginerror.jsp");
        }
    }

    private void doLoginErrorRedirect(HttpServletRequest request, HttpServletResponse response, String errorMessage) throws ServletException, IOException {
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)"in doLoginErrorRedirect");
        }
        HttpSession session = request.getSession(true);
        session.removeAttribute(SESSION_KEY_ACCESS);
        session.removeAttribute(SESSION_KEY_VERIFY);
        session.removeAttribute(SESSION_KEY_DIVISION);
        session.removeAttribute("gov.va.med.authentication.kernel.LoginUserInfo");
        session.removeAttribute(SESSION_KEY_COOKIE_DEFAULT_DIVISION);
        session.setAttribute(SESSION_KEY_ERROR_MESSAGE, (Object)errorMessage);
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/login/loginerrordisplay.jsp");
        if (rd == null) {
            String exceptionMessage = "Could not retrieve RequestDispatcher for /login/loginerrordisplay.jsp.";
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                logger.error((Object)exceptionMessage);
            }
            throw new ServletException(exceptionMessage);
        }
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }
}

