/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel;

import gov.va.med.crypto.VistaKernelHash;
import gov.va.med.crypto.VistaKernelHashCountLimitExceededException;
import gov.va.med.vistalink.adapter.cci.VistaLinkConnectionSpecImpl;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KaajeeVistaLinkConnectionSpec
extends VistaLinkConnectionSpecImpl {
    private static final String TYPE_AV = "av";
    private static final String ELEMENT_AV = "AccessVerify";
    private static final String ATTRIBUTE_AVCODE = "avCode";
    private String accessCode;
    private String verifyCode;
    private String clientIp;
    private String avCode;
    private static Logger logger = Logger.getLogger(KaajeeVistaLinkConnectionSpec.class);

    public KaajeeVistaLinkConnectionSpec(String division, String accessCode, String verifyCode, String clientIp) {
        super(division);
        this.accessCode = accessCode;
        this.verifyCode = verifyCode;
        this.clientIp = clientIp;
        this.avCode = "";
        try {
            this.avCode = VistaKernelHash.encrypt((String)(accessCode + ";" + verifyCode + ";" + clientIp), (boolean)true);
        }
        catch (VistaKernelHashCountLimitExceededException e) {
            logger.error((Object)"Could not encrypt access/verify code", (Throwable)e);
        }
    }

    public ArrayList getProprietarySecurityInfo() {
        ArrayList<String> values = new ArrayList<String>();
        values.add(this.avCode);
        return values;
    }

    public void setAuthenticationNodes(Document requestDoc, Node securityNode) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"setAuthenticationNodes -> Re Auth type is 'av'");
        }
        this.setSecurityDivisionAttr(securityNode);
        this.setSecurityTypeAttr(securityNode);
        Element elemAV = requestDoc.createElement(ELEMENT_AV);
        CDATASection cdata = requestDoc.createCDATASection(this.avCode);
        Node currentAvCdataNode = elemAV.getFirstChild();
        if (currentAvCdataNode != null) {
            elemAV.removeChild(currentAvCdataNode);
        }
        elemAV.appendChild(cdata);
        securityNode.appendChild(elemAV);
    }

    public boolean isConnSpecEqual(Object obj) {
        return this.equals(obj);
    }

    public boolean equals(Object obj) {
        KaajeeVistaLinkConnectionSpec connSpec;
        return obj instanceof KaajeeVistaLinkConnectionSpec && (connSpec = (KaajeeVistaLinkConnectionSpec)((Object)obj)).getDivision().equals(this.getDivision()) && connSpec.getAccessCode().equals(this.getAccessCode()) && connSpec.getVerifyCode().equals(this.getVerifyCode()) && connSpec.getClientIp().equals(this.getClientIp());
    }

    public int hashCode() {
        int HASHCODE_SEED;
        int returnVal = HASHCODE_SEED = 17;
        int divisionHashCode = this.getDivision().hashCode();
        returnVal = 37 * returnVal + divisionHashCode;
        int accessHashCode = this.getAccessCode().hashCode();
        returnVal = 37 * returnVal + accessHashCode;
        int verifyHashCode = this.getVerifyCode().hashCode();
        returnVal = 37 * returnVal + verifyHashCode;
        int clientIPHashCode = this.getClientIp().hashCode();
        returnVal = 37 * returnVal + clientIPHashCode;
        return returnVal;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getAccessCode() {
        return this.accessCode;
    }

    public String getVerifyCode() {
        return this.verifyCode;
    }

    public String getSecurityType() {
        return TYPE_AV;
    }
}

