/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel;

import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class KaajeeSSLHelper {
    private static Logger logger = Logger.getLogger(KaajeeSSLHelper.class);
    private static final String MBEANSERVER_JNDI_ENV_CONTEXT = "java:comp/env/jmx/runtime";
    private static final String MBEANSERVER_JNDI_CONTEXT = "java:comp/jmx/runtime";
    private static final String JMX_DOMAIN_FOR_PLATFORM = "com.bea";
    private int ListenPort = -1;
    private int SSLListenPort = -1;
    private boolean SSLListenPortEnabled = false;
    private boolean initialized = false;

    public KaajeeSSLHelper() {
        try {
            this.initialize();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void updateValues() throws Exception {
        this.initialized = false;
        this.initialize();
    }

    private void initialize() throws Exception {
        try {
            MBeanServer localMBeanServer = this.getLocalMBeanServer();
            ObjectName oNamePartial = new ObjectName("com.bea:Type=ServerRuntime,*");
            Set<ObjectName> queryResults = localMBeanServer.queryNames(oNamePartial, null);
            if (queryResults.size() != 1) {
                logger.error((Object)("Expected 1 result for local server query, got: " + queryResults.size()));
            } else {
                ObjectName serverObjectName = queryResults.iterator().next();
                Integer lp = (Integer)localMBeanServer.getAttribute(serverObjectName, "ListenPort");
                this.ListenPort = lp;
                Integer sslP = (Integer)localMBeanServer.getAttribute(serverObjectName, "SSLListenPort");
                this.SSLListenPort = sslP;
                Boolean sslEnabled = (Boolean)localMBeanServer.getAttribute(serverObjectName, "SSLListenPortEnabled");
                this.SSLListenPortEnabled = sslEnabled;
            }
            this.initialized = true;
        }
        catch (MalformedObjectNameException e) {
            logger.error((Object)"Failure retrieving ServerRuntime MBean values: ", (Throwable)e);
            throw new Exception("Encountered problem while retrieving ServerRuntime MBean values", e);
        }
        catch (AttributeNotFoundException e) {
            logger.error((Object)"Failure retrieving ServerRuntime MBean values: ", (Throwable)e);
            throw new Exception("Encountered problem while retrieving ServerRuntime MBean values", e);
        }
        catch (InstanceNotFoundException e) {
            logger.error((Object)"Failure retrieving ServerRuntime MBean values: ", (Throwable)e);
            throw new Exception("Encountered problem while retrieving ServerRuntime MBean values", e);
        }
        catch (NullPointerException e) {
            logger.error((Object)"Failure retrieving ServerRuntime MBean values: ", (Throwable)e);
            throw new Exception("Encountered problem while retrieving ServerRuntime MBean values", e);
        }
        catch (MBeanException e) {
            logger.error((Object)"Failure retrieving ServerRuntime MBean values: ", (Throwable)e);
            throw new Exception("Encountered problem while retrieving ServerRuntime MBean values", e);
        }
        catch (ReflectionException e) {
            logger.error((Object)"Failure retrieving ServerRuntime MBean values: ", (Throwable)e);
            throw new Exception("Encountered problem while retrieving ServerRuntime MBean values", e);
        }
        catch (NamingException e) {
            throw new Exception("Encountered problem while retrieving ServerRuntime MBean values", e);
        }
    }

    public synchronized int getListenPort() throws Exception {
        if (!this.initialized) {
            this.initialize();
        }
        return this.ListenPort;
    }

    public synchronized int getSSLListenPort() throws Exception {
        if (!this.initialized) {
            this.initialize();
        }
        return this.SSLListenPort;
    }

    public synchronized boolean isSSLListenPortEnabled() throws Exception {
        if (!this.initialized) {
            this.initialize();
        }
        return this.SSLListenPortEnabled;
    }

    private MBeanServer getLocalMBeanServer() throws NamingException {
        logger.debug((Object)"in getLocalMBeanServer");
        MBeanServer returnVal = null;
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            try {
                returnVal = (MBeanServer)ctx.lookup(MBEANSERVER_JNDI_ENV_CONTEXT);
            }
            catch (NameNotFoundException e) {
                try {
                    returnVal = (MBeanServer)ctx.lookup(MBEANSERVER_JNDI_CONTEXT);
                }
                catch (NameNotFoundException e1) {
                    logger.error((Object)"Could not retrieve local MBeanServer: ", (Throwable)e1);
                    throw e;
                }
            }
        }
        catch (NamingException e) {
            logger.error((Object)"Could not get initial context: ", (Throwable)e);
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e1) {
                    logger.error((Object)"Could not close InitialContext: ", (Throwable)e1);
                }
            }
            throw e;
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException e) {
                logger.error((Object)"error closing JNDI context", (Throwable)e);
            }
        }
        return returnVal;
    }
}

