/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel;

import gov.va.med.authentication.kernel.LoginControllerUtils;
import gov.va.med.authentication.kernel.StartupController;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class InitKaajeeServlet
extends HttpServlet {
    private static Logger logger = Logger.getLogger(InitKaajeeServlet.class);
    public static final String CONFIG_FILE_PARAM_NAME = "kaajee-config-file-location";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        this.CheckForAuthenticator();
        InputStream configFileStream = null;
        String configFileLocation = this.getInitParameter(CONFIG_FILE_PARAM_NAME);
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)("Config File Location: " + configFileLocation));
        }
        if (configFileLocation == null) {
            if (logger.isEnabledFor((Priority)Level.ERROR)) {
                StringBuffer sb = new StringBuffer("KAAJEE configuration file location '");
                sb.append(configFileLocation);
                sb.append("' is null; can't retrieve KAAJEE settings.");
                logger.error((Object)sb.toString());
            }
        } else {
            if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                StringBuffer sb = new StringBuffer("about to try to retrieve '");
                sb.append(configFileLocation);
                sb.append("'");
                logger.debug((Object)sb.toString());
            }
            try {
                configFileStream = this.getServletContext().getResourceAsStream(configFileLocation);
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document configDocument = builder.parse(configFileStream);
                StartupController.doStartup(configDocument);
            }
            catch (FactoryConfigurationError e) {
                logger.error((Object)"Problem reading configuration file.", (Throwable)e);
            }
            catch (ParserConfigurationException e) {
                logger.error((Object)"Problem reading configuration file.", (Throwable)e);
            }
            catch (SAXException e) {
                logger.error((Object)"Problem reading configuration file.", (Throwable)e);
            }
            catch (IOException e) {
                logger.error((Object)"Problem reading configuration file.", (Throwable)e);
            }
            finally {
                block29: {
                    try {
                        configFileStream.close();
                    }
                    catch (IOException e) {
                        if (!logger.isEnabledFor((Priority)Level.ERROR)) break block29;
                        logger.error((Object)"Problem closing input stream for KAAJEE configuration file.", (Throwable)e);
                    }
                }
            }
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.CheckForAuthenticator();
        this.displayInfo(response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        this.CheckForAuthenticator();
        this.displayInfo(response);
    }

    private void displayInfo(HttpServletResponse response) {
        block2: {
            try {
                PrintWriter out = response.getWriter();
                out.println("InitKaajeeServlet");
            }
            catch (IOException e) {
                if (!logger.isEnabledFor((Priority)Level.ERROR)) break block2;
                logger.error((Object)"Could not get a PrintWriter to display output.", (Throwable)e);
            }
        }
    }

    private void CheckForAuthenticator() throws ServletException {
        InitialContext ctx = null;
        ObjectName authenticator = null;
        try {
            ctx = new InitialContext();
            MBeanServer mbs = (MBeanServer)ctx.lookup("java:comp/env/jmx/runtime");
            authenticator = LoginControllerUtils.getKaajeeAuthenticator((MBeanServer)mbs);
        }
        catch (Exception ex) {
            logger.error((Object)"Error finding KaajeeManageableAuthenticator in MBeanServer", (Throwable)ex);
            throw new ServletException("Error finding KaajeeManageableAuthenticator in MBeanServer");
        }
        finally {
            try {
                ctx.close();
            }
            catch (NamingException e) {
                logger.error((Object)"Error closing context: ", (Throwable)e);
            }
        }
        if (authenticator == null) {
            throw new ServletException("Error, KaajeeManageableAuthenticator doesn't exist in security realm");
        }
    }
}

