/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.authentication.kernel;

import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ApplicationRoleListVOSingleton {
    private static ApplicationRoleListVOSingleton me;
    private static Logger logger;
    private ArrayList roleList;
    private static Object syncObj;

    private ApplicationRoleListVOSingleton(Document configDoc) {
        this.roleList = this.getRoleList(configDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ApplicationRoleListVOSingleton getInstance() throws IllegalStateException {
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)"In getInstance().");
        }
        Object object = syncObj;
        synchronized (object) {
            if (me == null) {
                String exceptionString = "ApplicationRoleListVOSingleton not initialized.";
                if (logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.error((Object)exceptionString);
                }
                throw new IllegalStateException(exceptionString);
            }
            return me;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void createInstance(Document configDoc) throws IllegalStateException {
        if (logger.isEnabledFor((Priority)Level.DEBUG)) {
            logger.debug((Object)"In createInstance().");
        }
        Object object = syncObj;
        synchronized (object) {
            if (me == null) {
                if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                    logger.debug((Object)"Creating new singleton instance.");
                }
            } else {
                String exceptionString = "ApplicationRoleListVOSingleton already initialized.";
                if (logger.isEnabledFor((Priority)Level.ERROR)) {
                    logger.error((Object)exceptionString);
                }
                throw new IllegalStateException(exceptionString);
            }
            me = new ApplicationRoleListVOSingleton(configDoc);
        }
    }

    private ArrayList getRoleList(Document configDoc) {
        ArrayList<String> roleList = new ArrayList<String>();
        NodeList groupsNodeList = configDoc.getElementsByTagName("groups");
        for (int i = 0; i < groupsNodeList.getLength(); ++i) {
            NodeList groupNodeList = groupsNodeList.item(i).getChildNodes();
            block1: for (int j = 0; j < groupNodeList.getLength(); ++j) {
                if (!"group".equals(groupNodeList.item(j).getNodeName())) continue;
                Node groupNode = groupNodeList.item(j);
                NamedNodeMap attributes = groupNode.getAttributes();
                for (int k = 0; k < attributes.getLength(); ++k) {
                    Attr attr = (Attr)attributes.item(k);
                    if (!"name".equals(attr.getName())) continue;
                    if (logger.isEnabledFor((Priority)Level.DEBUG)) {
                        logger.debug((Object)("retrieved role from kaajee configuration file: " + attr.getValue()));
                    }
                    roleList.add(attr.getValue());
                    continue block1;
                }
            }
        }
        return roleList;
    }

    ArrayList getRoleList() {
        return this.roleList;
    }

    static {
        logger = Logger.getLogger(ApplicationRoleListVOSingleton.class);
        syncObj = new Object();
    }
}

