<%@ include file="/jsp/init.jsp" %>

<c:set var="cssClass" value="can-clear" />

<aui:script use="node" >
	A.one('#<portlet:namespace/>STIPEND_CALCULATOR').on(
      'click',
      function(e) {	
    	  calculateStipend();
      }
    );
</aui:script>

<div class="yui3-skin-sam">
	<div id="modalTransferStipend"></div>
</div>


<div class="hidden-element">
<portlet:actionURL var="calculateStipend">
	<portlet:param name="javax.portlet.action" value="doAction"/>
	<portlet:param name="action" value="calculateStipend"/>
</portlet:actionURL>
<div id="stipendCalculator" style="display:none;">
	<c:set var="cssClass" value="can-clear" />
	<aui:form action="${calculateStipend}" method="post" name="stipendCalculator">
	<div class="stipendPopup">
	<div id = "stipendError">
		<h5 id="<portlet:namespace/>stipendError"></h5>
	</div>
	
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="true" last="false" cssClass="manage-layout ${cssClass}"  >
			<aui:input label="zip" name="zip" id="zip" value="" size="10" onkeydown="if (event.keyCode == 13) { calculate(); return false; }"></aui:input>
		</aui:field-wrapper>
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}"  >
			<aui:select label="tier-level" name="tier" id="tier" onchange="calculate()">
				<aui:option value="10" label="tier1" />
				<aui:option value="25" label="tier2" />
				<aui:option value="40" label="tier3" />
			</aui:select>
		</aui:field-wrapper>
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="true" cssClass="manage-layout ${cssClass}"  >
			<aui:input label="stipendhours" name="stipendhours" id="stipendhours" value="" readonly="true" ></aui:input>
		</aui:field-wrapper>
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="true" last="false" cssClass="manage-layout ${cssClass}"  >
			<aui:input label="times4" name="times4" id="times4" value="" readonly="true"></aui:input>
		</aui:field-wrapper>
		
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}" >
			<aui:input label="local-hourly-wage" name="wage" id="wage" value="" readonly="true" ></aui:input>
		</aui:field-wrapper>
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="true" cssClass="manage-layout ${cssClass}" >
			<aui:input label="monthly-stipend-amount" name="stipend" id="stipend" value="" readonly="true"></aui:input>
		</aui:field-wrapper>
	
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="true" last="false" cssClass="manage-layout ${cssClass}"  >
			<aui:input label="bls-area-name" name="areaname" id="areaname" value="" readonly="true"></aui:input>
		</aui:field-wrapper>
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="false" cssClass="manage-layout ${cssClass}"  >
			<aui:input label="county" name="county" id="county" value="" readonly="true"></aui:input>
		</aui:field-wrapper>
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="false" last="true" cssClass="manage-layout ${cssClass}"  >
			<aui:input label="stipendlocation" name="stipendlocation" id="stipendlocation" value="" readonly="true"></aui:input>
		</aui:field-wrapper>
		<aui:field-wrapper inlineField="true" inlineLabel="left" first="true" last="true" cssClass="manage-layout ${cssClass}"  >
			<aui:input label="zipcode" name="zipcode" id="zipcode" value="" readonly="true"></aui:input>
		</aui:field-wrapper>
		
		<br class="clear-both" />
	   	<div>
	   		<button id="calculateStipend" class="btn btn-primary" type="button" onclick="calculate()">Calculate Stipend</button>		
	   		<button id="clearForm" class="btn btn-primary" type="button" onclick="clearStipend()">Clear Form</button>		
			<button id="ExitForm" class="btn btn-primary" type="button" onclick="exitForm()">Exit</button>
		</div>
		<br class="clear-both" /><br class="clear-both" />

	</div>
	</aui:form>
</div>

</div>

<aui:script use="aui-io-request,aui-parse-content,aui-modal">

		// IE9 fix
		if(!window.console) {
		    var console = {
		        log : function(){},
		        warn : function(){},
		        error : function(){},
		        time : function(){},
		        timeEnd : function(){}
		    }
		}

	  window.calculateStipend = function(src) {
		  A.one("#stipendCalculator").show();
  		modalTransfer.render();
     	modalTransfer.show();
     	
       }
	  
	  window.closeContact = function(src) {	
      }
	  
	  var modalTransfer = new A.Modal({
			headerContent: '<h4 style = "float:center"><liferay-ui:message key="Calculate Monthly Stipend Amount" /></h4>',
	        bodyContent: A.one("#stipendCalculator"),
	        centered: true,
	        destroyOnHide: false,
	        modal: true,
	        render: '#modalTransferStipend', 
	        resizable: {
	          handles: 'b, r'
	        },
	        zIndex: 1000,
	        width: 1000
	    }).hide();
		
	  	window.calculate = function(src) {
	  		var zip = A.one('#<portlet:namespace/>zip' ).val();
    		if ( zip == '') {
    			alert("Please enter your zip code");
    			return;
    		}
    		window.caretIo( '<portlet:resourceURL><portlet:param name="action" value="calculateStipend" /></portlet:resourceURL>', 'json',
					{ 	
    					zip:  A.one('#<portlet:namespace/>zip').val(),
				  		tier: A.one('#<portlet:namespace/>tier').val() 
				  	},
					function( data ) {
				  		if(data.error!= null) {
				  			//alert(data.error);
				  			  A.one ( '#<portlet:namespace/>stipendError').html("<b>"+data.error+"</b>").addClass( 'missing-required-input' );
				  			  A.one ( '#<portlet:namespace/>zip' ).addClass( 'missing-required-input' );
				  			  A.one ( '#<portlet:namespace/>stipendhours' ).val("");
							  A.one ( '#<portlet:namespace/>wage' ).val("");
							  A.one ( '#<portlet:namespace/>stipend' ).val("");
							  A.one ( '#<portlet:namespace/>areaname' ).val("");
							  A.one ( '#<portlet:namespace/>county' ).val("");
							  A.one ( '#<portlet:namespace/>stipendlocation' ).val("");
				  			  A.one ( '#<portlet:namespace/>times4' ).val("");
				  			  //A.one ( '#<portlet:namespace/>zipcode' ).val("");
				  			//A.one ( '#<portlet:namespace/>error' ).val(data.error);
				  		} else {
				  			A.one ( '#<portlet:namespace/>stipendError').html("");
				  			  A.one ( '#<portlet:namespace/>stipendhours' ).val(data.hours);
				  			  A.one ( '#<portlet:namespace/>times4' ).val(data.times4);
							  A.one ( '#<portlet:namespace/>wage' ).val("$" + data.wage);
							  A.one ( '#<portlet:namespace/>stipend' ).val("$" + data.stipend);
							  A.one ( '#<portlet:namespace/>areaname' ).val(data.areaname);
							  A.one ( '#<portlet:namespace/>county' ).val(data.county);
							  A.one ( '#<portlet:namespace/>stipendlocation' ).val(data.location);
							  A.one ( '#<portlet:namespace/>zipcode' ).val(data.zipcode);
							  
				  		}
						  
					} 
			);

	     }
	  		
		window.clearStipend = function() { 
		  A.one ( '#<portlet:namespace/>zip' ).val("");
		  A.one ( '#<portlet:namespace/>stipendhours' ).val("");
		  A.one ( '#<portlet:namespace/>times4' ).val("");
		  A.one ( '#<portlet:namespace/>wage' ).val("");
		  A.one ( '#<portlet:namespace/>stipend' ).val("");
		  A.one ( '#<portlet:namespace/>areaname' ).val("");
		  A.one ( '#<portlet:namespace/>county' ).val("");
		  A.one ( '#<portlet:namespace/>stipendlocation' ).val("");
		  A.one ( '#<portlet:namespace/>zipcode' ).val("");
	    }
		
		window.exitForm = function(src) { 
			clearStipend();
			modalTransfer.hide();
		}
	  		
	  
</aui:script>

<!--  STIPEND CALCULATOR... -->