<%@ include file="/jsp/init.jsp" %>
  
<portlet:actionURL var="loadOnlineWelcomeVeteran">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="loadEntry"/>
	<portlet:param name="entry" value="VET_DASHBOARD"/>
</portlet:actionURL>

<portlet:actionURL var="loadOnlineWelcomeCaregiver">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="loadEntry"/>
	<portlet:param name="entry" value="CGV_DASHBOARD"/>
</portlet:actionURL>

<hr style="margin-top: 4px; padding-top: 10px; margin-bottom: 1px; padding-bottom: 1px">

<%@include file="/jsp/online/application/util/printInclude.jsp" %>

<div class="home-button-content" style="margin: 0px; padding: 0px;">

<div>
	<div style="float: right;">
	    <div class="home-button-content">
			<c:choose>
				<c:when test="${true eq isVet}">
					<a class="icon-home home-button" href="${loadOnlineWelcomeVeteran}" ></a>
				</c:when>
				<c:otherwise>
					<a class="icon-home home-button" href="${loadOnlineWelcomeCaregiver}" ></a>
				</c:otherwise>
			</c:choose>
			<div class="home-button-centered-text">Home</div>
		</div>
	</div>
    <div style="float:left;">
	    <div class="online-prose-block" style="padding-bottom: 10px; padding-top: 10px; padding-left: 10px; margin-bottom: 15px; padding-bottom: 10px;">
	    	<span style="display: inline; font-family: Arial,Helvetica,sans-serif; font-size: 26px;">Welcome - Introduction:</span>
	        <span class="online-prose" style="display: inline;">Welcome to the Program of Comprehensive Assistance for Family Caregivers (PCAFC)</span>
	    </div>    
    </div>	
</div>

<div class="online-prose-block-outer" style="display: inline; float: left;">

    <div class="online-prose-block" style="margin-top: 0px; padding-top: 0px;">
<p class="online-prose">Thank you for your interest in applying for VA's Program of Comprehensive Assistance for Family Caregivers (PCAFC). Veterans and caregivers who wish to apply for the PCAFC are required to complete and sign VA Form 10-10CG to begin the application process.  In order for VA to confirm your identity and enable your digital signature, all Veteran and caregiver applicants must have an AccessVA account prior to starting the on-line application.  An account can be created in just a few minutes using a safe and secure log in process.  Visit <a target = "_blank" href="https://DNS.URL       /accessva/">https://DNS.URL       /</a> to register for an account.  Please confirm all parties are registered at this time or you will not be able to successfully proceed with this process.</p>
	<c:choose>
		<c:when test="${true eq isVet}">
<p class="online-prose">To ensure identity protection, both the Veteran and caregiver(s) applicants need to complete the on-line process separately.  All applicants are required to provide personal information including address, date of birth and social security number; however the caregiver with whom you are applying will not have access to the information you submit.</p>
		</c:when>
		<c:otherwise>
<p class="online-prose">To ensure identity protection, both the Veteran and caregiver(s) applicants need to complete the on-line process separately.  All applicants are required to provide personal information including address, date of birth and social security number.  The Veteran and any other caregivers applying will not have access to the information you submit.</p>
		</c:otherwise>
	</c:choose>
<p class="online-prose">Once each applicant signs his/her section of the application, the joint application will be received by the local VA facility where the Veteran receives care, as designated on the Veteran portion of the application.</p>
	<c:choose>
		<c:when test="${true eq isVet}">
<p class="online-prose">Please note if you are acting on behalf of a Veteran applying for the PCAFC and have the legal authority to do so, such as Power of Attorney (POA), there will be an opportunity for you to upload this documentation at the end of the application process.  Please have this information readily available.</p>
		</c:when>
	</c:choose>		
<p class="online-prose">Once the application is submitted, applicants may log back in the system at any time to check the status of his/her current application and view their application history.</p>
<p class="online-prose">Thank you again for your interest in the Program of Comprehensive Assistance for Family Caregivers.</p>
<p class="online-prose">If you have additional questions or would like to learn more about ways VA supports caregivers, please visit <a target="_blank" href="http://DNS.URL       /">http://DNS.URL       /</a> or contact your local Caregiver Support Coordinator.  VA's Caregiver Support Line is also available by calling toll-free <span style="font-weight: bold;">1-855-260-3274</span>.</p>
<br>
<p class="online-prose" style="background-color: #F0F0F0;">The following screens will guide you through the current 10-10CG application.  The form's instructions for submitting the application have not yet been updated to account for the ability to apply online.  References to printing and mailing the form to the Health Eligibility Center for expedited processing are no longer valid.  Thank you for your understanding as VA works to update instructions within the application.</p>
	</div>
</div>


</div>

      
		