<%@ include file="/jsp/init.jsp" %>


<style>

button {
    cursor: pointer;
    text-align: center; 
    transition: background 250ms ease-in-out, 
                transform 150ms ease;
    -webkit-appearance: none;
    -moz-appearance: none;
}

button:hover,
button:focus {
	
}

button:focus {
    outline: 1px solid #fff;
    outline-offset: -4px;
}

button:active {
     transform: scale(1.20); 
}

ul {
	margin-left: -20px;
    display: block;
    font-family: Arial,Helvetica,sans-serif;  
    background-color: #FFFFFF;
    color: #000000;
    text-align: left;
    font-size: 16px;	
}	
.tdbold {
	font-weight: 600;
}

.q-button {
    float: left;
	background-color: #dbebfd;
	color: #000000;
    display: block;
    font-family: Arial,Helvetica,sans-serif;  
    color: #000000;
    text-align: left;
    font-size: 16px;
    font-weight: 600;	
	margin: 3px;
	padding: 10px;
	border: none;
}


</style>
  
<portlet:actionURL var="loadOnlineWelcomeVeteran">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="loadEntry"/>
	<portlet:param name="entry" value="VET_DASHBOARD"/>
</portlet:actionURL>
<portlet:actionURL var="loadOnlineWelcomeCaregiver">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="loadEntry"/>
	<portlet:param name="entry" value="CGV_DASHBOARD"/>
</portlet:actionURL>
<portlet:actionURL var="loadApplyNowVeteran">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="loadEntry"/>
	<portlet:param name="entry" value="VET_APPLY_NOW"/>
</portlet:actionURL>
<portlet:actionURL var="loadApplyNowCaregiver">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="loadEntry"/>
	<portlet:param name="entry" value="CGV_APPLY_NOW"/>
</portlet:actionURL>

<hr style="margin-top: 4px; padding-top: 8px; margin-bottom: 1px; padding-bottom: 1px">

<%@include file="/jsp/online/application/util/printInclude.jsp" %>

<div class="home-button-content" style="margin: 0px; padding: 0px;">
	<div style="float: right;">
	    <div class="home-button-content" >
			<c:choose>
				<c:when test="${true eq isVet}">
					<a class="icon-home home-button" href="${loadOnlineWelcomeVeteran}" ></a>
				</c:when>
				<c:otherwise>
					<a class="icon-home home-button" href="${loadOnlineWelcomeCaregiver}" ></a>
				</c:otherwise>
			</c:choose>
			<div class="home-button-centered-text">Home</div>
		</div>
	</div>
	<div style="display: inline; float: left;">
		<div class="online-prose-block" style="padding-top: 0px; margin-top: 0px;">
		<p class="online-prose tdbold">Program of Comprehensive Assistance for Family Caregiver (PCAFC)</p>
		<br>
		<p class="online-prose tdbold">Am I Eligible?</p>
		<p class="online-prose">You may be eligible if:</p>
		
		<c:choose>
			<c:when test="${true eq isVet}">
				<ul class="online-prose"><li>You are a Veteran or Service member with a date of medical discharge</li></ul>
				<p class="online-prose tdbold" style="margin-left: 20px">AND</p>
				<ul><li>You are a Veteran or Service member who requires at least six months of continuous supervision or assistance with performing basic functions of everyday life due to a serious injury or mental disorder (including psychological trauma or other mental disorder) incurred or aggravated in the  line of duty on or after September 11, 2001.</li></ul>
			</c:when>
			<c:otherwise>
				<ul class="online-prose"><li>You are at least 18 years of age</li></ul>
				<p class="online-prose tdbold" style="margin-left: 20px">AND</p>
				<ul><li>You are a family member of the Veteran or Service member named in this application OR you are not a family member and you reside with the Veteran or Service member or will do so upon approval AND you agree to perform personal care services as the Primary or Secondary Family Caregiver for the Veteran or Service member.</li></ul>
			</c:otherwise>
		</c:choose>		
		<br>
		<p class="online-prose">If you believe you may be eligible for PCAFC and wish to apply on-line, select "Start Application" to begin the application process.</p>
		<p class="online-prose">If you need assistance or prefer to submit a paper application, please contact the Health Resource Center (HRC) at 1-877-222-VETS.</p>
		<hr>
		<p class="online-prose" style="color: red">Note: At this time, the PCAFC is not available to Veterans or Service members living in a foreign country.</p>
		<div style="margin: auto; width: 50%; padding: 3px;">
			<c:choose>
				<c:when test="${true eq isVet}">
					<button class="aui-button q-button" onclick="location.href = '${onlineActionURL}&<portlet:namespace/>javax.portlet.action=doAction&<portlet:namespace/>action=loadEntry&<portlet:namespace/>entry=VET_APPLY_NOW'">Start Application</button>
				</c:when>
				<c:otherwise>
					<button class="aui-button q-button" onclick="location.href = '${onlineActionURL}&<portlet:namespace/>javax.portlet.action=doAction&<portlet:namespace/>action=loadEntry&<portlet:namespace/>entry=CGV_APPLY_NOW'">Start Application</button>
				</c:otherwise>
			</c:choose>	
			<div style="margin: 2px; float: left;">&nbsp;</div>
			<c:choose>
				<c:when test="${true eq isVet}">
					<button class="aui-button q-button" onclick="location.href = '${loadOnlineWelcomeVeteran}'">Cancel Application</button>
				</c:when>
				<c:otherwise>
					<button class="aui-button q-button" onclick="location.href = '${loadOnlineWelcomeCaregiver}'">Cancel Application</button>
				</c:otherwise>
			</c:choose>				
		</div>
		<div style="clear: both;"></div>
		<p class="online-prose tdbold" style="margin-bottom: 2px; padding-bottom: 2px;">Additional Caregiver Support</p>
		<p class="online-prose" style="margin-top: 2px; padding-top: 2px;">The PCAFC is just one way VA supports Veterans and caregivers.  To learn more about the supports and services available to support caregivers of Veterans of all eras, please visit <a target="_blank" href="http://DNS.URL       /">http://DNS.URL       /</a> or contact VA's Caregiver Support Line at <span class="tdbold">1-855-260-3274</span>.</p>
		</div>	
	</div>
</div>
