<%@ include file="/jsp/init.jsp" %>
<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet" %>

<style>
table {
	border-collapse: collapse;
}
td {
	border: 1px solid #000000;
	padding-right: 5px;
	padding-left: 7px;
	padding-top: 10px;
	padding-bottom: 10px;
	vertical-align: top;
	font-family:  Arial, Helvetica, sans-serif;
	font-size: 16px;
}
table.fixed {
	table-layout: fixed;
	min-width: 900px;
	max-width: 900px;
	width: 900px;
	margin-top: 7px;
	margin-left: 15px;
}
table.fixed td {
	overflow: hidden;
}
button {
    cursor: pointer;
    text-align: center; 
    transition: background 250ms ease-in-out, 
                transform 150ms ease;
    -webkit-appearance: none;
    -moz-appearance: none;
}

button:hover,
button:focus {
	 background: #FFFFFF; 
}

button:focus {
    outline: 1px solid #fff;
    outline-offset: -4px;
}

button:active {
     transform: scale(1.5); 
}

.tdbold {
	font-weight: 600;
}
.dash-buttons-block {
	display: inline-block;
	/* display: block; */
	margin: auto;
	width: 75%;
	padding: 10px;
}
.dash-button-outer {
    display: block;
    font-family: Arial,Helvetica,sans-serif;  
    background-color: #FFFFFF;
    color: #000000;
    border: 2px;
    border-style: solid;
    border: 3px;
    /* border-color: #5B216D; */
	border-color: #6b2781;
    border-style: solid;
    padding: 5px 5px; 5px; 5px;	
	max-width: 800px;
    min-width: 800px;
	/* cursor: pointer; */
	margin-bottom: 4px;
}
.csp-info-div {
    text-align: left;
    text-decoration: none;
	text-indent: 0px;
    font-family: Arial,Helvetica,sans-serif;    
    display: inline-block;
    font-size: 16px;
	font-weight: 500;
    margin: 2px 2px;
    text-align: left;
	width: 760px;
    max-width: 760px;
	min-width: 760px;
}
.csp-info-button-plus {
    background-color: #FFFFFF;
    color: #000000;
    border: 0;
    text-align: left;
    text-decoration: none;
	text-indent: -5px;
    font-family: Arial,Helvetica,sans-serif;    
    display: inline-block;
    font-size: 16px;
	font-weight: 500;
    margin: 2px 2px;
}
.online-prose {
	display: block;
	font-family:  Arial, Helvetica, sans-serif;
	font-size: 16px;
	display: inline-block;
	margin: auto;
	width: 100%;
	padding-top: 5px;
	padding-right: 0px;
	padding-bottom: 9px;
	padding-left: 7px;
}
.online-prose-definitions {
	display: block;
	font-family:  Arial, Helvetica, 	sans-serif;
	font-size: 16px;
	display: inline-block;
	margin: auto;
	margin-left: 10px;
	width: 100%;
	padding-top: 5px;
	padding-right: 0px;
	padding-bottom: 7px;
	padding-left: 7px;
}
.online-definitions-title {
	font-size: 16px;
	font-weight: 600; 
	clear: both;
}
.font-weight-normal {
	font-weight: normal;
}

.online-prose-definitions-address-line {
	display: block;
	text-indent: 40px;
	font-weight: 600;
}
.definitions-seventies-logo-img {
	float: left; 
	width: 60px; 
	height: 60px;
}
.definitions-seventies-logo-text {
	float: left;
	background-color: #FFFFFF;
	color: #089DE4;
	margin-top: 15px;
	margin-left: 5px;
	font-family:  Arial, Helvetica, sans-serif;
	font-size: 22px;
    font-weight: 600;		
}
</style>

<script type="text/javascript">
      function clickAction(section) {
		var elem1 = document.getElementById(section);
		if (elem1) {
			if (elem1.innerHTML == '+') {
				openSection(section);
				elem1.innerHTML = "-";
			}
			else {
				closeSection(section);
				elem1.innerHTML = "+";
			}
		}
      }
	  function openSection(section) {
		var xId = 'x' + section;
		var elem2 = document.getElementById(xId);
		if (elem2) {
			elem2.style.display = '';
		}
	  }
	  function closeSection(section) {
		var xId = 'x' + section;
		var elem2 = document.getElementById(xId);
		if (elem2) {
			elem2.style.display = "none";
		}
	  }	  
      
</script>

<portlet:actionURL var="loadOnlineWelcomeVeteran">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="loadEntry"/>
	<portlet:param name="entry" value="VET_DASHBOARD"/>
</portlet:actionURL>

<portlet:actionURL var="loadOnlineWelcomeCaregiver">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="loadEntry"/>
	<portlet:param name="entry" value="CGV_DASHBOARD"/>
</portlet:actionURL>

<hr style="margin-top: 4px; padding-top: 10px; margin-bottom: 1px; padding-bottom: 1px">
<%@include file="/jsp/online/application/util/printInclude.jsp" %>

<div>
	<div class="definitions-seventies-logo-img">
	<img src="<%=request.getContextPath()%>/images/va4.jpg" />
	</div>
	<span class="definitions-seventies-logo-text">Department of Veteran Affairs</span>
	<div style="float: right;">

	    <div class="home-button-content">
			<c:choose>
				<c:when test="${true eq isVet}">
					<a class="icon-home home-button" href="${loadOnlineWelcomeVeteran}" ></a>
				</c:when>
				<c:otherwise>
					<a class="icon-home home-button" href="${loadOnlineWelcomeCaregiver}" ></a>
				</c:otherwise>
			</c:choose>
			<div class="home-button-centered-text">Home</div>
		</div>
	</div>
	
	<br style="clear: both;">
	<span style="font-family: Arial, Helvetica, sans-serif; font-size: 14px;">Instructions for Completing Application for the Program of Comprehensive Assistance for Family Caregivers</span>
	<div style="clear: both; line-height: 50%;">&nbsp;</div> 
	<!-- <br style="clear: both;"> -->
	<span style="font-family: Arial, Helvetica, sans-serif; font-size: 18px; font-weight: 600;">Please Read Before You Start...</span>
	<div style="clear: both; line-height: 50%;">&nbsp;</div> 	
	<span style="margin-left: 10px; font-style: italic; font-family: Arial, Helvetica, sans-serif; font-size: 14px;">Click on the topics for more information</span>
	<br style="clear: both; line-height: 100%;">
	
	<div class="dash-buttons-block">
	
	
	<div class="dash-button-outer" tabindex="0">
		<span>
			<span class='csp-info-div'>What is VA Form 10-10CG used for?</span>
			<button class="csp-info-button-plus" onClick="clickAction('10-10CG');">
					<span id="10-10CG" class="" style="font-family: Arial,Helvetica,sans-serif; ">+</span>
			</button>			
		</span>
	</div>	
	<div id="x10-10CG" class="online-prose" style="display: none;" tabindex="0">
		To apply for VA's Program of Comprehensive Assistance for Family Caregivers. VA will use the information on this form to assist in determining your eligibility; a clinical assessment will also be required. An eligible Veteran may appoint one (1) Primary Family Caregiver and up to two (2) Secondary Family Caregivers. On average, it will take 15 minutes to complete the application including the time it will take you to read instructions, gather the necessary facts and fill out the form. Each time a new Caregiver is appointed a new Form 10-10CG is required.
	</div>
	
	<div class="dash-button-outer" tabindex="0">
		<span>
			<span class='csp-info-div'>Where can I get help filling out the form and answers to questions?</span>
			<button class="csp-info-button-plus" onClick="clickAction('help');">
					<span id="help" class="" style="font-family: Arial,Helvetica,sans-serif; ">+</span>
			</button>			
		</span>	
	</div>	
	<div id="xhelp" class="online-prose" style="display: none;" tabindex="0">
You may use ANY of the following to request assistance: Ask VA to help you fill out the form by calling us at 1-877-222-VETS (8387). Access VA's website at <a target="_blank" href="http://DNS.URL">http://DNS.URL</a> and select "Contact the VA". Locate and contact the Caregiver Support Coordinator at your nearest VA health care faDNS.URL</a>. Contact the National Caregiver Support Line by calling PIIor a Veterans Service Organization.
	</div>

	<div class="dash-button-outer" tabindex="0">
		<span>
			<span class='csp-info-div'>Definitions of terms used in this form</span>
			<button class="csp-info-button-plus" onClick="clickAction('definitions');">
					<span id="definitions" class="" style="font-family: Arial,Helvetica,sans-serif; ">+</span>
			</button>			
		</span>
	</div>
	<div id="xdefinitions" class="online-prose-definitions" style="display: none;" tabindex="0">
		<div class="online-definitions-title">Caregiver Support Coordinator (CSC):</div>
			<div class="font-weight-normal">
				A VA clinical professional who connects Caregivers of Veterans with VA and community resources offering supportive programs and services. Caregiver Support Coordinators are located at every VA medical center and are designated specialists in Caregiving issues.
				<div style="clear: both; line-height: 50%;">&nbsp;</div>
			</div>		
		
			<div class="online-definitions-title">Family Member:</div>
			<div class="font-weight-normal">
				A member of the Veteran's or Service member's family (including a parent, a spouse, a son or daughter, a step-family member, and an extended family member), or an individual who lives full-time with the Veteran or Service member, or will do so if approved as a Primary or Secondary Family Caregiver.
				<div style="clear: both; line-height: 50%;">&nbsp;</div>
			</div>

			<div class="online-definitions-title">Injured in the Line of Duty (LOD):</div>
			<div class="font-weight-normal">
				An injury incurred or aggravated during active military service, unless the injury resulted from the Veteran's or Service member's willful misconduct or abuse of alcohol or drugs, or it occurred while that individual was avoiding duty by desertion, or absent without leave which materially interfered with the performance of military duty.
				<div style="clear: both; line-height: 50%;">&nbsp;</div>
			</div>

			<div class="online-definitions-title">Power of Attorney (POA):</div>
			<div class="font-weight-normal">
				A Power of Attorney is an authorization for someone to act on the Veteran's or Service member's behalf when completing this form.
				<div style="clear: both; line-height: 50%;">&nbsp;</div>
			</div>

			<div class="online-definitions-title">Primary Family Caregiver:</div>
			<div class="font-weight-normal">
				A Family Member (defined herein), who is designated as a "primary provider of personal care services" under 38 U.S.C. 1720G(a)(7)(A); and who meets the requirements of 38 C.F.R. 71.25.
				<div style="clear: both; line-height: 50%;">&nbsp;</div> 
			</div>

			<div class="online-definitions-title">Representative:</div>
			<div class="font-weight-normal">
				Refers to a Veteran's or Service member's court-appointed legal guardian or special guardian, Durable POA for Health Care, or other designated health care agent. Copies of documentation regarding representatives are requested on this application.
				<div style="clear: both; line-height: 50%;">&nbsp;</div>
			</div>				
			
			<div class="online-definitions-title">Secondary Family Caregiver:</div>
			<div class="font-weight-normal">
				An individual approved as a "provider of personal care services" for the eligible Veteran under 38 U.S.C. 1720G(a)(7)(A); meets the requirements of 38 C.F.R. 71.25; and generally serves as a back-up to the Primary Family Caregiver.
				<div style="clear: both; line-height: 50%;">&nbsp;</div>
			</div>
 
			<div class="online-definitions-title">Stipend:</div>
			<div class="font-weight-normal">
				An allowance given to a Primary Family Caregiver in acknowledgement of the sacrifices they are making to care for a seriously injured eligible Veteran (as defined in 38 C.F.R 71.15).
				<div style="clear: both; line-height: 50%;">&nbsp;</div>
			</div>
	</div>


	<div class="dash-button-outer" tabindex="0">
		<span>
			<span class='csp-info-div'>Who should apply for VA's Program of Comprehensive Assistance for Family Caregivers?</span>
			<button class="csp-info-button-plus" onClick="clickAction('whoShouldApply');">
				<span id="whoShouldApply" class="" style="font-family: Arial,Helvetica,sans-serif; ">+</span>
			</button>			
		</span>
	</div>
	<div id="xwhoShouldApply" style="display: none;" tabindex="0">
		<table class="fixed">
			<col style="width: 207px;" />
			<col style="width: 315px;" />
			<col style="width: 189px;" />
			<col style="width: 189px;" />
			<tr>
				<td>IF THE INDIVIDUAL IS A:</td>
				<td>AND</td>
				<td>AND</td>
				<td>THEN</td>		
			</tr>
			<tr>
				<td><span class="tdbold">Veteran</span> or <span class="tdbold">Service member</span> who has been issued a date of medical discharge from the military</td>
				<td>Requires on-going supervision or assistance with performing basic functions of everyday life due to a serious injury or mental disorder (including traumatic brain injury, psychological trauma or other mental disorder) incurred or aggravated <span class="tdbold">in the line of duty on or after September 11, 2001</span></td>
				<td>Requires at least 6 months of continuous Caregiver Support</td>
				<td>The Veteran or Service member may meet the criteria for VA's Program of Comprehensive Assistance for Family Caregivers.  Complete this form to apply</td>
			</tr>
		</table>
		<div class="online-prose" style="margin-top: 7px; margin-bottom: 7px; margin-left: 12px">
			Veterans and Service members who do not meet the criteria for VA's Program of Comprehensive Assistance for Family Caregivers may be eligible for VA health benefits and other caregiver support services. To find out about other caregiver support services, contact the Caregiver Support Coordinator (CSC) at your local VA health care facility. To obtain the name of your local CSC, contact the <span class="tdbold">Caregiver Support Line</span> at 1-855-260-3274 <span class="tdbold">or go to <a target="_blank" href="http://DNS.URL       /">http://DNS.URL       /</a> and use the Find Your Local Caregiver Support Coordinator option.</span>.		
		</div>
	</div>	
	
	
	<div class="dash-button-outer" tabindex="0">
		<span>
			<span class='csp-info-div'>Getting Started</span>
			<button class="csp-info-button-plus" onClick="clickAction('gettingStarted');">
					<span id="gettingStarted" class="" style="font-family: Arial,Helvetica,sans-serif; ">+</span>
			</button>			
		</span>
	</div>	
	<div id="xgettingStarted" class="online-prose-definitions" style="display: none;" tabindex="0">
			<div class="font-weight-normal">
				Answer all questions on the form. If you are not enrolled in VA's health care system or are currently Active Duty undergoing medical discharge, submit VA Form 10-10EZ "Application for Health Benefits" with this form. Enrolled Veterans may submit VA Form 10-10EZR "Health Benefits Renewal Form" with their completed VA Form 10-10CG to provide information updates. Do NOT exceed the designated spaces (e.g., do NOT extend Last Name into First Name area). The Veteran's or Service member's representative or POA may complete this application; however the POA/Representation documents must be provided with this application.
				<div style="clear: both; line-height: 50%;">&nbsp;</div>
			</div>		
		
			<div class="online-definitions-title">SECTION I --VETERAN AND SERVICE MEMBER GENERAL INFORMATION</div>
			<div class="font-weight-normal">
				Directions for Section I --Veteran/Service member, representative or POA, please answer all questions, sign and date.
				<div style="clear: both; line-height: 50%;">&nbsp;</div>
			</div>

			<div class="online-definitions-title">SECTION II --PRIMARY FAMILY CAREGIVER GENERAL INFORMATION</div>
			<div class="font-weight-normal">
				Directions for Section II --Primary Family Caregiver applicant, please answer all questions, including health insurance information, sign and date.
				<div style="clear: both; line-height: 50%;">&nbsp;</div>
			</div>

			<div class="online-definitions-title">SECTION III --SECONDARY FAMILY CAREGIVER(S) GENERAL INFORMATION</div>
			<div class="font-weight-normal">
			Directions for Section III --Secondary Family Caregiver applicant(s) please answer all questions, sign and date. A Veteran/Service member may appoint up to two Secondary Family Caregivers but this is not required. If a Veteran/Servicemenber elects to appoint a Secondary Family Caregiver at a later time, Sections I and III in a new 10-10CG must be completed.
				<div style="clear: both; line-height: 50%;">&nbsp;</div>
			</div>
	</div>	
	
	<div class="dash-button-outer" tabindex="0">
		<span>
			<span class='csp-info-div'>Submitting your Application</span>
			<button class="csp-info-button-plus" onClick="clickAction('submitting');">
					<span id="submitting" class="" style="font-family: Arial,Helvetica,sans-serif; ">+</span>
			</button>			
		</span>
	</div>	
	<div id="xsubmitting" class="online-prose-definitions" style="display: none;" tabindex="0">
			<div class="font-weight-normal">
				1. Read Paperwork Reduction and Privacy Act Information.
				<div style="clear: both; line-height: 50%;">&nbsp;</div>
			</div>

			<div class="font-weight-normal">
				2. The Veteran or an individual delegated as the Veteran's representative/POA must sign and date the form.
				<div style="clear: both; line-height: 50%;">&nbsp;</div>
			</div>

			<div class="font-weight-normal">
				3. Attach POA/Representation documents to the application, if applicable.
				<div style="clear: both; line-height: 50%;">&nbsp;</div>
			</div>
			<div class="font-weight-normal">
				4. For expedited processing, mail this application to:
				<span class="online-prose-definitions-address-line">Program of Comprehensive Assistance for Family Caregivers</span>
				<span class="online-prose-definitions-address-line">Health Eligibility Center</span>
				<span class="online-prose-definitions-address-line">2957 Clairmont Road NE, Ste 200</span>
				<span class="online-prose-definitions-address-line">Atlanta, GA 30329-1647</span>
				<div style="clear: both; line-height: 50%;">&nbsp;</div>
			</div>			
			<div class="font-weight-normal">
				If you prefer to present or take this application in person, you may hand carry the printed and signed application to your local VA Medical Center Caregiver Support Coordinator (CSC). To obtain the name of your local CSC, contact the <span class="tdbold">Caregiver Support Line</span> at <span class="tdbold">1-855-260-3274 or go to <a target="_blank" href="http://DNS.URL       ">http://DNS.URL       </a> and use the Find Your Local Caregiver Support Coordinator option</span>.
				<div style="clear: both; line-height: 50%;">&nbsp;</div>
			</div>
	</div>


	<div class="dash-button-outer" tabindex="0">
		<span>
			<span class='csp-info-div'>The Paperwork Reduction ACT</span>
			<button class="csp-info-button-plus" onClick="clickAction('paperwork');">
					<span id="paperwork" class="" style="font-family: Arial,Helvetica,sans-serif; ">+</span>
			</button>			
		</span>
	</div>	
	<div id="xpaperwork" class="online-prose" style="display: none;" tabindex="0">
		This information collection is in accordance with the clearance requirements of section 3507 of the Paperwork Reduction Act of 1995. Public reporting burden for this collection of information is estimated to average 15 minutes per response, including the time to read instructions, gather necessary data, and fill out the form. Respondents should be aware that notwithstanding any other provision of law, no person shall be subject to any penalty for failing to comply with a collection of information if it does not display a currently valid OMB control number. Completion of this form is mandatory for eligible Veterans who wish to participate in the Caregiver Program.
	</div>	
	
	
	<div class="dash-button-outer" tabindex="0">
		<span>
			<span class='csp-info-div'>Privacy ACT Information</span>
			<button class="csp-info-button-plus" onClick="clickAction('privacy');">
					<span id="privacy" class="" style="font-family: Arial,Helvetica,sans-serif; ">+</span>
			</button>			
		</span>
	</div>	
	<div id="xprivacy" class="online-prose" style="display: none;" tabindex="0">
		VA is asking you to provide the information on this form under 38 U.S.C. Sections 101, 5303A, 1705, 1710, 1720B, and 1720G, in order for VA to determine your eligibility for medical benefits. Information you supply may be verified through a computer-matching program. VA may disclose the information that you put on the form as permitted by law. VA may make a "routine use" disclosure of the information as outlined in the Privacy Act systems of records, "Patient Medical Records --VA" (24VA19),
"Enrollment and Eligibility Records --VA" (147VA16), and "Health Administration Center Civilian Health and Medical program Records-- VA" (54VA17) and in accordance with the VHA Notice of Privacy Practices. Providing the requested information, including Social Security Number, is voluntary, but if any or all of the requested information is not provided, it may delay or result in denial of your request for health care benefits. Failure to furnish the information will not have any effect on any other benefits to which you may be entitled. If you provide VA your Social Security Number, VA will use it to administer your VA benefits. VA may also use this information to identify Veterans and persons claiming or receiving VA benefits, and their records, and for other purposes authorized or required by law.	
	</div>			
	
	
	
	</div>
		
</div>
