<%@ include file="/jsp/init.jsp" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions"%>

<style>

legend { 
    display: block;
	margin:0 auto;

}
.build-info {
    display:none;
}
</style>

<portlet:actionURL var="loadOnlineWelcome">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="loadEntry"/>
	<portlet:param name="entry" value="VET_DASHBOARD"/>
</portlet:actionURL>

<portlet:resourceURL var="saveApplicationExperience">
<portlet:param name="action" value="saveApplicationExperience" />
</portlet:resourceURL>

<portlet:resourceURL var="saveAttestationUrl">
<portlet:param name="action" value="saveAttestationUrl" />
</portlet:resourceURL>

<portlet:actionURL var="saveEntry">
	<portlet:param name="javax.portlet.action" value="doAction" />
	<portlet:param name="action" value="saveUserExpEsig" />
</portlet:actionURL>

<portlet:resourceURL var="getApplicationReview">
<portlet:param name="action" value="getApplicationReview" />
<portlet:param name="documId" value="${doc.documId}" />
</portlet:resourceURL>

<portlet:resourceURL var="saveApplicationVcg">
<portlet:param name="action" value="saveApplicationVcg" />
</portlet:resourceURL>

<hr style="margin-top: -10px; padding-top: -10px">

<div class="onlineFont" style="margin: 0px; padding: 0px;">
	<div style="float: right;">
	    <div class="home-button-content">
			<a class="icon-home home-button" href="${onlineActionURL}&<portlet:namespace/>javax.portlet.action=doAction&<portlet:namespace/>action=loadEntry&<portlet:namespace/>entry=VET_DASHBOARD" ></a>
			<div class="home-button-centered-text">Home</div>
		</div>
	</div>	
	
	<div class="applyWidget" id="caregiverTab">
		<div class="tabbable tabs-left">
			<div class="borderDiv">
				<div class="borderHeading"><span class="borderTitle">Progress Indicator</span></div>
		 	</div>
		 	
		 	<aui:form action="${getApplicationReview}" method="post" name="sign_fm" target="_blank">
				<c:set var="form_" value="${caretMap_['form_']}" />
				<input type="hidden" name="<portlet:namespace/>vcgAnId"	id="<portlet:namespace/>vcgAnId" value="${caretMap_['vcgAnId']}">
				<input type="hidden" name="TRACKER" value="${TRACKER}">
				<c:set var="ssnType" value="password" />
				<c:set var="person" value="${form_['veteranPersn']}" />
				<c:set var="cssClass" value="${form_['required']}" />
				<c:set var="ndx" value="veteranPersn" />
				<input type="hidden" name="uxPage" id="<portlet:namespace/>uxPage" value="${caretMap_['tabContext']}">
				<input type="hidden" name="roleId" value="1">
				<input type="hidden" name="reviewed" id="<portlet:namespace/>reviewed" value="${caretMap_['reviewed']}">
				<input type="hidden" name="documId" id="<portlet:namespace/>documId" value="${caretMap_['documId']}">
				<input type="hidden" name="signed" id="<portlet:namespace/>signed" value="${caretMap_['signed']}">
				<input type="hidden" name="complete" id="<portlet:namespace/>complete" value="${caretMap_['complete']}">

			<liferay-ui:tabs names="Step 1: Veteran Information,Step 2: Veteran Home Address,Step 3: VA Medical Center,Step 4: Review,Step 5: Veteran Signature,Step 6: Select Caregiver,Step 7: Upload Document if applicable,Step 8: Complete" refresh="false" tabsValues="tab1,tab2,tab3">
				<liferay-ui:section >
			    	<div class="applyWidgetContent">
			    		<%@include file="/jsp/online/application/vetInformation.jsp" %>
			        </div>
			    </liferay-ui:section>
			    <liferay-ui:section>
				    <div class="applyWidgetContent">
			    		<%@include file="/jsp/online/application/vetHomeAddress.jsp" %>
			        </div>
			    </liferay-ui:section>
			    <liferay-ui:section>
				    <div class="applyWidgetContent">
			    		<%@include file="/jsp/online/application/vetHealthEnrollment.jsp" %>
			        </div>
			    </liferay-ui:section>
			    <liferay-ui:section>
				    <div class="applyWidgetContent">
			    		<%@include file="/jsp/online/application/vetReview.jsp" %>
			        </div>
			    </liferay-ui:section>
			    <liferay-ui:section>
				    <div class="applyWidgetContent">
		    			<%@include file="/jsp/online/application/vetSignature.jsp" %>
		    		</div>
			    </liferay-ui:section>
			    <liferay-ui:section>
				    <div class="applyWidgetContent">
			    		<%@include file="/jsp/online/application/vetSelectCareGiver.jsp" %>
			        </div>
			    </liferay-ui:section>
			    <liferay-ui:section>
				    <div class="applyWidgetContent">
			    		<%@include file="/jsp/online/application/vetUploadDocument.jsp" %>
			        </div>
			    </liferay-ui:section>
			    <liferay-ui:section>
				    <div class="applyWidgetContent">
			    		<%@include file="/jsp/online/application/vetComplete.jsp" %>
			        </div>
			    </liferay-ui:section>
			  </liferay-ui:tabs>
			  </aui:form>			  
		</div>
	</div>
</div>


<aui:form action="${onlineActionURL}&_caret_online_WAR_caretportlet_javax.portlet.action=doAction&_caret_online_WAR_caretportlet_action=saveUserExpEsig&READ_CONFIRMATION=${user.userId}&eSig=eSig&roleId=1" method="post" id="urlInfo" name="urlInfo"></aui:form>

<aui:form action="${saveApplicationExperience}&SAVE_CONFIRMATION=${user.userId}" method="post" id="urlInfo2" name="urlInfo2">
	<input type="hidden" name="<portlet:namespace/>uXtab" value="1">	
</aui:form>


<%-- @ include file="/jsp/tools/esigWidget.jsp" --%>
${eSigWidget} 


<aui:script use="aui-modal,aui-tabview,aui-io-request">
	A.on('domready', function( event ) {
		var tabNumber = A.one ('#<portlet:namespace/>uxPage').val();
		if (tabNumber >= 0) {
			var node = A.one('.nav-tabs').getElementsByTagName('li')._nodes[tabNumber];
			node.childNodes[1].click();
		}		
		
		var reviewed = A.one ('#<portlet:namespace/>reviewed').val();
		var signed = A.one ('#<portlet:namespace/>signed').val();
		if (reviewed == 'true') {
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[4].childNodes[1].disabled = false;
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[4].childNodes[1].setAttribute("class", "");
    		A.one("#<portlet:namespace />digitalSignature").attr({'disabled' : false}); 
		} else {
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[4].childNodes[1].disabled = true;
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[4].childNodes[1].setAttribute("disabled", "disabled");
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[4].childNodes[1].setAttribute("class", "yui3-button-disabled");
		}
		if (signed == 'true') {
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[5].childNodes[1].disabled = false;
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[5].childNodes[1].setAttribute("class", "");
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[6].childNodes[1].disabled = false;
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[6].childNodes[1].setAttribute("class", "");
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[7].childNodes[1].disabled = false;
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[7].childNodes[1].setAttribute("class", "");
		} else {
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[5].childNodes[1].disabled = true;
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[5].childNodes[1].setAttribute("disabled", "disabled");
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[5].childNodes[1].setAttribute("class", "yui3-button-disabled");
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[6].childNodes[1].disabled = true;
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[6].childNodes[1].setAttribute("disabled", "disabled");
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[6].childNodes[1].setAttribute("class", "yui3-button-disabled");
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[7].childNodes[1].disabled = true;
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[7].childNodes[1].setAttribute("disabled", "disabled");
			A.one('.nav-tabs').getElementsByTagName('li')._nodes[7].childNodes[1].setAttribute("class", "yui3-button-disabled");
		}			
		
	});

	Liferay.on('showTab', function(e) {
		A.one ('#<portlet:namespace/>uxPage').val(e.selectedIndex);
		//saveApplication();
	});
		 
	window.showTab = function( tabNumber ) {
				 var node = A.one('.nav-tabs').getElementsByTagName('li')._nodes[tabNumber];
					node.childNodes[1].click();
			 }
	
	window.submitApplication = function() {
		var appCreated = false;
		if (A.one ('#<portlet:namespace/>vcgAnId').val() > 0) {
			appCreated = true;
		}		
		if (!appCreated) {
			validateFields( function ( message ) {
				var primary = A.one('#<portlet:namespace/>use_primary').val();
			   	var secondary = A.one('#<portlet:namespace/>use_secondary').val();
			   	var secondaryTwo = A.one('#<portlet:namespace/>use_secondaryTwo').val();
			   	if ( (primary=='' || primary == 0) &&
			   			(secondary=='' || secondary == 0) &&
			   			(secondaryTwo=='' || secondaryTwo == 0) ){
			   		message = message + '<li> Caregiver selection </li>';
			   	}		
	    		if ( message.length > 0 ){
		    		modalDataValidation.render();
		    		modalDataValidation.show();
					var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
					A.one ('#${ndx}_validationResult').html(msg);
		    		return false;	
		    	} else {
		    		var data = A.IO.stringify('<portlet:namespace />sign_fm', {'useDisabled': false});
					data = data.split( '<portlet:namespace />' ).join( '' );
					data = data.split( 'searchPersnprimary_' ).join( '' );
					data = data.split( 'searchPersnsecondary_' ).join( '' );
					data = data.split( 'searchPersnsecondaryTwo_' ).join( '' );
					var email2 = '';
					if ( A.one ('#<portlet:namespace />primaryPersn_email2') ){
						email2 = '&primaryPersn_email2=' + A.one ('#<portlet:namespace />primaryPersn_email2').val();
					}
					if ( A.one ('#<portlet:namespace />secondaryPersn_email2') ){
						email2 = email2 + '&secondaryPersn_email2=' + A.one ('#<portlet:namespace />secondaryPersn_email2').val();
					}
					if ( A.one ('#<portlet:namespace />secondaryTwoPersn_email2') ){
						email2 = email2 + '&secondaryTwoPersn_email2=' + A.one ('#<portlet:namespace />secondaryTwoPersn_email2').val();
					}
					data = data + email2;
					saveApplication();
		    		window.caretIo( '${onlineResourceURL}', 'json',
			  		    	{ action:'saveAttestationUrl',
			  		    	  RESOURCE_HANDLER: data }, 
							function( data1 ) {
									if ( data1.READ_CONFIRMATION == '${user.userId}' ){
										window.caretIo('${onlineResourceURL}', 'json',
												{	action: 'saveApplicationVcg',
													READ_CONFIRMATION:${user.userId},
													eSig:'',
													RESOURCE_HANDLER: data 
												},
												function( data2 ) {
													A.one ('#<portlet:namespace/>vcgAnId').val(data2.vcgAnId);
													A.one("#<portlet:namespace />complete").val(true); 
													saveApplication();
													A.one ('#${ndx}_validationResult').html("<div class='portlet-msg-info'>Application submitted succesfully.</div>");
								    				modalDataValidation.render();
							    					modalDataValidation.show();		
							    					window.location.href = A.one ('.home-button').attr('href');
										});				    		
										
				 		  			} else {
					    				A.one ('#${ndx}_validationResult').html("<div class='portlet-msg-alert'>Server busy, please wait 1 minute and try again.</div>");
					    				modalDataValidation.render();
				    					modalDataValidation.show();
				 		  			}
			  		});  
		    	}
			});
	    		 
		} 
	}
	A.one('.review-application').on(
			 'click',
			  function(e) {
				// e.preventDefault();
		    	validateFields( function ( message ) {
			    		if ( message.length > 0 ){
				    		modalDataValidation.render();
				    		modalDataValidation.show();
		    				var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
		    				A.one ('#${ndx}_validationResult').html(msg);
				    		return false;	
				    	} else {
				    		var data = A.IO.stringify('<portlet:namespace />sign_fm', {'useDisabled': false});
				    		data = data.split( '<portlet:namespace />' ).join( '' );
				    		data = data.split( 'searchPersnprimary_' ).join( '' );
				    		data = data.split( 'searchPersnsecondary_' ).join( '' );
				    		data = data.split( 'searchPersnsecondaryTwo_' ).join( '' );
				    		var email2 = '';
				    		if ( A.one ('#<portlet:namespace />primaryPersn_email2') ){
				    			email2 = '&primaryPersn_email2=' + A.one ('#<portlet:namespace />primaryPersn_email2').val();
				    		}
				    		if ( A.one ('#<portlet:namespace />secondaryPersn_email2') ){
				    			email2 = email2 + '&secondaryPersn_email2=' + A.one ('#<portlet:namespace />secondaryPersn_email2').val();
				    		}
				    		if ( A.one ('#<portlet:namespace />secondaryTwoPersn_email2') ){
				    			email2 = email2 + '&secondaryTwoPersn_email2=' + A.one ('#<portlet:namespace />secondaryTwoPersn_email2').val();
				    		}
				    		data = data + email2;
				    		  	
				    			window.caretIo( '${onlineResourceURL}', 'json',
				    	  		    	{ action:'saveApplicationExperience',
				    	  		    	  RESOURCE_HANDLER: data }, 
				    					function( data ) {
				    	  		    		A.one('.nav-tabs').getElementsByTagName('li')._nodes[4].childNodes[1].disabled = false;
											A.one('.nav-tabs').getElementsByTagName('li')._nodes[4].childNodes[1].setAttribute("class", "");
								    		A.one("#<portlet:namespace />digitalSignature").attr({'disabled' : false}); 
								    		A.one("#<portlet:namespace />reviewed").val(true); 
											A.one('#<portlet:namespace />sign_fm').submit();
				    				  	});
				    		
				    	}
			    		
						
		    		}
		    	);
			}
		);
	
	A.all('.cancel-application').on(
			 'click',
			  function() {
				 modalCancelApp.render();
				 modalCancelApp.show();
			 });

	window.modalCancelApp = new A.Modal({
	    headerContent: '<h4><liferay-ui:message key="Save Progress and Exit" /> </h4>',
	    bodyContent: A.one("#cancelAppDiv"),
	    centered: true,
	    destroyOnHide: false,
	    modal: true,
	    render: '#cancelAppModal',
	    resizable: {
	      handles: 'b, r'
	    },
	    visible: false,
	    width: 600
	});
	 
	modalCancelApp.addToolbar([
	   {
         label: 'Discard & Exit',
         on: {
	            click: function() {
		   			cancelApplication();	    
		   			window.location.href = A.one ('.home-button').attr('href');
              	}
          }
	   },
	   {
          label: 'Continue Application',
          on: {
              click: function() {
		   		modalCancelApp.hide();
              }
          }
       }
	 ]);    
	
	window.cancelApplication = function() {
		var data = A.IO.stringify('<portlet:namespace />sign_fm', {'useDisabled': false});
		data = data.split( '<portlet:namespace />' ).join( '' );
		data = data.split( 'searchPersnprimary_' ).join( '' );
		data = data.split( 'searchPersnsecondary_' ).join( '' );
		data = data.split( 'searchPersnsecondaryTwo_' ).join( '' );
			  	
			window.caretIo( '${onlineResourceURL}', 'json',
	  		    	{ action:'cancelApplicationExperience',
	  		    	  RESOURCE_HANDLER: data }, 
					function( data ) {
	  		   			window.location.href = A.one ('.home-button').attr('href');
				  	});
	}
	 
	A.all('.save-application').on(
		 'click',
		  function() {
			 modalExitApp.render();
			 modalExitApp.show();
	});
	window.modalExitApp = new A.Modal({
	    headerContent: '<h4><liferay-ui:message key="Save Progress and Exit" /> </h4>',
	    bodyContent: A.one("#exitAppDiv"),
	    centered: true,
	    destroyOnHide: false,
	    modal: true,
	    render: '#exitAppModal',
	    resizable: {
	      handles: 'b, r'
	    },
	    visible: false,
	    width: 600
	});
	 
	 modalExitApp.addToolbar([
	   {
         label: 'Save & Exit',
         on: {
	            click: function() {
		   			saveApplication();	    
		   			window.location.href = A.one ('.home-button').attr('href');
              	}
          }
	   },
	   {
          label: 'Cancel',
          on: {
              click: function() {
		   			modalExitApp.hide();
              }
          }
       }
	 ]);    	
	window.saveApplication = function() {
		var data = A.IO.stringify('<portlet:namespace />sign_fm', {'useDisabled': false});
		data = data.split( '<portlet:namespace />' ).join( '' );
		data = data.split( 'searchPersnprimary_' ).join( '' );
		data = data.split( 'searchPersnsecondary_' ).join( '' );
		data = data.split( 'searchPersnsecondaryTwo_' ).join( '' );
		var email2 = '';
		if ( A.one ('#<portlet:namespace />primaryPersn_email2') ){
			email2 = '&primaryPersn_email2=' + A.one ('#<portlet:namespace />primaryPersn_email2').val();
		}
		if ( A.one ('#<portlet:namespace />secondaryPersn_email2') ){
			email2 = email2 + '&secondaryPersn_email2=' + A.one ('#<portlet:namespace />secondaryPersn_email2').val();
		}
		if ( A.one ('#<portlet:namespace />secondaryTwoPersn_email2') ){
			email2 = email2 + '&secondaryTwoPersn_email2=' + A.one ('#<portlet:namespace />secondaryTwoPersn_email2').val();
		}
		data = data + email2;
		  	
			window.caretIo( '${onlineResourceURL}', 'json',
	  		    	{ action:'saveApplicationExperience',
	  		    	  RESOURCE_HANDLER: data }, 
					function( data ) {
	  		    		  /*
			    				A.one ('#${ndx}_validationResult').html("<div class='portlet-msg-info'>Saved your work, you can continue later where you left off.</div>");
			    				modalDataValidation.render();
		    					modalDataValidation.show();
	  		    		   */
				  	});
	}
 
	 var needServiceCall = true;
	  
	  A.all('.usps-service').on( 'keyup', function (e){ needServiceCall = true; });
	  A.all('.usps-service').on( 'change', function (e){ needServiceCall = true; });
	  
	  A.all('.field, .aui-field-select, .care-giver-name').on(
			  'change',
			function(e){
				  A.one("#<portlet:namespace />digitalSignature").attr({'disabled' : true});
				  var node = e.currentTarget;
				  if ( 'text' == node.attr('type') && node.val().length > 75){
						node.val( node.val().substring(0,75) );	
			  	  }
			  }
	  );
	  
	  var modalDataValidation = new A.Modal({
		    headerContent: '<h4><liferay-ui:message key="data-validation-header" /></h4>',
		    bodyContent: A.one("#${ndx}_validationDiv"),
		    centered: true,
		    destroyOnHide: false,
		    modal: true,
		    render: '#${ndx}_validationModal',
		    resizable: {
		      handles: 'b, r'
		    },
		    visible: false,
		    width: 600
		});
	
	 //Validation BEGIN
	 var validateFields = function ( anotherCallback ){
		  var count = 0;
		  var inputNodes = A.all('.required-input input, .required-input select');
		  var fields = "";
		  var fieldsInformation = "";
		  var fieldsHomeAdress = "";
		  var fieldsMedicalCenter = "";
		  var fieldsCaregiver = "";
		  for ( var i = 0; i < inputNodes.size() ; i++ ){
			  var node = A.one(inputNodes._nodes[i]);
			  
			  if (node == undefined  || node.attr('disabled') == true || (node.attr('id').indexOf("searchPersn") > -1) ) continue;
				if ( 'select-one' == node.attr('type') ){
	    			if ( node.val() == "" || node.val() == "0" ){
	    				 node.addClass( 'missing-required-input' );
	    				 var msg = "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
	    				 if (node.ancestorsByClassName('vetInfoDiv').size() > 0) {
	    					 fieldsInformation = fieldsInformation + msg;
	    				 } else if (node.ancestorsByClassName('vetAdressDiv').size() > 0) {
	    					 fieldsHomeAdress = fieldsHomeAdress + msg;
	    				 } else if (node.ancestorsByClassName('vetHealthDiv').size() > 0) {
	    					 fieldsMedicalCenter = fieldsMedicalCenter + msg;
	    				 } 
	    				 //fields = fields + msg;
	    				 count++;
	    			} else {
	    				if ( node.hasClass('missing-required-input') ){
	    					node.removeClass( 'missing-required-input' );
	    				}
	    			}
	    		}
				if ( 'text' == node.attr('type') ){
					if ( node.val() == ""   
						|| ( node.hasClass('date-field') && node.val() == 'MM/DD/YYYY' )
						|| ( node.hasClass('ssn-field') && node.val() == '###-##-####' )
						|| ( node.hasClass('email-field') && node.val() == '[USERNAME]@[DOMAIN]' )
						|| ( node.hasClass('phone-field') && node.val() == '(###) ###-####' ) ){
	   					node.addClass( 'missing-required-input' );
	   					var msg = "<li>" + node.ancestorsByClassName('required-input').one('.control-label').text().trim()+" is required</li>";
	   					 if (node.ancestorsByClassName('vetInfoDiv').size() > 0) {
	   						fieldsInformation = fieldsInformation + msg;
	    				 } else if (node.ancestorsByClassName('vetAdressDiv').size() > 0) {
	    					 fieldsHomeAdress = fieldsHomeAdress + msg;
	    				 } else if (node.ancestorsByClassName('vetHealthDiv').size() > 0) {
	    					 fieldsMedicalCenter = fieldsMedicalCenter + msg;
	    				 } 
	   					 //fields = fields + msg;		   				
	   					count++;
		   			} else {
		   				if ( node.hasClass('missing-required-input') ){
		   					node.removeClass( 'missing-required-input' );
		   				}
					}
		    	}
		    }
		  			
		  /*
			var primary = A.one('#<portlet:namespace/>use_primary').val();
		   	var secondary = A.one('#<portlet:namespace/>use_secondary').val();
		   	var secondaryTwo = A.one('#<portlet:namespace/>use_secondaryTwo').val();
		   	if ( (primary=='' || primary == 0) &&
		   			(secondary=='' || secondary == 0) &&
		   			(secondaryTwo=='' || secondaryTwo == 0) ){
		   		fields = fields + '<li> Caregiver selection </li>';
		   	}
		   
		   */
		   	if ( needServiceCall ){
		   		
			   	//USPS Address validation
			    return validateUSPSAddress( function ( validationStatus , correctAdd) {
				    
			    	var msg = '';
				    if( validationStatus == "invalid" ){
				    	if(correctAdd==null){
				    		correctAdd = "";
				    	}					
				    	msg = "<li>Address entered is not a valid USPS address. Please enter a valid USPS address. "+correctAdd+"</li>"		
				    	fieldsHomeAdress = fieldsHomeAdress + msg;
				        needServiceCall = true;
				    }else if( validationStatus == "unavailable" ){
				        msg = "<li>USPS Address Validation Service Unavailable at this time.</li>";
				        fieldsHomeAdress = fieldsHomeAdress + msg;
				        needServiceCall = true;
				    } else {
				    	needServiceCall = false;
				    }
				    if (fieldsInformation != "") {
		   				fieldsInformation = "<div class='portlet-msg-alert1'>Step 1: <ul>" + fieldsInformation +"</ul></div>"
		   			}
		   			if (fieldsHomeAdress != "") {
		   				fieldsHomeAdress = "<div class='portlet-msg-alert1'>Step 2: <ul>" + fieldsHomeAdress +"</ul></div>"
		   			}
		   			if (fieldsMedicalCenter != "") {
		   				fieldsMedicalCenter = "<div class='portlet-msg-alert1'>Step 3: <ul>" + fieldsMedicalCenter +"</ul></div>"
		   			}fields = fieldsInformation+ fieldsHomeAdress + fieldsMedicalCenter;
				  	return anotherCallback( fields);
			    });
		   	} else {
		   			if (fieldsInformation != "") {
		   				fieldsInformation = "<div class='portlet-msg-alert1'>Step 1: <ul>" + fieldsInformation +"</ul></div>"
		   			}
		   			if (fieldsHomeAdress != "") {
		   				fieldsHomeAdress = "<div class='portlet-msg-alert1'>Step 2: <ul>" + fieldsHomeAdress +"</ul></div>"
		   			}
		   			if (fieldsMedicalCenter != "") {
		   				fieldsMedicalCenter = "<div class='portlet-msg-alert1'>Step 3: <ul>" + fieldsMedicalCenter +"</ul></div>"
		   			}
					fields = fieldsInformation+ fieldsHomeAdress + fieldsMedicalCenter;
		   		anotherCallback( fields );
		   	}
		        
	  }
	 //Validation END
	 // Signature BEGIN
	 
	 ${iframeScript}

	// var preventUser = function() {
		//return "<liferay-ui:message key='back-button-lose-form-data' />";
	// }
	// window.addEventListener('beforeunload', preventUser);
	 	
		 	
	 A.all('.user-sign-input').on(
			  'keyup',
			function(e){
			  	var disabled = false;
			  	var inputNodes = A.all('.user-sign-input');
				for ( var i = 0; i < inputNodes.size() ; i++ ){
				  var anode = A.one(inputNodes._nodes[i]);
				  if ( anode.val().length == 0 ){
				  	 disabled = true;
				  }
				}
				 A.one("#<portlet:namespace />digitalSignature").attr({'disabled' : disabled});
				A.one('.nav-tabs').getElementsByTagName('li')._nodes[4].childNodes[1].setAttribute("class", "yui3-button-disabled");
	    		
			}	  
	  );
 	
		  A.all('.sign-form').on(
		    'click',
		    function() {    	
		    	
		    	validateFields( function( message ){
		    		if ( message.length > 0 ){
		    			modalDataValidation.render();
			    		modalDataValidation.show();
						var msg = "<div class='portlet-msg-alert'><liferay-ui:message key='please-address-required-fields' /><ul>" + message +"</ul></div>";
						A.one ('#${ndx}_validationResult').html(msg);
		      			return;	
		        	}
		    		
		    		var data = A.IO.stringify('<portlet:namespace />sign_fm', {'useDisabled': false});
					data = data.split( '<portlet:namespace />' ).join( '' );
					data = data.split( 'searchPersnprimary_' ).join( '' );
					data = data.split( 'searchPersnsecondary_' ).join( '' );
					data = data.split( 'searchPersnsecondaryTwo_' ).join( '' );
				
					var email2 = '';
					if ( A.one ('#<portlet:namespace />primaryPersn_email2') ){
						email2 = '&primaryPersn_email2=' + A.one ('#<portlet:namespace />primaryPersn_email2').val();
					}
					if ( A.one ('#<portlet:namespace />secondaryPersn_email2') ){
						email2 = email2 + '&secondaryPersn_email2=' + A.one ('#<portlet:namespace />secondaryPersn_email2').val();
					}
					if ( A.one ('#<portlet:namespace />secondaryTwoPersn_email2') ){
						email2 = email2 + '&secondaryTwoPersn_email2=' + A.one ('#<portlet:namespace />secondaryTwoPersn_email2').val();
					}
					data = data + email2;    		
		    		
					//This should happen after loading esig widget. Keeping here temporarily
					saveApplication();		    			
					window.caretIo( '${onlineResourceURL}', 'json',
			  		    	{ action:'saveAttestationUrl',
			  		    	  RESOURCE_HANDLER: data }, 
							function( data ) {
									if ( data.READ_CONFIRMATION == '${user.userId}' ){
							    		var loadWidget = window["loadWidget"];
							   			//window.removeEventListener('beforeunload',preventUser);
	    								if ( typeof loadWidget === "function" ){
							    			loadWidget();
	    								} else {
							    			window.location.href = A.one ('#<portlet:namespace/>urlInfo').attr('action');
	    								}
				 		  			} else {
					    				A.one ('#${ndx}_validationResult').html("<div class='portlet-msg-alert'>Server busy, please wait 1 minute and try again.</div>");
					    				modalDataValidation.render();
				    					modalDataValidation.show();
				 		  			}
						  	});
					
					/*A.one("#<portlet:namespace />signed").val(true); 
					A.one('.nav-tabs').getElementsByTagName('li')._nodes[5].childNodes[1].disabled = false;
					A.one('.nav-tabs').getElementsByTagName('li')._nodes[5].childNodes[1].setAttribute("class", "");

					A.one('.nav-tabs').getElementsByTagName('li')._nodes[6].childNodes[1].disabled = false;
					A.one('.nav-tabs').getElementsByTagName('li')._nodes[6].childNodes[1].setAttribute("class", "");
					
					A.one('.nav-tabs').getElementsByTagName('li')._nodes[7].childNodes[1].disabled = false;
					A.one('.nav-tabs').getElementsByTagName('li')._nodes[7].childNodes[1].setAttribute("class", "");*/
				
		    		
		    	});
		    }
		  );
		 //Signature END
 </aui:script>
 

 
<div id="${ndx}_validationDiv" class="yui3-skin-sam">
 <div id="${ndx}_validationResult"></div>
</div>

<div class="yui3-skin-sam">
<div id="${ndx}_validationModal"></div>
</div>

<div id="exitAppDiv" class="yui3-skin-sam" >	
Do you want to save progress and exit the application
</div>
<div class="yui3-skin-sam">
	<div id="exitAppModal"></div>
	
</div>


<div id="cancelAppDiv" class="yui3-skin-sam" >	
Do you want to discard the application and exit
</div>
<div class="yui3-skin-sam">
	<div id="cancelAppModal"></div>
	
</div>