

<%@ include file="/jsp/init.jsp" %>

<liferay-ui:search-container iteratorURL="${iteratorURL_['myVcgStatus']}" total="${total_['myVcgStatus']}" 
	emptyResultsMessage="${emptyResultsMessage}" >
	<liferay-ui:search-container-results results="${results_['myVcgStatus']}"  />

	<liferay-ui:search-container-row className="java.util.Map" escapedModel="true" keyProperty="ndx0" modelVar="vcgMap" >
	
		<liferay-ui:search-container-column-text name="Role" property="ndx0" />
		<liferay-ui:search-container-column-text name="Veteran Name" property="ndx1" />
		<liferay-ui:search-container-column-text name="Status" property="ndx2" />
		<liferay-ui:search-container-column-text name="Sign Date" property="ndx3" />

	</liferay-ui:search-container-row>

	<liferay-ui:search-iterator />
</liferay-ui:search-container>

<c:set var="form_" value="${caretMap_['form_']}" />
<c:set var="primaryApp" value="${form_['primaryApp']}" />

<c:if test="${empty form_['caregiver'] and true eq isDemoEnabled}">

<!-- demo code -->
<div id="primary-app" >

<legend><liferay-ui:message key="my-primary-application" /></legend>

<div class="circle-node">
	<canvas id="workFlow0" width="110" height="110" >
		<p>Application signed by me circle</p>
	</canvas>
	<div class="arrow-to-next"></div>
</div>

<div class="circle-node">
	<canvas id="workFlow1" width="110" height="110" >
		<p>Application submitted</p>
	</canvas>
	<div class="arrow-to-next"></div>
</div>

<div class="circle-node">
	<canvas id="workFlow2" width="110" height="110" >
		<p>Application in review</p>
	</canvas>
	<div class="arrow-to-next"></div>
</div>

<div class="circle-node">
	<canvas id="workFlow3" width="110" height="110" >
		<p>Decision made</p>
	</canvas>
</div>
</div>



<script>
	var drawWhite = function( context ){
		context.beginPath();
		context.arc(55, 55, 50, 0, 2 * Math.PI, false);
		context.lineWidth = 2;
		context.strokeStyle = 'black';
		context.stroke();
		context.beginPath();
		context.stroke();
		context.fillStyle = 'black';
		context.font = "19px Arial";
	}
	
	var drawGreen = function( context ){
		context.beginPath();
		context.arc(55, 55, 50, 0, 2 * Math.PI, false);
		var grd=context.createRadialGradient(90, 70, 5, 75, 70, 100)
		grd.addColorStop(0,'#00A000');
		grd.addColorStop(1,"#0077C0");
		context.fillStyle=grd;  
		context.fill();
		context.beginPath();
		context.stroke();
		context.fillStyle = 'white';
		context.font = "19px Arial";
	}

	var canvas = document.getElementById('workFlow0');
    var context = canvas.getContext('2d');
    if ( ${primaryApp gt 0} ){
	    drawGreen ( context );
    } else {
    	drawWhite ( context );
    }
	context.fillText("Application",10,50);
	context.fillText("Signed by",13,75);
	context.fillText("Me",43,99);
	
    	
	canvas = document.getElementById('workFlow1');
    context = canvas.getContext('2d');
    if ( ${primaryApp gt 1} ){
	    drawGreen ( context );
    } else {
    	drawWhite ( context );
    }
	context.fillText("Application",10,50);
	context.fillText("Submitted",13,75);
		
	canvas = document.getElementById('workFlow2');
	context = canvas.getContext('2d');
	if ( ${primaryApp gt 2} ){
    	drawGreen ( context );
	} else {
   		drawWhite ( context );
	}
	context.fillText("Application",10,50);
	context.fillText("In Review",13,75);
	
	canvas = document.getElementById('workFlow3');
	context = canvas.getContext('2d');
	if ( ${primaryApp gt 3} ){
    	drawGreen ( context );
	} else {
   		drawWhite ( context );
	}
	context.fillText("  Decision ",10,50);
	context.fillText("   Made ",13,75 );

</script> 


</c:if>

